/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.BasicProperty;
import com.ibm.xmi.framework.ContainLink;
import com.ibm.xmi.framework.ContainerLink;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.EnumProperty;
import com.ibm.xmi.framework.FeatureInfo;
import com.ibm.xmi.framework.Link;
import com.ibm.xmi.framework.MatchReaderAdapter;
import com.ibm.xmi.framework.ObjectInfo;
import com.ibm.xmi.framework.ObjectProperty;
import com.ibm.xmi.framework.Property;
import com.ibm.xmi.framework.ReaderAdapterImpl;
import com.ibm.xmi.framework.RefLink;
import com.ibm.xmi.framework.Workspace;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIException;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIObject;

public class MatchReaderAdapterImpl
extends ReaderAdapterImpl
implements MatchReaderAdapter {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Workspace workspace;
    private boolean debug = false;

    public Object createBasicProperty(FeatureInfo featureInfo) {
        String string = featureInfo.getClassName() == null ? featureInfo.getXMIName() : (featureInfo.getClassName().equals(this.objectsToXMINames.get(featureInfo.getObject())) ? featureInfo.getXMIName() : featureInfo.getClassName() + "." + featureInfo.getXMIName());
        BasicProperty basicProperty = this.factory.makeBasicProperty(featureInfo.getObject(), string, (String)featureInfo.getValue());
        if (basicProperty instanceof Property) {
            ((Property)basicProperty).setXMINamespace(featureInfo.getNamespace());
        }
        this.handleDeclaration(featureInfo, (Object)basicProperty);
        if (this.debug) {
            System.out.println("Made property: ");
            System.out.println(basicProperty);
        }
        return basicProperty;
    }

    public Object createContainerLink(FeatureInfo featureInfo) {
        String string = featureInfo.getClassName() == null ? featureInfo.getXMIName() : (featureInfo.getClassName().equals(this.objectsToXMINames.get(featureInfo.getObject())) ? featureInfo.getXMIName() : featureInfo.getClassName() + "." + featureInfo.getXMIName());
        ContainerLink containerLink = this.factory.makeContainerLink(featureInfo.getObject(), string, featureInfo.getValue());
        if (containerLink instanceof Link) {
            ((Link)containerLink).setXMINamespace(featureInfo.getNamespace());
        }
        this.handleDeclaration(featureInfo, (Object)containerLink);
        if (this.debug) {
            System.out.println("Made link: ");
            System.out.println(containerLink);
        }
        return containerLink;
    }

    public Object createContainLink(FeatureInfo featureInfo) {
        String string = featureInfo.getClassName() == null ? featureInfo.getXMIName() : (featureInfo.getClassName().equals(this.objectsToXMINames.get(featureInfo.getObject())) ? featureInfo.getXMIName() : featureInfo.getClassName() + "." + featureInfo.getXMIName());
        ContainLink containLink = this.factory.makeContainLink(featureInfo.getObject(), string, featureInfo.getValue());
        if (containLink instanceof Link) {
            ((Link)containLink).setXMINamespace(featureInfo.getNamespace());
        }
        this.handleDeclaration(featureInfo, (Object)containLink);
        if (this.debug) {
            System.out.println("Made link: ");
            System.out.println(containLink);
        }
        return containLink;
    }

    public Object createEnumProperty(FeatureInfo featureInfo) {
        if (this.debug) {
            System.out.println("MatchReaderAdapter createEnumProperty");
            System.out.println("value: " + featureInfo.getValue());
        }
        String string = featureInfo.getClassName() == null ? featureInfo.getXMIName() : (featureInfo.getClassName().equals(this.objectsToXMINames.get(featureInfo.getObject())) ? featureInfo.getXMIName() : featureInfo.getClassName() + "." + featureInfo.getXMIName());
        EnumProperty enumProperty = this.factory.makeEnumProperty(featureInfo.getObject(), string, (String)featureInfo.getValue());
        if (enumProperty instanceof Property) {
            ((Property)enumProperty).setXMINamespace(featureInfo.getNamespace());
        }
        this.handleDeclaration(featureInfo, (Object)enumProperty);
        if (this.debug) {
            System.out.println("Made property: ");
            System.out.println(enumProperty);
        }
        return enumProperty;
    }

    public Object createObject(ObjectInfo objectInfo) {
        Object object = super.createObject(objectInfo);
        if (object != null) {
            this.handleDeclaration(objectInfo, object);
        }
        return object;
    }

    public Object createProperty(FeatureInfo featureInfo) {
        Object object = super.createProperty(featureInfo);
        if (object != null) {
            this.handleDeclaration(featureInfo, object);
        }
        return object;
    }

    public Object createReferenceLink(FeatureInfo featureInfo) {
        String string = featureInfo.getClassName() == null ? featureInfo.getXMIName() : (featureInfo.getClassName().equals(this.objectsToXMINames.get(featureInfo.getObject())) ? featureInfo.getXMIName() : featureInfo.getClassName() + "." + featureInfo.getXMIName());
        RefLink refLink = this.factory.makeRefLink(featureInfo.getObject(), string, featureInfo.getValue());
        if (refLink instanceof Link) {
            ((Link)refLink).setXMINamespace(featureInfo.getNamespace());
        }
        this.handleDeclaration(featureInfo, (Object)refLink);
        if (this.debug) {
            System.out.println("Made link: ");
            System.out.println(refLink);
        }
        return refLink;
    }

    public int getType(FeatureInfo featureInfo) {
        if (this.debug) {
            System.out.println("MatchReaderAdapterImpl getType");
            System.out.println("name: " + featureInfo.getXMIName());
            System.out.println("className: " + featureInfo.getClassName());
        }
        Data data = null;
        data = this.file.getXMIVersion().equals("1.0") ? this.workspace.getDeclaration(featureInfo, null, true) : this.workspace.getDeclaration(featureInfo, null, false);
        if (this.debug) {
            System.out.println("decl: " + data);
        }
        if (data == null) {
            return -1;
        }
        featureInfo.setDefiner(data);
        if (data instanceof EnumProperty) {
            return 6;
        }
        if (data instanceof BasicProperty) {
            return 7;
        }
        if (data instanceof ObjectProperty) {
            return 8;
        }
        if (data instanceof ContainerLink) {
            return 3;
        }
        if (data instanceof RefLink) {
            return 2;
        }
        if (data instanceof ContainLink) {
            return 4;
        }
        return -1;
    }

    public int getType(ObjectInfo objectInfo) {
        Data data = null;
        data = this.file.getXMIVersion().equals("1.0") ? this.workspace.getDeclaration(objectInfo, null, true) : this.workspace.getDeclaration(objectInfo, null, false);
        if (data == null || !(data instanceof XMIClass)) {
            return -1;
        }
        return 10;
    }

    private void handleDeclaration(FeatureInfo featureInfo, Object object) {
        if (!(object instanceof Data)) {
            return;
        }
        Data data = (Data)featureInfo.getDefiner();
        if (data == null && this.file.getXMIVersion().equals("1.0")) {
            int n;
            if (featureInfo.getClassName() == null && (n = featureInfo.getXMIName().lastIndexOf(".")) != -1) {
                String string = featureInfo.getXMIName().substring(n + 1);
                String string2 = featureInfo.getXMIName().substring(0, n);
                featureInfo.setXMIName(string);
                featureInfo.setClassName(string2);
            }
            data = this.workspace.getDeclaration(featureInfo, (Data)object, true);
        } else if (data == null) {
            data = this.workspace.getDeclaration(featureInfo, (Data)object, false);
        }
        try {
            if (data != null) {
                ((Data)object).setXMIDefiner(data);
                data.addXMIDefined((Data)object);
            } else {
                this.file.addUnmatchedElement((Data)object);
            }
        }
        catch (XMIException xMIException) {
            xMIException.printStackTrace();
        }
    }

    private void handleDeclaration(ObjectInfo objectInfo, Object object) {
        if (!(object instanceof XMIObject)) {
            return;
        }
        Data data = null;
        data = this.file.getXMIVersion().equals("1.0") ? this.workspace.getDeclaration(objectInfo, (XMIObject)object, true) : this.workspace.getDeclaration(objectInfo, (XMIObject)object, false);
        try {
            if (data != null) {
                ((XMIObject)object).setXMIDefiner(data);
                data.addXMIDefined((Data)object);
            } else {
                this.file.addUnmatchedElement((Data)object);
            }
        }
        catch (XMIException xMIException) {
            xMIException.printStackTrace();
        }
    }

    public void resolveValue(Object object, Object object2, Object object3) {
        if (object2 instanceof ReaderAdapterImpl.TempProperty) {
            super.resolveValue(object, object2, object3);
        } else if (object2 instanceof Link) {
            Link link = (Link)object2;
            if (object3 instanceof XMIObject) {
                link.setXMIObject((XMIObject)object3);
                if (this.debug) {
                    System.out.println("resolveValue called for link: " + link);
                }
            }
        }
    }

    public void setXMIFile(XMIFile xMIFile) {
        super.setXMIFile(xMIFile);
        if (xMIFile.getXMIFiles() != null) {
            this.workspace = xMIFile.getXMIFiles().getWorkspace();
        }
    }
}

