/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.BadDefinitionException;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.DataImpl;
import com.ibm.xmi.framework.Link;
import com.ibm.xmi.framework.XMIException;
import com.ibm.xmi.framework.XMIObject;
import java.util.Collection;

public class LinkImpl
extends DataImpl
implements Link {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private XMIObject object;
    private XMIObject owner;
    private int type = 1;
    private String multiplicity;
    private Collection targets;
    private boolean serialize = true;

    public LinkImpl(Data data) {
        super(data);
    }

    public LinkImpl(Data data, XMIObject xMIObject) {
        this(data);
        this.object = xMIObject;
    }

    public LinkImpl(String string) {
        super(string);
    }

    public LinkImpl(String string, XMIObject xMIObject) {
        this(string);
        this.object = xMIObject;
    }

    public String getXMIMultiplicity() {
        return this.multiplicity;
    }

    public XMIObject getXMIObject() {
        return this.object;
    }

    public Collection getXMIObjects() {
        return this.targets;
    }

    public int getXMIType() {
        return this.type;
    }

    public boolean isXMISerialize() {
        if (this.getXMIDefiner() != null) {
            return ((Link)this.getXMIDefiner()).isXMISerialize();
        }
        return this.serialize;
    }

    public void setXMIDefiner(Data data) throws XMIException {
        if (data != null && !(data instanceof Link)) {
            throw new BadDefinitionException(data);
        }
        super.setXMIDefiner(data);
    }

    public void setXMIMultiplicity(String string) {
        this.multiplicity = string;
    }

    public void setXMIObject(XMIObject xMIObject) {
        this.object = xMIObject;
    }

    public void setXMIObjects(Collection collection) {
        this.targets = collection;
    }

    public void setXMISerialize(boolean bl) {
        this.serialize = bl;
    }

    public void setXMIType(int n) {
        this.type = n;
    }

    public String toString() {
        String string = "Unspecified";
        if (this.type == 2) {
            string = "RefLink";
        } else if (this.type == 3) {
            string = "ContainerLink";
        } else if (this.type == 4) {
            string = "ContainLink";
        }
        string = string + " " + this.getXMIName();
        if (this.getXMIObject() != null) {
            string = string + " object: [" + this.getXMIObject() + "]";
        }
        if (this.getXMIMultiplicity() != null) {
            string = string + " multiplicity: '" + this.getXMIMultiplicity() + "'";
        }
        if (this.getXMIDefiner() != null) {
            string = string + " definer: [" + this.getXMIDefiner() + "]";
        }
        if (this.getXMINamespace() != null) {
            string = string + " namespace: [" + this.getXMINamespace() + "]";
        }
        if (this.getXMIOwner() != null) {
            string = string + " owner: [" + this.getXMIOwner() + "]";
        }
        return string;
    }
}

