/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.BasicProperty;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Enum;
import com.ibm.xmi.framework.Factory;
import com.ibm.xmi.framework.FactoryRegister;
import com.ibm.xmi.framework.Link;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.NamespaceHandler;
import com.ibm.xmi.framework.Namespaces;
import com.ibm.xmi.framework.ObjectProperty;
import com.ibm.xmi.framework.Package;
import com.ibm.xmi.framework.Property;
import com.ibm.xmi.framework.WriterWrapper;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIContainer;
import com.ibm.xmi.framework.XMIObject;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.HandlerBase;

public class DeclarationFactory {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected static final String BASIC_PROPERTY_DEF = "BasicPropertyDef";
    protected static final String DEFINITION_NAME = "XMIDefinition.name";
    protected static final String CONTAIN_LINK_DEF = "ContainLinkDef";
    protected static final String CONTAINER_LINK_DEF = "ContainerLinkDef";
    protected static final String REF_LINK_DEF = "RefLinkDef";
    protected static final String ENUM_DEF = "EnumDef";
    protected static final String ENUM_DEF_LITERAL = "EnumDef.literal";
    protected static final String LITERAL_VALUE = "Literal.value";
    protected static final String ENUM_PROPERTY_DEF = "EnumPropertyDef";
    protected static final String ENUM_PROPERTY_DEF_ENUM_DEF = "EnumPropertyDef.enumDef";
    protected static final String LINK_DEF_OBJECT_DEF = "LinkDef.objectDef";
    protected static final String LINK_DEF_MULTIPLICITY = "LinkDef.multiplicity";
    protected static final String MOF_ATTRIBUTE = "Model.Attribute";
    protected static final String MOF_ATTRIB_TYPE = "Model.TypedElement.type";
    protected static final String MOF_CONTAINER = "Model.ModelElement.container";
    protected static final String MOF_CONTENTS = "Model.Namespace.contents";
    protected static final String MOF_CLASS = "Model.Class";
    protected static final String MOF_NAME = "Model.ModelElement.name";
    protected static final String MOF_PACKAGE = "Model.Package";
    protected static final String MOF_SUPERTYPES = "Model.GeneralizableElement.supertypes";
    protected static final String OBJECT_DEF = "ObjectDef";
    protected static final String OBJECT_DEF_LINKS = "ObjectDef.linkDef";
    protected static final String OBJECT_DEF_PROPERTIES = "ObjectDef.propertyDef";
    protected static final String OBJECT_DEF_SUB_DEF = "ObjectDef.subDef";
    protected static final String OBJECT_DEF_SUPER_DEF = "ObjectDef.superDef";
    protected static final String OBJECT_PROPERTY_DEF = "ObjectPropertyDef";
    protected static final String OBJECT_PROPERTY_DEF_OBJECT_DEF = "ObjectPropertyDef.objectDef";
    protected static final String UML_AGG_PROPERTY = "aggregation";
    protected static final String UML_ASSOCIATION = "Foundation.Core.Association";
    protected static final String UML_ASSOCIATION_END = "Foundation.Core.AssociationEnd";
    protected static final String UML_ASSOCIATIONS = "Foundation.Core.AssociationEnd.association";
    protected static final String UML_ASSOCIATION_ENDS = "Foundation.Core.Classifier.associationEnd";
    protected static final String UML_ATTRIBUTE = "Foundation.Core.Attribute";
    protected static final String UML_ATTRIB_TYPE = "Foundation.Core.StructuralFeature.type";
    protected static final String UML_CONNECTION = "Foundation.Core.Association.connection";
    protected static final String UML_CLASS = "Foundation.Core.Class";
    protected static final String UML_DATA_TYPE = "Foundation.Core.DataType";
    protected static final String UML_END_TYPE = "Foundation.Core.AssociationEnd.type";
    protected static final String UML_ENUMERATION = "Foundation.Data_Types.Enumeration";
    protected static final String UML_ENUM_LITERAL = "Foundation.Data_Types.Enumeration.literal";
    protected static final String UML_ENUM_LITERAL_NAME = "name";
    protected static final String UML_FEATURE = "Foundation.Core.Classifier.feature";
    protected static final String UML_GENERALIZATION = "Foundation.Core.Generalization";
    protected static final String UML_GENERALIZATIONS = "Foundation.Core.GeneralizableElement.generalization";
    protected static final String UML_IS_NAVIGABLE = "isNavigable";
    protected static final String UML_MODEL = "Model_Management.Model";
    protected static final String UML_MULTIPLICITY = "multiplicity";
    protected static final String UML_NAME = "Foundation.Core.ModelElement.name";
    protected static final String UML_NAMESPACE = "Foundation.Core.ModelElement.namespace";
    protected static final String UML_OWNER = "Foundation.Core.Feature.owner";
    protected static final String UML_PACKAGE = "Model_Management.Package";
    protected static final String UML_PRIMITIVE = "Foundation.Data_Types.Primitive";
    protected static final String UML_STEREOTYPE = "Foundation.Core.ModelElement.stereotype";
    protected static final String UML_SUBTYPE = "Foundation.Core.Generalization.subtype";
    protected static final String UML_SUPERTYPE = "Foundation.Core.Generalization.supertype";
    protected Hashtable objectToUserObject;
    protected Hashtable objectToEnum;
    protected Hashtable featureToName = new Hashtable();
    protected Hashtable objectsToNames = new Hashtable();
    protected Factory factory = FactoryRegister.getFactory();
    protected WriterWrapper wrapper = new WriterWrapper(AdapterFactoryRegister.getAdapterFactory().createWriterAdapter());
    protected String namespaceFile;
    protected Vector packagesAndClasses;
    protected Vector namespaces = new Vector();

    public DeclarationFactory() {
    }

    public DeclarationFactory(String string) {
        this.namespaceFile = string;
    }

    public DeclarationFactory(String string, String string2) {
        Namespace namespace = new Namespace(string, string2);
        this.namespaces.addElement("");
        this.namespaces.addElement(namespace);
    }

    protected void adjustNames() {
        Vector vector;
        String string;
        Object object;
        Vector<Data> vector2 = new Vector<Data>();
        Hashtable<String, Vector<Object>> hashtable = new Hashtable<String, Vector<Object>>();
        for (int i = 0; i < this.packagesAndClasses.size(); ++i) {
            vector2.add(((XMIObject)this.packagesAndClasses.elementAt(i)).getXMIDerived());
        }
        Iterator iterator = vector2.iterator();
        while (iterator.hasNext()) {
            object = (Data)iterator.next();
            string = this.wrapper.getSimpleName(object.getXMIName()).toLowerCase();
            vector = (Vector)hashtable.get(string);
            if (vector != null) {
                vector.add(object);
                continue;
            }
            vector = new Vector(5);
            vector.add(object);
            hashtable.put(string, vector);
        }
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            vector = (Vector)hashtable.get(string);
            if (vector.size() <= 1) continue;
            this.computeUniqueNames(vector);
        }
    }

    protected void computeFeatureNames(XMIContainer xMIContainer) {
        Vector vector = this.getClasses(xMIContainer);
        for (int i = 0; i < vector.size(); ++i) {
            this.computeFeatureNames(xMIContainer, (XMIObject)vector.elementAt(i));
        }
    }

    protected void computeFeatureNames(XMIContainer xMIContainer, XMIObject xMIObject) {
        String string;
        int n;
        Vector vector = this.getFeatures(xMIContainer, xMIObject);
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        for (n = 0; n < vector.size(); ++n) {
            string = this.getName((XMIObject)vector.elementAt(n));
            if (!string.equals("") && this.containsIgnoreCase(vector3, string)) {
                vector2.addElement(string);
                continue;
            }
            vector3.addElement(string);
        }
        for (n = 0; n < vector.size(); ++n) {
            string = this.getName((XMIObject)vector.elementAt(n));
            if (this.containsIgnoreCase(vector2, string)) {
                string = this.getFullName((XMIObject)vector.elementAt(n), 1);
            }
            this.featureToName.put(vector.elementAt(n), string);
        }
    }

    protected void computeUniqueNames(Vector vector) {
        Vector vector2;
        Namespace namespace;
        Object object;
        Hashtable<Namespace, Vector<Object>> hashtable = new Hashtable<Namespace, Vector<Object>>();
        Iterator iterator = vector.iterator();
        Namespace namespace2 = new Namespace(null, null);
        while (iterator.hasNext()) {
            object = (Data)iterator.next();
            namespace = object.getXMINamespace();
            if (namespace == null) {
                namespace = namespace2;
            }
            if ((vector2 = (Vector)hashtable.get(namespace)) != null) {
                vector2.add(object);
                continue;
            }
            vector2 = new Vector(5);
            vector2.add(object);
            hashtable.put(namespace, vector2);
        }
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            namespace = (Namespace)object.nextElement();
            vector2 = (Vector)hashtable.get(namespace);
            if (vector2.size() <= 1) continue;
            this.computeUniqueNamesWithinNamespace(vector2);
        }
    }

    protected void computeUniqueNamesWithinNamespace(Vector vector) {
        int n = 0;
        do {
            this.setNames(vector, ++n);
        } while (this.duplicateNames(vector) && n < 50);
    }

    protected boolean containsIgnoreCase(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!((String)vector.elementAt(i)).equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    protected boolean duplicateNames(Vector vector) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Data data = (Data)iterator.next();
            String string = data.getXMIName();
            if (string.equals("")) continue;
            int n = string.indexOf(":");
            if (n != -1) {
                string = string.substring(n + 1);
            }
            if (hashtable.get(string = string.toLowerCase()) != null) {
                return true;
            }
            hashtable.put(string, "");
        }
        return false;
    }

    protected Object getAssociationEndContainer(XMIObject xMIObject) {
        XMIObject xMIObject2 = this.getOppositeEnd(xMIObject);
        if (xMIObject2 == null) {
            return null;
        }
        return this.wrapper.getValue(xMIObject2, UML_END_TYPE);
    }

    protected Vector getClassAttributes(XMIContainer xMIContainer) {
        Vector vector = this.getClasses(xMIContainer);
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            XMIObject xMIObject = (XMIObject)vector.elementAt(i);
            Vector vector3 = this.getClassifierAttributes(xMIObject);
            for (int j = 0; j < vector3.size(); ++j) {
                vector2.addElement(vector3.elementAt(j));
            }
        }
        return vector2;
    }

    protected Vector getClasses(XMIContainer xMIContainer) {
        Iterator iterator = xMIContainer.getData(UML_CLASS).iterator();
        if (!iterator.hasNext()) {
            iterator = xMIContainer.getData(MOF_CLASS).iterator();
        }
        Vector<XMIObject> vector = new Vector<XMIObject>();
        while (iterator.hasNext()) {
            XMIObject xMIObject = (XMIObject)iterator.next();
            if (this.isDataType(xMIObject) || this.isBoolean(xMIObject)) continue;
            vector.addElement(xMIObject);
        }
        return vector;
    }

    protected Vector getClassifierAttributes(XMIObject xMIObject) {
        Vector vector = new Vector();
        Vector vector2 = this.getObjectPropertyValues(xMIObject, UML_FEATURE);
        if (vector2.size() == 0) {
            vector2 = this.getObjectPropertyValues(xMIObject, MOF_CONTENTS);
        }
        for (int i = 0; i < vector2.size(); ++i) {
            if (((XMIObject)vector2.elementAt(i)).getXMIName().equals(UML_ATTRIBUTE)) {
                vector.addElement(vector2.elementAt(i));
                continue;
            }
            if (!((XMIObject)vector2.elementAt(i)).getXMIName().equals(MOF_ATTRIBUTE)) continue;
            vector.addElement(vector2.elementAt(i));
        }
        return vector;
    }

    protected Vector getClassifierLinks(XMIObject xMIObject) {
        Vector<XMIObject> vector = new Vector<XMIObject>();
        Vector vector2 = this.getObjectPropertyValues(xMIObject, UML_ASSOCIATION_ENDS);
        for (int i = 0; i < vector2.size(); ++i) {
            String string;
            XMIObject xMIObject2 = (XMIObject)vector2.elementAt(i);
            XMIObject xMIObject3 = this.getOppositeEnd(xMIObject2);
            if (xMIObject3 == null || (string = this.getXMIValue(xMIObject3, UML_IS_NAVIGABLE)) != null && string.equals("false") || this.getName(xMIObject3).startsWith("/")) continue;
            vector.addElement(xMIObject3);
        }
        return vector;
    }

    protected Object getContainer(XMIObject xMIObject) {
        XMIObject xMIObject2;
        if (xMIObject.getXMIName().equals(UML_ASSOCIATION_END)) {
            return this.getAssociationEndContainer(xMIObject);
        }
        Vector vector = this.getObjectPropertyValues(xMIObject, UML_NAMESPACE);
        if (vector.size() == 0) {
            vector = this.getObjectPropertyValues(xMIObject, MOF_CONTAINER);
        }
        if (vector.size() == 0) {
            vector = this.getObjectPropertyValues(xMIObject, UML_OWNER);
        }
        if (vector.size() > 0 && !(xMIObject2 = (XMIObject)vector.firstElement()).getXMIName().equals(UML_MODEL)) {
            return xMIObject2;
        }
        return null;
    }

    protected Vector getFeatures(XMIContainer xMIContainer, XMIObject xMIObject) {
        Vector vector = new Vector();
        this.getSuperclasses(xMIObject, vector);
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            XMIObject xMIObject2 = (XMIObject)vector.elementAt(i);
            Vector vector3 = this.getClassifierAttributes(xMIObject2);
            Vector vector4 = this.getClassifierLinks(xMIObject2);
            for (n = 0; n < vector3.size(); ++n) {
                vector2.addElement(vector3.elementAt(n));
            }
            for (n = 0; n < vector4.size(); ++n) {
                vector2.addElement(vector4.elementAt(n));
            }
        }
        return vector2;
    }

    public String getFullName(XMIObject xMIObject, int n) {
        String string = this.getName(xMIObject);
        XMIObject xMIObject2 = (XMIObject)this.getContainer(xMIObject);
        for (int i = 0; i < n && xMIObject2 != null; ++i) {
            string = this.getName(xMIObject2) + "." + string;
            xMIObject2 = (XMIObject)this.getContainer(xMIObject2);
        }
        return string;
    }

    protected Collection getLiteralNames(XMIObject xMIObject) {
        Vector<String> vector = new Vector<String>();
        if (this.isBoolean(xMIObject)) {
            vector.addElement("true");
            vector.addElement("false");
            return vector;
        }
        Vector vector2 = this.getClassifierAttributes(xMIObject);
        if (vector2.size() == 0) {
            Vector vector3 = this.getObjectPropertyValues(xMIObject, UML_ENUM_LITERAL);
            if (vector3.size() > 0) {
                for (int i = 0; i < vector3.size(); ++i) {
                    vector.addElement(this.getXMIValue((XMIObject)vector3.elementAt(i), UML_ENUM_LITERAL_NAME));
                }
                return vector;
            }
            return vector;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            vector.addElement(this.getXMIValue((XMIObject)vector2.elementAt(i), UML_NAME));
        }
        return vector;
    }

    protected String getName(XMIObject xMIObject) {
        String string = this.getXMIValue(xMIObject, UML_NAME);
        if (string == null) {
            string = this.getXMIValue(xMIObject, MOF_NAME);
        }
        return string;
    }

    protected Vector getObjectPropertyValues(XMIObject xMIObject, String string) {
        Collection collection = this.wrapper.getProperties(xMIObject);
        Iterator iterator = collection.iterator();
        Vector<Object> vector = new Vector<Object>();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!(property instanceof ObjectProperty) || !property.getXMIName().equals(string) || property.getXMIGenericValue() == null) continue;
            vector.addElement(property.getXMIGenericValue());
        }
        return vector;
    }

    protected XMIObject getOppositeEnd(XMIObject xMIObject) {
        XMIObject xMIObject2 = (XMIObject)this.wrapper.getValue(xMIObject, UML_ASSOCIATIONS);
        Vector vector = this.getObjectPropertyValues(xMIObject2, UML_CONNECTION);
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i).equals(xMIObject)) continue;
            return (XMIObject)vector.elementAt(i);
        }
        return null;
    }

    protected Vector getPackages(XMIContainer xMIContainer) {
        Iterator iterator = xMIContainer.getData(UML_PACKAGE).iterator();
        if (!iterator.hasNext()) {
            iterator = xMIContainer.getData(MOF_PACKAGE).iterator();
        }
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        return vector;
    }

    protected void getSuperclasses(XMIObject xMIObject, Vector vector) {
        if (vector.contains(xMIObject)) {
            return;
        }
        vector.addElement(xMIObject);
        Vector vector2 = this.getObjectPropertyValues(xMIObject, UML_GENERALIZATIONS);
        for (int i = 0; i < vector2.size(); ++i) {
            XMIObject xMIObject2 = (XMIObject)this.wrapper.getValue((XMIObject)vector2.elementAt(i), UML_SUPERTYPE);
            if (xMIObject2 == null) continue;
            this.getSuperclasses(xMIObject2, vector);
        }
    }

    protected String getXMIValue(XMIObject xMIObject, String string) {
        Iterator iterator = xMIObject.getXMIProperties().iterator();
        Property property = null;
        while (iterator.hasNext()) {
            Property property2 = (Property)iterator.next();
            if (property2.getXMIName() == null || !property2.getXMIName().equals(string)) continue;
            property = property2;
            break;
        }
        if (property == null || property instanceof ObjectProperty) {
            return null;
        }
        return ((BasicProperty)property).getXMIValue();
    }

    protected boolean isBoolean(XMIObject xMIObject) {
        if (xMIObject == null) {
            return false;
        }
        if (!(xMIObject.getXMIName().equals(UML_PRIMITIVE) || xMIObject.getXMIName().equals(UML_DATA_TYPE) || xMIObject.getXMIName().equals(UML_CLASS))) {
            return false;
        }
        String string = this.getXMIValue(xMIObject, UML_NAME);
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("boolean");
    }

    protected boolean isDataType(XMIObject xMIObject) {
        if (this.getName(xMIObject).equalsIgnoreCase("boolean")) {
            return false;
        }
        Vector vector = this.getObjectPropertyValues(xMIObject, UML_STEREOTYPE);
        for (int i = 0; i < vector.size(); ++i) {
            XMIObject xMIObject2 = (XMIObject)vector.elementAt(i);
            String string = this.getName(xMIObject2);
            if (string == null || !string.equals("datatype")) continue;
            return true;
        }
        return false;
    }

    protected Vector makeClassesAndPackages(XMIContainer xMIContainer) {
        Vector vector = new Vector();
        this.objectToUserObject = new Hashtable();
        this.processNamespaces();
        this.processPackages(xMIContainer, vector);
        this.processClasses(xMIContainer, vector);
        this.processGeneralizations(xMIContainer);
        this.computeFeatureNames(xMIContainer);
        this.processAttributes(xMIContainer);
        this.processAssociationEnds(xMIContainer);
        Namespaces namespaces = new Namespaces(this.namespaces, vector);
        namespaces.setNamespaces();
        this.adjustNames();
        return vector;
    }

    public Collection makeDeclarations(XMIContainer xMIContainer) {
        return Collections.unmodifiableCollection(this.makeClassesAndPackages(xMIContainer));
    }

    public Collection makeDeclarations(Iterator iterator) {
        Vector vector = new Vector(10);
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        XMIContainer xMIContainer = new XMIContainer(vector.iterator());
        return Collections.unmodifiableCollection(this.makeClassesAndPackages(xMIContainer));
    }

    protected void makeLinkDef(XMIObject xMIObject, String string, String string2, XMIClass xMIClass, XMIClass xMIClass2) {
        String string3 = this.getXMIValue(xMIObject, UML_IS_NAVIGABLE);
        if (string3 != null && string3.equals("false") || string == null || string.indexOf("/") != -1) {
            return;
        }
        try {
            Link link = null;
            if (string2.equals("ref")) {
                link = this.factory.makeRefLink((Object)xMIClass2, string, (Object)xMIClass);
            } else if (string2.equals("container")) {
                link = this.factory.makeContainerLink((Object)xMIClass2, string, (Object)xMIClass);
            } else if (string2.equals("contained")) {
                link = this.factory.makeContainLink((Object)xMIClass2, string, (Object)xMIClass);
            }
            link.setXMIMultiplicity(this.getXMIValue(xMIObject, UML_MULTIPLICITY));
            xMIObject.setXMIDerived(link);
            link.setXMISource(xMIObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Vector orderPackages(Vector vector) {
        Vector<XMIObject> vector2 = new Vector<XMIObject>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            XMIObject xMIObject = (XMIObject)vector.elementAt(i);
            Object object = this.getContainer(xMIObject);
            if (object == null) {
                vector2.insertElementAt(xMIObject, 0);
                continue;
            }
            int n = vector2.indexOf(object);
            while (n == -1 && object != null) {
                if ((object = this.getContainer((XMIObject)object)) == null) continue;
                n = vector2.indexOf(object);
            }
            if (n == -1) {
                vector2.insertElementAt(xMIObject, 0);
                continue;
            }
            if (n == vector2.size() - 1) {
                vector2.addElement(xMIObject);
                continue;
            }
            vector2.insertElementAt(xMIObject, n + 1);
        }
        return vector2;
    }

    protected void processAssociationEnds(XMIContainer xMIContainer) {
        Iterator iterator = xMIContainer.getData(UML_ASSOCIATION).iterator();
        while (iterator.hasNext()) {
            XMIObject xMIObject = (XMIObject)iterator.next();
            Vector vector = this.getObjectPropertyValues(xMIObject, UML_CONNECTION);
            if (vector.size() != 2) continue;
            XMIObject xMIObject2 = (XMIObject)vector.elementAt(0);
            XMIObject xMIObject3 = (XMIObject)vector.elementAt(1);
            XMIObject xMIObject4 = (XMIObject)this.wrapper.getValue(xMIObject2, UML_END_TYPE);
            XMIObject xMIObject5 = (XMIObject)this.wrapper.getValue(xMIObject3, UML_END_TYPE);
            if (xMIObject4 == null || xMIObject5 == null) continue;
            String string = this.getName(xMIObject2);
            String string2 = this.getName(xMIObject3);
            xMIObject4 = (XMIObject)this.objectToUserObject.get(xMIObject4);
            xMIObject5 = (XMIObject)this.objectToUserObject.get(xMIObject5);
            if (xMIObject4 == null || xMIObject5 == null) continue;
            String string3 = this.getXMIValue(xMIObject2, UML_AGG_PROPERTY);
            String string4 = this.getXMIValue(xMIObject3, UML_AGG_PROPERTY);
            boolean bl = false;
            boolean bl2 = false;
            if (string3 != null && string3.equals("composite")) {
                bl2 = true;
            }
            if (string4 != null && string4.equals("composite")) {
                bl = true;
            }
            if (bl) {
                this.makeLinkDef(xMIObject2, (String)this.featureToName.get(xMIObject2), "contained", (XMIClass)xMIObject4, (XMIClass)xMIObject5);
                this.makeLinkDef(xMIObject3, (String)this.featureToName.get(xMIObject3), "container", (XMIClass)xMIObject5, (XMIClass)xMIObject4);
                continue;
            }
            if (bl2) {
                this.makeLinkDef(xMIObject3, (String)this.featureToName.get(xMIObject3), "contained", (XMIClass)xMIObject5, (XMIClass)xMIObject4);
                this.makeLinkDef(xMIObject2, (String)this.featureToName.get(xMIObject2), "container", (XMIClass)xMIObject4, (XMIClass)xMIObject5);
                continue;
            }
            this.makeLinkDef(xMIObject2, (String)this.featureToName.get(xMIObject2), "ref", (XMIClass)xMIObject4, (XMIClass)xMIObject5);
            this.makeLinkDef(xMIObject3, (String)this.featureToName.get(xMIObject3), "ref", (XMIClass)xMIObject5, (XMIClass)xMIObject4);
        }
    }

    protected void processAttributes(XMIContainer xMIContainer) {
        Vector vector = this.getClasses(xMIContainer);
        for (int i = 0; i < vector.size(); ++i) {
            XMIObject xMIObject = (XMIObject)vector.elementAt(i);
            XMIObject xMIObject2 = (XMIObject)this.objectToUserObject.get(xMIObject);
            Vector vector2 = this.getClassifierAttributes(xMIObject);
            for (int j = 0; j < vector2.size(); ++j) {
                try {
                    Object object;
                    XMIObject xMIObject3 = (XMIObject)vector2.elementAt(j);
                    String string = (String)this.featureToName.get(xMIObject3);
                    XMIObject xMIObject4 = (XMIObject)this.wrapper.getValue(xMIObject3, UML_ATTRIB_TYPE);
                    if (xMIObject4 == null) {
                        xMIObject4 = (XMIObject)this.wrapper.getValue(xMIObject3, MOF_ATTRIB_TYPE);
                    }
                    Property property = null;
                    if (xMIObject4 == null || (xMIObject4.getXMIName().equals(UML_PRIMITIVE) || xMIObject4.getXMIName().equals(UML_DATA_TYPE)) && !this.isBoolean(xMIObject4) || xMIObject4.getXMIName().equals(UML_CLASS) && this.isDataType(xMIObject4)) {
                        property = this.factory.makeBasicProperty((Object)xMIObject2, string);
                    } else if (xMIObject4.getXMIName().equals(UML_ENUMERATION) || this.isBoolean(xMIObject4)) {
                        object = this.getXMIValue(xMIObject4, UML_NAME);
                        Collection collection = this.getLiteralNames(xMIObject4);
                        Enum enum_ = null;
                        if (this.objectToUserObject.get(xMIObject4) != null) {
                            enum_ = (Enum)this.objectToUserObject.get(xMIObject4);
                        } else {
                            Object object2 = this.getContainer(xMIObject4);
                            if (object2 != null) {
                                object2 = this.objectToUserObject.get(object2);
                            }
                            enum_ = this.factory.makeEnum(object2, (String)object, collection.iterator());
                            this.objectToUserObject.put(xMIObject4, enum_);
                            enum_.setXMISource(xMIObject4);
                        }
                        property = this.factory.makeEnumProperty((Object)xMIObject2, string, enum_);
                    } else if (xMIObject4.getXMIName().equals(UML_CLASS)) {
                        object = (XMIObject)this.objectToUserObject.get(xMIObject4);
                        property = this.factory.makeObjectProperty((Object)xMIObject2, string, object);
                    }
                    xMIObject3.setXMIDerived(property);
                    property.setXMISource(xMIObject3);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    protected void processClasses(XMIContainer xMIContainer, Vector vector) {
        Vector vector2 = this.getClasses(xMIContainer);
        for (int i = 0; i < vector2.size(); ++i) {
            XMIObject xMIObject = (XMIObject)vector2.elementAt(i);
            Object object = this.getContainer(xMIObject);
            String string = this.wrapper.getSimpleName(this.getFullName(xMIObject, 0));
            try {
                if (object != null) {
                    object = this.objectToUserObject.get(object);
                }
                XMIClass xMIClass = this.factory.makeXMIClass(object, string);
                this.objectToUserObject.put(xMIObject, xMIClass);
                if (object == null) {
                    vector.addElement(xMIClass);
                }
                xMIObject.setXMIDerived(xMIClass);
                xMIClass.setXMISource(xMIObject);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void processGeneralizations(XMIContainer xMIContainer) {
        XMIObject xMIObject;
        Object object;
        Iterator iterator = xMIContainer.getData(UML_GENERALIZATION).iterator();
        while (iterator.hasNext()) {
            try {
                object = (XMIObject)iterator.next();
                XMIObject xMIObject2 = (XMIObject)this.wrapper.getValue(object, UML_SUBTYPE);
                xMIObject = (XMIObject)this.wrapper.getValue(object, UML_SUPERTYPE);
                if (xMIObject2 == null || xMIObject == null) continue;
                if (xMIObject2 != null) {
                    xMIObject2 = (XMIObject)this.objectToUserObject.get(xMIObject2);
                }
                if (xMIObject != null) {
                    xMIObject = (XMIObject)this.objectToUserObject.get(xMIObject);
                }
                this.factory.makeInheritance(xMIObject2, xMIObject);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = this.getClasses(xMIContainer);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            xMIObject = (XMIObject)this.objectToUserObject.get(((Vector)object).elementAt(i));
            Vector vector = this.getObjectPropertyValues((XMIObject)((Vector)object).elementAt(i), MOF_SUPERTYPES);
            for (int j = 0; j < vector.size(); ++j) {
                XMIObject xMIObject3 = (XMIObject)this.objectToUserObject.get(vector.elementAt(j));
                this.factory.makeInheritance(xMIObject, xMIObject3);
            }
        }
    }

    protected void processNamespaces() {
        if (this.namespaceFile == null) {
            return;
        }
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            NamespaceHandler namespaceHandler = new NamespaceHandler(this);
            sAXParser.parse(this.namespaceFile, (HandlerBase)namespaceHandler);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void processPackages(XMIContainer xMIContainer, Vector vector) {
        int n;
        Vector vector2 = this.getPackages(xMIContainer);
        vector2 = this.orderPackages(vector2);
        this.removeIDLPackage(xMIContainer, vector2);
        this.packagesAndClasses = (Vector)this.getClasses(xMIContainer).clone();
        for (n = 0; n < vector2.size(); ++n) {
            this.packagesAndClasses.addElement(vector2.elementAt(n));
        }
        for (n = 0; n < vector2.size(); ++n) {
            XMIObject xMIObject = (XMIObject)vector2.elementAt(n);
            Object object = this.getContainer(xMIObject);
            String string = this.wrapper.getSimpleName(this.getFullName(xMIObject, 0));
            if (object == null) {
                string = this.getName(xMIObject);
            }
            try {
                if (object != null) {
                    object = this.objectToUserObject.get(object);
                }
                Package package_ = this.factory.makePackage(object, string);
                this.objectToUserObject.put(xMIObject, package_);
                if (object == null) {
                    vector.addElement(package_);
                }
                xMIObject.setXMIDerived(package_);
                package_.setXMISource(xMIObject);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void register(String string, String string2, String string3) {
        Namespace namespace = new Namespace(string, string2);
        this.namespaces.addElement(string3);
        this.namespaces.addElement(namespace);
    }

    protected void removeIDLPackage(XMIContainer xMIContainer, Vector vector) {
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            String string = this.getName((XMIObject)vector.elementAt(i));
            if (string == null || !string.equals("IDL_DATATYPE")) continue;
            n = i;
        }
        if (n == -1) {
            return;
        }
        vector.removeElementAt(n);
        this.removeIDLPackage(xMIContainer, vector);
    }

    protected void setNames(Vector vector, int n) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Data data = (Data)iterator.next();
            String string = this.wrapper.getFullName(data, n);
            int n2 = string.indexOf(":");
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            try {
                data.setXMIName(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

