/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.BadNameException;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.XMIException;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIName;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;

public abstract class DataImpl
implements Data {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private String xmiName;
    private Data definer;
    private Data derived;
    private Data source;
    private Data owner;
    private XMIFile file;
    private Namespace namespace;
    private Vector defined;
    private Object user;

    public DataImpl() {
    }

    public DataImpl(Data data) {
        this.definer = data;
    }

    public DataImpl(String string) {
        this.xmiName = string;
    }

    public void addXMIDefined(Data data) {
        if (this.defined == null) {
            this.defined = new Vector(5);
        }
        this.defined.addElement(data);
    }

    public void deleteXMIDefined(Data data) {
        if (this.defined == null) {
            return;
        }
        this.defined.removeElement(data);
    }

    public Collection getXMIDefined() {
        if (this.defined == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.defined);
    }

    public Data getXMIDefiner() {
        return this.definer;
    }

    public Data getXMIDerived() {
        return this.derived;
    }

    public XMIFile getXMIFile() {
        return this.file;
    }

    public String getXMIName() {
        if (this.definer == null) {
            if (this.namespace == null || this.namespace.getName() == null || this.namespace.getName().equals("")) {
                return this.xmiName;
            }
            return this.namespace.getName() + ":" + this.xmiName;
        }
        return this.definer.getXMIName();
    }

    public Namespace getXMINamespace() {
        if (this.getXMIDefiner() != null) {
            return this.getXMIDefiner().getXMINamespace();
        }
        return this.namespace;
    }

    public Data getXMIOwner() {
        return this.owner;
    }

    public Data getXMISource() {
        return this.source;
    }

    public Object getXMIUserData() {
        return this.user;
    }

    public void setXMIDefiner(Data data) throws XMIException {
        this.definer = data;
    }

    public void setXMIDerived(Data data) {
        this.derived = data;
    }

    public void setXMIFile(XMIFile xMIFile) {
        this.file = xMIFile;
    }

    public void setXMIName(String string) throws XMIException {
        if (!XMIName.isLegal(string)) {
            throw new BadNameException(string);
        }
        this.xmiName = string;
    }

    public void setXMINamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public void setXMIOwner(Data data) {
        this.owner = data;
    }

    public void setXMISource(Data data) {
        this.source = data;
    }

    public void setXMIUserData(Object object) {
        this.user = object;
    }

    public String toString() {
        return this.getXMIName();
    }
}

