/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wtp.internal.emf.xml;

import com.ibm.wtp.emf.xml.Translator;
import com.ibm.wtp.internal.emf.xml.AttributeTranslatorFilter;
import com.ibm.wtp.internal.emf.xml.ObjectTranslatorFilter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;

public abstract class TranslatorFilter {
    protected final Translator translator;
    protected final int version;
    public static final int NEXT_START_HINT_INDX = 0;
    public static final int MODE_HINT_INDX = 1;
    public static final int STANDARD_TRANSLATORS_MODE = 0;
    public static final int VARIABLE_TRANSLATORS_MODE = 1;
    private static final TranslatorFilter objectTranslatorFilter = new ObjectTranslatorFilter(null, -1);
    private static final TranslatorFilter attributeTranslatorFilter = new AttributeTranslatorFilter(null, -1);
    protected int mode = 0;
    protected int index = -1;
    protected Translator cachedPeekAheadTranslator = null;

    public TranslatorFilter(Translator trans, int version) {
        this.translator = trans;
        this.version = version;
    }

    public Translator peekNextChild(EObject target) {
        this.cachedPeekAheadTranslator = this.getNextChild(target);
        return this.cachedPeekAheadTranslator;
    }

    public Translator getNextChild(EObject target) {
        Translator result = null;
        if (this.cachedPeekAheadTranslator != null) {
            result = this.cachedPeekAheadTranslator;
            this.cachedPeekAheadTranslator = null;
            return result;
        }
        int found = 0;
        Translator[] children = null;
        switch (this.mode) {
            case 0: {
                children = this.translator.getChildren(target, this.version);
                found = this.scanNextTranslator(children, this.index);
                if (found >= 0) {
                    result = children[found];
                    this.index = found;
                    break;
                }
                this.index = -1;
                this.mode = 1;
            }
            case 1: {
                children = this.translator.getVariableChildren((Notifier)target, this.version);
                found = this.scanNextTranslator(children, this.index);
                if (found < 0) break;
                result = children[found];
                this.index = found;
            }
        }
        return result;
    }

    public static final int[] createProcessingHints() {
        int[] nArray = new int[2];
        nArray[0] = -1;
        return nArray;
    }

    public static final Translator getNextAttributeTranslator(Translator translator, int startHint, int[] nextHint, EObject target, int version) {
        return TranslatorFilter.getNextChild(translator, startHint, nextHint, target, version, attributeTranslatorFilter);
    }

    public static final Translator getNextObjectTranslator(Translator translator, int startHint, int[] nextHint, EObject target, int version) {
        return TranslatorFilter.getNextChild(translator, startHint, nextHint, target, version, objectTranslatorFilter);
    }

    public static final Translator getNextChild(Translator translator, int startHint, int[] hints, EObject target, int version, TranslatorFilter translatorFilter) {
        Translator result = null;
        int index = startHint;
        Translator[] children = null;
        switch (hints[1]) {
            case 0: {
                children = translator.getChildren(target, version);
                if (children != null && startHint < children.length) {
                    if ((index = translatorFilter.scanNextTranslator(children, index)) >= 0) {
                        result = children[index];
                        break;
                    }
                    startHint = -1;
                }
            }
            case 1: {
                hints[1] = 1;
                index = startHint;
                children = translator.getVariableChildren((Notifier)target, version);
                if (children == null || children.length <= 0 || startHint >= children.length) break;
                result = (index = translatorFilter.scanNextTranslator(children, index)) >= 0 ? children[index] : null;
            }
        }
        hints[0] = result == null && children != null ? children.length : index;
        return result;
    }

    public abstract int scanNextTranslator(Translator[] var1, int var2);

    public int getIndex() {
        return this.index;
    }

    public int getMode() {
        return this.mode;
    }
}

