/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wtp.internal.emf.xml;

import com.ibm.wtp.emf.utilities.NamespaceAdapter;
import com.ibm.wtp.emf.xml.Translator;
import com.ibm.wtp.internal.emf.utilities.Namespace;
import org.eclipse.emf.ecore.EObject;

public class NamespaceTranslator
extends Translator {
    protected String prefix;

    public NamespaceTranslator(String domName) {
        super(domName, NamespaceAdapter.NOTIFICATION_FEATURE, 1);
        this.initPrefix();
    }

    private void initPrefix() {
        String dName = this.getDOMName(null);
        this.prefix = dName.substring("xmlns:".length());
    }

    public void setMOFValue(EObject emfObject, Object value) {
        NamespaceAdapter.addNamespace(this.prefix, (String)value, emfObject);
    }

    public boolean isSetMOFValue(EObject emfObject) {
        return this.getMOFValue(emfObject) != null;
    }

    public Object getMOFValue(EObject mofObject) {
        return NamespaceAdapter.getNamespaceURIAtThisLevel(this.prefix, mofObject);
    }

    public void unSetMOFValue(EObject emfObject) {
        NamespaceAdapter.removeNamespace(this.prefix, emfObject);
    }

    public boolean featureExists(EObject emfObject) {
        return true;
    }

    public boolean isDataType() {
        return true;
    }

    public boolean isMapFor(Object aFeature, Object oldValue, Object newValue) {
        Namespace namespace;
        if (aFeature == this.feature && (namespace = (Namespace)(oldValue == null ? newValue : oldValue)) != null) {
            return this.prefix.equals(namespace.getPrefix());
        }
        return false;
    }
}

