/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.sibws.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.sibwsinbound.SIBWSEndpointListenerReference;
import com.ibm.websphere.models.config.sibwsinbound.SIBWSInboundPort;
import com.ibm.websphere.models.config.sibwsinbound.SIBWSInboundService;
import com.ibm.websphere.models.config.sibwsinbound.SIBWSUDDIPublication;
import com.ibm.websphere.models.config.sibwsoutbound.SIBWSWSDLLocation;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.sibws.level60.SibwsOutboundValidator_60;
import com.ibm.websphere.validation.sibws.level60.SibwsValidationConstants_60;
import com.ibm.websphere.validation.sibws.level60.WSAttributeHelper;
import java.util.HashSet;
import java.util.Iterator;

public class SibwsInboundValidator_60
extends WebSphereLevelValidator
implements SibwsValidationConstants_60 {
    public static final String version = "%I%";
    public static final String update = "%G%";
    protected HashSet inboundServiceNames;
    protected HashSet inboundPortNames;
    protected HashSet eplNames;
    protected HashSet uddiNames;
    protected WSAttributeHelper attributeHelper = new WSAttributeHelper(this);

    public SibwsInboundValidator_60(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
        this.inboundServiceNames = new HashSet();
        this.eplNames = new HashSet();
        this.uddiNames = new HashSet();
        this.trace("SibwsInboundValidator_60");
    }

    public WSAttributeHelper getAttributeHelper() {
        return this.attributeHelper;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.sibws.level60.sibwsvalidation_60_NLS";
    }

    public String getTraceName() {
        return "SibwsInboundValidator_60";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof SIBWSInboundService) {
            this.trace("SIBWSInboundService");
            this.validateLocalInboundService((SIBWSInboundService)object);
        } else if (object instanceof SIBWSInboundPort) {
            this.trace("SIBWSInboundPort");
            this.validateLocalInboundPort((SIBWSInboundPort)object);
        } else if (object instanceof SIBWSEndpointListenerReference) {
            this.trace("SIBWSEndpointListenerReference");
            this.validateLocalEPLRef((SIBWSEndpointListenerReference)object);
        } else if (object instanceof SIBWSUDDIPublication) {
            this.trace("SIBWSUDDIPublication");
            this.validateLocalUDDIPub((SIBWSUDDIPublication)object);
        } else if (object instanceof SIBWSWSDLLocation) {
            this.trace("SIBWSWSDLLocation");
            this.validateLocalWSDLLoc((SIBWSWSDLLocation)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    protected void validateLocalEPLRef(SIBWSEndpointListenerReference sIBWSEndpointListenerReference) throws ValidationException {
        String string = sIBWSEndpointListenerReference.getEndpointListenerName();
        this.traceBegin("validateLocalEPLRef()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        boolean bl = wSAttributeHelper.isSetAndUnique(string, "SIBWSEndpointListenerReference", "endPointListenerName", this.eplNames, sIBWSEndpointListenerReference);
        boolean bl2 = wSAttributeHelper.isSet(sIBWSEndpointListenerReference.getCachedURLRoot(), "SIBWSEndpointListenerReference", "cachedURLRoot", sIBWSEndpointListenerReference);
        boolean bl3 = wSAttributeHelper.isSet(sIBWSEndpointListenerReference.getCachedWSDLServingHTTPURLRoot(), "SIBWSEndpointListenerReference", "cachedWSDLServingHTTPURLroot", sIBWSEndpointListenerReference);
        String string2 = sIBWSEndpointListenerReference.getServerName();
        if (string2 == null || string2.length() == 0) {
            String string3 = sIBWSEndpointListenerReference.getClusterName();
            if (string3 == null || string3.length() == 0) {
                this.trace("cluster and server both not set, adding error 5007E");
                this.addError("ERROR_REQUIRED_ATTRIBUTE_EITHER", new String[]{"SIBWSEndpointListenerReference", "serverName", "clusterName"}, sIBWSEndpointListenerReference);
            }
        } else {
            String string4 = sIBWSEndpointListenerReference.getNodeName();
            if (string4 == null || string4.length() == 0) {
                this.trace("server set but not node, adding error 5006E");
                this.addError("ERROR_REQUIRED_ATTRIBUTE_WHEN_SET", new String[]{"SIBWSEndpointListenerReference", "nodeName", "serverName"}, sIBWSEndpointListenerReference);
            }
        }
        this.traceEnd();
    }

    protected void validateLocalUDDIPub(SIBWSUDDIPublication sIBWSUDDIPublication) throws ValidationException {
        String string = sIBWSUDDIPublication.getName();
        this.traceBegin("validateLocalUDDIPub()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        boolean bl = wSAttributeHelper.isSetAndUnique(string, "SIBWSUDDIPublication", "name", this.uddiNames, sIBWSUDDIPublication);
        boolean bl2 = wSAttributeHelper.isSet(sIBWSUDDIPublication.getUDDIBusinessKey(), "SIBWSUDDIPublication", "UDDIBusinessKey", sIBWSUDDIPublication);
        boolean bl3 = wSAttributeHelper.isSet(sIBWSUDDIPublication.getUDDIRefName(), "SIBWSUDDIPublication", "UDDIRefName", sIBWSUDDIPublication);
        this.traceEnd();
    }

    protected void validateLocalInboundPort(SIBWSInboundPort sIBWSInboundPort) throws ValidationException {
        String string = sIBWSInboundPort.getName();
        this.traceBegin("validateLocalInboundPort()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        boolean bl = wSAttributeHelper.isSet(string, "SIBWSInboundPort", "name", sIBWSInboundPort);
        boolean bl2 = wSAttributeHelper.isPresent(sIBWSInboundPort.getEndpointListenerReference(), "SIBWSInboundPort", "SIBWSEndpointListenerReference", sIBWSInboundPort);
        this.traceEnd();
    }

    protected void validateLocalInboundService(SIBWSInboundService sIBWSInboundService) throws ValidationException {
        String string = sIBWSInboundService.getName();
        this.traceBegin("validateLocalInboundService()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        boolean bl = wSAttributeHelper.isSetAndUnique(string, "SIBWSInboundService", "name", this.inboundServiceNames, sIBWSInboundService);
        boolean bl2 = wSAttributeHelper.isSet(sIBWSInboundService.getServiceDestinationName(), "SIBWSInboundService", "ServiceDestinationName", sIBWSInboundService);
        boolean bl3 = wSAttributeHelper.isPresent(sIBWSInboundService.getWSDLLocation(), "SIBWSInboundService", "SIBWSWSDLLocation", sIBWSInboundService);
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = sIBWSInboundService.getPort().iterator();
        while (iterator.hasNext()) {
            SIBWSInboundPort sIBWSInboundPort = (SIBWSInboundPort)iterator.next();
            String string2 = sIBWSInboundPort.getName();
            if (hashSet.contains(string2)) {
                this.trace("Duplicate name, adding error 5008E");
                this.addError("ERROR_DUPLICATE_NAME", new String[]{"SIBWSinboundPort", string2}, sIBWSInboundService);
                continue;
            }
            hashSet.add(string2);
        }
        this.traceEnd();
    }

    protected void validateLocalWSDLLoc(SIBWSWSDLLocation sIBWSWSDLLocation) throws ValidationException {
        SibwsOutboundValidator_60 sibwsOutboundValidator_60 = new SibwsOutboundValidator_60(this);
        sibwsOutboundValidator_60.visit(sIBWSWSDLLocation);
    }
}

