/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.sibws.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.sibwsinbound.SIBWSEndpointListenerReference;
import com.ibm.websphere.models.config.wsgw.WSGWGatewayService;
import com.ibm.websphere.models.config.wsgw.WSGWInstance;
import com.ibm.websphere.models.config.wsgw.WSGWProxyService;
import com.ibm.websphere.models.config.wsgw.WSGWTargetService;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.sibws.level60.SibwsCrossValidator_60;
import com.ibm.websphere.validation.sibws.level60.WSAttributeHelper;
import java.util.List;

public class SibwsGatewayCrossValidator_60
extends SibwsCrossValidator_60 {
    public static final String version = "%I%";
    public static final String update = "%G%";

    public SibwsGatewayCrossValidator_60(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
        this.trace("SibwsGatewayCrossValidator_60");
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.sibws.level60.sibwsvalidation_60_NLS";
    }

    public String getTraceName() {
        return "SibwsGatewayCrossValidator_60";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof WSGWInstance) {
            this.trace("WSGWInstance");
            this.validateAcrossWSGWInstance((WSGWInstance)object);
        } else if (object instanceof WSGWGatewayService) {
            this.trace("WSGWGatewayService");
            this.validateAcrossGatewayService((WSGWGatewayService)object);
        } else if (object instanceof WSGWProxyService) {
            this.trace("WSGWProxyService");
            this.validateAcrossProxyService((WSGWProxyService)object);
        } else if (object instanceof WSGWTargetService) {
            this.traceStub("WSGWTargetService");
        } else if (object instanceof SIBWSEndpointListenerReference) {
            this.trace("SIBWSEndpointListenerReference");
            this.validateAcrossEPLRef((SIBWSEndpointListenerReference)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    protected void validateAcrossWSGWInstance(WSGWInstance wSGWInstance) throws ValidationException {
    }

    protected void validateAcrossProxyService(WSGWProxyService wSGWProxyService) throws ValidationException {
        this.traceBegin("validateAcrossProxyService()");
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        List list = this.loadBusPeer("sibws-outbound.xml");
        if (list != null) {
            wSAttributeHelper.testFindWithName(wSGWProxyService.getOutboundServiceName(), list, "WSGWProxyService", "outboundServiceName", wSGWProxyService);
        }
        List list2 = this.getCurrentBusDestination();
        wSAttributeHelper.testFindWithName(wSGWProxyService.getRequestDestinationName(), list2, "WSGWProxyService", "requestDestinationName", wSGWProxyService);
        wSAttributeHelper.testFindWithName(wSGWProxyService.getReplyDestinationName(), list2, "WSGWProxyService", "replyDestinationName", wSGWProxyService);
        this.traceEnd();
    }

    protected void validateAcrossGatewayService(WSGWGatewayService wSGWGatewayService) throws ValidationException {
        this.traceBegin("validateAcrossGatewayService()");
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        List list = this.loadBusPeer("sibws-inbound.xml");
        if (list != null) {
            wSAttributeHelper.testFindWithName(wSGWGatewayService.getInboundServiceName(), list, "WSGWGatewayService", "inboundServiceName", wSGWGatewayService);
        }
        List list2 = this.getCurrentBusDestination();
        wSAttributeHelper.testFindWithName(wSGWGatewayService.getRequestDestinationName(), list2, "WSGWGatewayService", "requestDestinationName", wSGWGatewayService);
        wSAttributeHelper.testFindWithName(wSGWGatewayService.getReplyDestinationName(), list2, "WSGWGatewayService", "replyDestinationName", wSGWGatewayService);
        this.traceEnd();
    }
}

