/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.sibws.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.sibwsepl.SIBWSEndpointListener;
import com.ibm.websphere.models.config.sibwsinbound.SIBWSEndpointListenerReference;
import com.ibm.websphere.validation.base.config.WebSphereLevelCrossValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.sibws.level60.SibwsValidationConstants_60;
import com.ibm.websphere.validation.sibws.level60.WSAttributeHelper;
import java.util.List;

public class SibwsCrossValidator_60
extends WebSphereLevelCrossValidator
implements SibwsValidationConstants_60 {
    public static final String version = "1.1";
    public static final String update = "6/24/04";
    protected WSAttributeHelper attributeHelper = new WSAttributeHelper(this);
    protected List currentBusDestination = null;
    protected String currentBusName = null;

    public SibwsCrossValidator_60(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
        this.trace("SibwsCrossValidator_60");
    }

    protected WSAttributeHelper getAttributeHelper() {
        return this.attributeHelper;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.sibws.level60.sibwsvalidation_60_NLS";
    }

    public String getTraceName() {
        return "SibwsCrossValidator_60";
    }

    protected void validateAcrossEPLRef(SIBWSEndpointListenerReference sIBWSEndpointListenerReference) throws ValidationException {
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        String string = sIBWSEndpointListenerReference.getEndpointListenerName();
        this.traceBegin("validateAcrossEPLRef() ", string);
        String string2 = this.getReferencePath(sIBWSEndpointListenerReference);
        this.trace("Reference path: ", string2);
        List list = this.loadDirect(string2);
        SIBWSEndpointListener sIBWSEndpointListener = (SIBWSEndpointListener)wSAttributeHelper.testFindWithName(string, list, "SIBWSEndpointListenerReference", "EndpointListener", sIBWSEndpointListenerReference);
        this.traceEnd();
    }

    protected String getReferencePath(SIBWSEndpointListenerReference sIBWSEndpointListenerReference) {
        String string = sIBWSEndpointListenerReference.getClusterName();
        String string2 = string == null ? "cells/" + this.getCellName() + "/" + "nodes" + "/" + sIBWSEndpointListenerReference.getNodeName() + "/" + "servers" + "/" + sIBWSEndpointListenerReference.getServerName() + "/" + "sibws-epl.xml" : "cells/" + this.getCellName() + "/" + "clusters" + "/" + string + "/" + "sibws-epl.xml";
        return string2;
    }

    protected List getCurrentBusDestination() {
        if (this.currentBusDestination == null) {
            this.currentBusDestination = this.loadBusPeer("sib-destinations.xml");
        }
        if (this.isTraceEnabled()) {
            this.trace("getDestConfig: ", this.currentBusDestination);
        }
        return this.currentBusDestination;
    }

    protected List loadBusPeer(String string) {
        return this.loadBusPeer(this.getCurrentBusName(), string);
    }

    protected String getCurrentBusName() {
        if (this.currentBusName == null) {
            this.currentBusName = this.getBusName(this.getCurrentFileName());
        }
        return this.currentBusName;
    }

    protected boolean isBusConfigured(String string) {
        this.trace("isBusConfigured: ", string);
        List list = this.loadBusPeer(string, "sib-bus.xml");
        if (list == null) {
            this.trace("Bus document failed to load");
            return false;
        }
        this.trace("Bus document loaded sucessfully");
        return true;
    }

    protected List loadBusPeer(String string, String string2) {
        String string3 = "cells/" + this.getCellName() + "/" + "buses" + "/" + string + "/" + string2;
        return this.loadDirect(string3);
    }

    protected String getBusName(String string) {
        this.traceBegin("getBusName()", string);
        String string2 = this.trimLeadingChainOf(string);
        String string3 = this.nabEndOfNoSlash(string2);
        this.traceEnd(string3);
        return string3;
    }
}

