/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.sibws.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.sibwsepl.SIBWSBusConnectionProperty;
import com.ibm.websphere.models.config.sibwsepl.SIBWSEndpointListener;
import com.ibm.websphere.models.config.sibwsepl.SIBWSInboundPortReference;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.sibws.level60.SibwsValidationConstants_60;
import com.ibm.websphere.validation.sibws.level60.WSAttributeHelper;
import java.util.HashSet;

public class EPLValidator_60
extends WebSphereLevelValidator
implements SibwsValidationConstants_60 {
    public static final String version = "%I%";
    public static final String update = "%G%";
    protected WSAttributeHelper attributeHelper = new WSAttributeHelper(this);
    protected HashSet eplNames = new HashSet();

    public EPLValidator_60(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
        this.trace("EPLValidator_60");
    }

    protected WSAttributeHelper getAttributeHelper() {
        return this.attributeHelper;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.sibws.level60.sibwsvalidation_60_NLS";
    }

    public String getTraceName() {
        return "EPLValidator_60";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof SIBWSEndpointListener) {
            this.trace("SIBWSEndpointListener");
            this.validateLocalEPL((SIBWSEndpointListener)object);
        } else if (object instanceof SIBWSInboundPortReference) {
            this.trace("SIBWSInboundPortReference");
            this.validateLocalIPR((SIBWSInboundPortReference)object);
        } else if (object instanceof SIBWSBusConnectionProperty) {
            this.trace("SIBWSBusConnectionProperty");
            this.validateLocalBCP((SIBWSBusConnectionProperty)object);
        } else if (object instanceof Property) {
            this.trace("Property");
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    protected void validateLocalEPL(SIBWSEndpointListener sIBWSEndpointListener) {
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        String string = sIBWSEndpointListener.getName();
        this.traceBegin("validateLocalEPL()", string);
        boolean bl = wSAttributeHelper.isSetAndUnique(string, "SIBWSEndpointListener", "name", this.eplNames, sIBWSEndpointListener);
        boolean bl2 = wSAttributeHelper.isSet(sIBWSEndpointListener.getURLRoot(), "SIBWSEndpointListener", "URLRoot", sIBWSEndpointListener);
        boolean bl3 = wSAttributeHelper.isSet(sIBWSEndpointListener.getWSDLServingHTTPURLRoot(), "SIBWSEndpointListener", "WSDLServingHTTPURLRoot", sIBWSEndpointListener);
        this.traceEnd();
    }

    protected void validateLocalIPR(SIBWSInboundPortReference sIBWSInboundPortReference) {
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        String string = sIBWSInboundPortReference.getBusName();
        this.traceBegin("validateLocalIPR()", string);
        boolean bl = wSAttributeHelper.isSet(string, "SIBWSInboundPortReference", "busName", sIBWSInboundPortReference);
        boolean bl2 = wSAttributeHelper.isSet(sIBWSInboundPortReference.getPortName(), "SIBWSInboundPortReference", "portName", sIBWSInboundPortReference);
        boolean bl3 = wSAttributeHelper.isSet(sIBWSInboundPortReference.getServiceName(), "SIBWSInboundPortReference", "serviceName", sIBWSInboundPortReference);
        this.traceEnd();
    }

    protected void validateLocalBCP(SIBWSBusConnectionProperty sIBWSBusConnectionProperty) {
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        String string = sIBWSBusConnectionProperty.getBusName();
        this.traceBegin("validateLocalBCP()", string);
        boolean bl = wSAttributeHelper.isSet(string, "SIBWSEndpointListener", "busName", sIBWSBusConnectionProperty);
        this.traceEnd();
    }
}

