/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.sibws.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.sibwsepl.SIBWSBusConnectionProperty;
import com.ibm.websphere.models.config.sibwsepl.SIBWSEndpointListener;
import com.ibm.websphere.models.config.sibwsepl.SIBWSInboundPortReference;
import com.ibm.websphere.models.config.sibwsinbound.SIBWSInboundPort;
import com.ibm.websphere.models.config.sibwsinbound.SIBWSInboundService;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.sibws.level60.SibwsCrossValidator_60;
import com.ibm.websphere.validation.sibws.level60.WSAttributeHelper;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class EPLCrossValidator_60
extends SibwsCrossValidator_60 {
    public static final String version = "%I%";
    public static final String update = "%G%";
    protected WSAttributeHelper attributeHelper = new WSAttributeHelper(this);

    public EPLCrossValidator_60(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
        this.trace("EPLCrossValidator_60");
    }

    protected WSAttributeHelper getAttributeHelper() {
        return this.attributeHelper;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.sibws.level60.sibwsvalidation_60_NLS";
    }

    public String getTraceName() {
        return "EPLCrossValidator_60";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof SIBWSEndpointListener) {
            this.trace("SIBWSEndpointListener");
            this.validateAcrossEPL((SIBWSEndpointListener)object);
        } else if (object instanceof SIBWSInboundPortReference) {
            this.trace("SIBWSInboundPortReference");
            this.validateAcrossIPR((SIBWSInboundPortReference)object);
        } else if (object instanceof SIBWSBusConnectionProperty) {
            this.trace("SIBWSBusConnectionProperty");
            this.validateAcrossBCP((SIBWSBusConnectionProperty)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    protected void validateAcrossEPL(SIBWSEndpointListener sIBWSEndpointListener) throws ValidationException {
    }

    protected void validateAcrossIPR(SIBWSInboundPortReference sIBWSInboundPortReference) throws ValidationException {
        String string = sIBWSInboundPortReference.getBusName();
        this.traceBegin("validateAcrossIPR()", string);
        WSAttributeHelper wSAttributeHelper = this.getAttributeHelper();
        List list = this.loadBusPeer(string, "sibws-inbound.xml");
        SIBWSInboundService sIBWSInboundService = (SIBWSInboundService)wSAttributeHelper.testFindWithName(sIBWSInboundPortReference.getServiceName(), list, "SIBWSInboundPortReference", "serviceName", sIBWSInboundPortReference);
        EList eList = sIBWSInboundService != null ? sIBWSInboundService.getPort() : null;
        SIBWSInboundPort sIBWSInboundPort = (SIBWSInboundPort)wSAttributeHelper.testFindWithName(sIBWSInboundPortReference.getPortName(), (List)eList, "SIBWSInboundPortReference", "portName", sIBWSInboundPortReference);
        this.traceEnd();
    }

    protected void validateAcrossBCP(SIBWSBusConnectionProperty sIBWSBusConnectionProperty) {
        String string = sIBWSBusConnectionProperty.getBusName();
        this.traceBegin("validateAcrossBCP()", string);
        if (!this.isBusConfigured(string)) {
            this.trace("No match, adding 5004E");
            this.addError("ERROR_REQUIRED_RELATIONSHIP", new String[]{"SIBWSBusConnectionProperty", "SIBus", string}, sIBWSBusConnectionProperty);
        }
        this.traceEnd();
    }
}

