/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.nodefeatures;

import com.ibm.websphere.validation.nodefeatures.NodeFeatures;
import com.ibm.websphere.validation.nodefeatures.NodeFeaturesVersionComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class NodeFeaturesImpl
implements NodeFeatures {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    protected String _cellName;
    protected String _nodeName;
    protected Properties _properties;
    protected String productVersion;
    protected String majorVersion;
    protected String minorVersion;
    protected String sysplexName;
    protected boolean computedSysplexName;
    protected ArrayList deployedFeatures;

    public NodeFeaturesImpl(String string, String string2, Properties properties) {
        this.clearVersions();
        this.clearSysplexName();
        this.clearDeployedFeatures();
        this.setCellName(string);
        this.setNodeName(string2);
        this.setProperties(properties);
    }

    protected void setCellName(String string) {
        this._cellName = string;
    }

    public String getCellName() {
        return this._cellName;
    }

    protected void setNodeName(String string) {
        this._nodeName = string;
    }

    public String getNodeName() {
        return this._nodeName;
    }

    protected void setProperties(Properties properties) {
        this._properties = properties;
    }

    protected Properties getProperties() {
        return this._properties;
    }

    protected void clearVersions() {
        this.productVersion = null;
        this.majorVersion = null;
        this.minorVersion = null;
    }

    public String getBaseProductVersion() {
        if (this.productVersion == null) {
            this.computeVersions();
        }
        return this.productVersion;
    }

    public int compareVersion(String string) {
        String string2 = this.getBaseProductVersion();
        return new NodeFeaturesVersionComparator().compare(string2, string);
    }

    public String getMajorVersion() {
        if (this.majorVersion == null) {
            this.computeVersions();
        }
        return this.majorVersion;
    }

    public String getMinorVersion() {
        if (this.minorVersion == null) {
            this.computeVersions();
        }
        return this.minorVersion;
    }

    protected void computeVersions() {
        String string;
        String string2;
        int n;
        String string3 = this.getProperties().getProperty("com.ibm.websphere.baseProductVersion");
        if (string3 == null) {
            string3 = "6.0";
        }
        if ((n = string3.indexOf(46)) == -1) {
            string2 = string3;
            string = "0";
        } else {
            int n2;
            string2 = string3.substring(0, n);
            string = (n2 = string3.indexOf(46, ++n)) == -1 ? string3.substring(n) : string3.substring(n, n2);
        }
        this.productVersion = string3;
        this.majorVersion = string2;
        this.minorVersion = string;
    }

    protected void clearSysplexName() {
        this.sysplexName = null;
        this.computedSysplexName = false;
    }

    public String getSysplexName() {
        if (!this.computedSysplexName) {
            this.computedSysplexName = true;
            this.sysplexName = this.getProperties().getProperty("com.ibm.websphere.nodeSysplexName");
        }
        return this.sysplexName;
    }

    protected void clearDeployedFeatures() {
        this.deployedFeatures = null;
    }

    public Iterator getDeployedFeatures() {
        if (this.deployedFeatures == null) {
            this.deployedFeatures = this.computeDeployedFeatures();
        }
        return this.deployedFeatures.iterator();
    }

    protected ArrayList computeDeployedFeatures() {
        String string = this.getProperties().getProperty("com.ibm.websphere.deployed.features");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            int n3 = string.indexOf(44, n2);
            if (n3 == -1) {
                n3 = n;
            }
            if ((string2 = string.substring(n2, n3).trim()).length() != 0) {
                arrayList.add(string2);
            }
            n2 = n3 + 1;
        }
        return arrayList;
    }

    public String getPlatformOS() {
        return this.getProperties().getProperty("com.ibm.websphere.nodeOperatingSystem");
    }

    public boolean isZOS() {
        String string = this.getPlatformOS();
        return string != null && string.equals("os390");
    }
}

