/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.nodefeatures;

import com.ibm.websphere.validation.nodefeatures.NodeFeatures;
import com.ibm.websphere.validation.nodefeatures.NodeFeaturesFactory;
import com.ibm.websphere.validation.nodefeatures.NodeFeaturesImpl;
import com.ibm.websphere.validation.nodefeatures.NodeFeaturesVersionParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class NodeFeaturesFactoryImpl
implements NodeFeaturesFactory {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";

    public String getFeaturesPath(String string, String string2) {
        return "cells/" + string + "/" + "nodes" + "/" + string2 + "/" + "node-metadata.properties";
    }

    public String getConfigRoot() {
        return System.getProperty("was.repository.root");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProperties(String string) throws IOException {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            properties.load(fileInputStream);
        }
        finally {
            fileInputStream.close();
        }
        return properties;
    }

    public NodeFeatures createNodeFeatures(String string, String string2, Properties properties) {
        return new NodeFeaturesImpl(string, string2, properties);
    }

    public NodeFeatures getCurrentFeatures(String string, String string2) {
        Properties properties = this.getCurrentProperties();
        return this.createNodeFeatures(string, string2, properties);
    }

    public Properties getCurrentProperties() {
        Properties properties = new Properties();
        this.fillCurrentPlatform(properties);
        this.fillCurrentProductVersion(properties);
        return properties;
    }

    protected void fillCurrentPlatform(Properties properties) {
        String string = this.getCurrentOSName();
        String string2 = this.normalizeOSName(string);
        if (string2 != null) {
            properties.put("com.ibm.websphere.nodeOperatingSystem", string2);
        }
    }

    protected void fillCurrentProductVersion(Properties properties) {
        String string = this.getCurrentProductVersion();
        NodeFeaturesVersionParser nodeFeaturesVersionParser = new NodeFeaturesVersionParser(string);
        properties.put("com.ibm.websphere.baseProductVersion", string);
    }

    protected String getCurrentOSName() {
        return System.getProperty("os.name");
    }

    protected String getCurrentProductVersion() {
        return "6.0";
    }

    public String normalizeOSName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (string = string.toLowerCase()).startsWith("windows") ? "windows" : (string.startsWith("aix") ? "aix" : (string.startsWith("solaris") || string.startsWith("sun") ? "solaris" : (string.startsWith("hp-ux") ? "hpux" : (string.startsWith("z/os") || string.startsWith("os/390") ? "os390" : (string.startsWith("os/400") ? "os400" : (string.startsWith("linux") ? "linux" : null))))));
        return string2;
    }
}

