/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.jsr109;

import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.websphere.validation.jsr109.JAXRPCParamValidator;
import com.ibm.websphere.validation.jsr109.JSR109CommonValidator;
import com.ibm.websphere.validation.jsr109.JSR109ValidatorContext;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;

public class JSR109SEIValidator
extends JSR109CommonValidator {
    private String seiLocation;
    private static final String remoteExceptionClassName = "java.rmi.RemoteException";
    private JSR109ValidatorContext vc;
    private Archive modFile;

    public JSR109SEIValidator(JSR109ValidatorContext jSR109ValidatorContext, Archive archive) {
        this.vc = jSR109ValidatorContext;
        this.modFile = archive;
    }

    private JSR109SEIValidator() {
    }

    public EList validateSEI(String string, String string2) {
        EList eList = null;
        this.seiLocation = string2;
        JavaClass javaClass = null;
        try {
            javaClass = JSR109SEIValidator.forName(this.modFile, string);
            if (javaClass == null) {
                return null;
            }
            this.validateSEIIsInterface(javaClass);
            this.validateSEIIsRemote(javaClass);
            eList = this.validateSEIMethods(javaClass);
            this.validateSEIHasNoFields(javaClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.vc.addError("MISSING_SEI_CLASS", new String[]{string});
        }
        return eList;
    }

    private void validateSEIIsInterface(JavaClass javaClass) {
        if (javaClass != null && !javaClass.isInterface()) {
            this.vc.addError("SEI_NOT_INTERFACE", new String[]{javaClass.getJavaName(), this.seiLocation});
        }
    }

    private void validateSEIHasNoFields(JavaClass javaClass) {
        EList eList;
        if (javaClass != null && (eList = javaClass.getFields()) != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Field field = (Field)iterator.next();
                if (!field.isFinal() || !field.isStatic()) continue;
                this.vc.addError("ILLEGAL_CONSTANT_DECL", new String[]{field.getName(), javaClass.getJavaName()});
            }
        }
    }

    private void validateSEIIsRemote(JavaClass javaClass) {
        if (!javaClass.inheritsFrom(this.getRemoteInterface(this.modFile))) {
            this.vc.addError("SEI_NOT_REMOTE", new String[]{javaClass.getJavaName()});
        }
    }

    private EList validateSEIMethods(JavaClass javaClass) {
        JAXRPCParamValidator.resetAlreadyTested();
        EList eList = javaClass.getMethods();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            this.validateSEIMethod(javaClass, method);
        }
        return eList;
    }

    private void validateSEIMethod(JavaClass javaClass, Method method) {
        this.validateMethodThrowsRemoteException(javaClass, method);
        JAXRPCParamValidator jAXRPCParamValidator = new JAXRPCParamValidator(javaClass, method, this.vc, this.modFile);
        jAXRPCParamValidator.validateMethodParameters();
    }

    private void validateMethodThrowsRemoteException(JavaClass javaClass, Method method) {
        EList eList = method.getJavaExceptions();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass2 = (JavaClass)iterator.next();
            String string = javaClass2.getEPackage().getName() + "." + javaClass2.getName();
            if (!remoteExceptionClassName.equals(string)) continue;
            return;
        }
        this.vc.addError("REMOTE_EXCEPTION_NOT_THROWN", new String[]{method.getMethodElementSignature(), javaClass.getJavaName()});
    }
}

