/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.j2ee;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.etools.application.Application;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.j2ee.validation.ear.EarValidator;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.Message;
import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.validation.base.bindings.applicationbnd.ApplicationBindingValidator;
import com.ibm.websphere.validation.base.extensions.applicationext.ApplicationExtensionValidator;
import com.ibm.websphere.validation.base.extensions.handler.HandlerValidator;

public class EARValidator
extends EarValidator {
    ApplicationExtensionValidator _extensionsValidator;
    ApplicationBindingValidator _bindingsValidator;
    HandlerValidator _handlerValidator;
    ApplicationBinding bindings;
    ApplicationExtension extensions;
    Application deploymentDescriptor;
    EARFile jarFile;
    EARFile earFile;

    public void extendedValidate() throws ValidationException {
        if (this.bindings != null) {
            this.getBindingValidator().validate(this.bindings);
        }
        if (this.extensions != null) {
            this.getExtensionValidator().validate(this.extensions);
        }
        this.getHandlerValidator().validate(this._helper, this._reporter, this._changedFiles, this.jarFile);
    }

    public ApplicationBindingValidator getBindingValidator() {
        if (this._bindingsValidator == null) {
            this._bindingsValidator = new ApplicationBindingValidator();
        }
        return this._bindingsValidator;
    }

    public ApplicationExtensionValidator getExtensionValidator() {
        if (this._extensionsValidator == null) {
            this._extensionsValidator = new ApplicationExtensionValidator();
        }
        return this._extensionsValidator;
    }

    public HandlerValidator getHandlerValidator() {
        if (this._handlerValidator == null) {
            this._handlerValidator = new HandlerValidator();
        }
        return this._handlerValidator;
    }

    public void validate() throws ValidationException {
        super.validate();
        ApplicationBinding applicationBinding = this.earFile.getBindings();
        ApplicationExtension applicationExtension = this.earFile.getExtensions();
        if (applicationBinding != null) {
            // empty if block
        }
    }

    public void validate(IHelper iHelper, IReporter iReporter, IFileDelta[] iFileDeltaArray) throws ValidationException {
        super.validate(iHelper, iReporter, iFileDeltaArray);
        try {
            this.jarFile = (EARFile)iHelper.loadModel("EAR_VALIDATION");
            this.deploymentDescriptor = this.jarFile.getDeploymentDescriptor();
            this.bindings = this.jarFile.getBindings();
            this.extensions = this.jarFile.getExtensions();
            this.extendedValidate();
        }
        catch (Exception exception) {
            Message message = new Message(this.getBaseName(), 1, "ERROR_EAR_VALIDATION_FAILED");
            throw new ValidationException(message);
        }
    }

    public void validateContainedModuleJars() {
    }
}

