/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.extensions.ejbext;

import com.ibm.ejs.models.base.extensions.ejbext.AccessIntent;
import com.ibm.ejs.models.base.extensions.ejbext.BeanCache;
import com.ibm.ejs.models.base.extensions.ejbext.BeanInternationalization;
import com.ibm.ejs.models.base.extensions.ejbext.BeanStructure;
import com.ibm.ejs.models.base.extensions.ejbext.ContainerActivitySession;
import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbGeneralization;
import com.ibm.ejs.models.base.extensions.ejbext.EjbRelationship;
import com.ibm.ejs.models.base.extensions.ejbext.EjbRelationshipRole;
import com.ibm.ejs.models.base.extensions.ejbext.EjbqlFinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.ejbext.FinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.FullSelectFinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.IsolationLevelAttributes;
import com.ibm.ejs.models.base.extensions.ejbext.LocalTran;
import com.ibm.ejs.models.base.extensions.ejbext.PersistenceSecurityIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.RunAsMode;
import com.ibm.ejs.models.base.extensions.ejbext.RunAsSpecifiedIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.SessionExtension;
import com.ibm.ejs.models.base.extensions.ejbext.UseCallerIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.UseSystemIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.WhereClauseFinderDescriptor;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.MethodElement;
import com.ibm.etools.j2ee.validation.J2EEValidator;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.validation.base.extensions.ejbext.EJBExtensionMessageConstants;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class EJBExtensionValidator
extends J2EEValidator
implements EJBExtensionMessageConstants {
    public String getBaseName() {
        return "com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation";
    }

    private void validate(AccessIntent accessIntent) {
        if (accessIntent.getMethodElements().size() == 0) {
            String[] stringArray = new String[2];
            stringArray[1] = "ACCESS_INTENT";
            stringArray[0] = "METHOD_ELEMENT";
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
    }

    private void validate(BeanCache beanCache) {
    }

    private void validate(BeanInternationalization beanInternationalization) {
    }

    private void validate(BeanStructure beanStructure) {
    }

    private void validate(ContainerActivitySession containerActivitySession) {
        if (containerActivitySession.getMethodElement().size() == 0) {
            String[] stringArray = new String[2];
            stringArray[1] = "CONTAINER_ACTIVITY_SESSION";
            stringArray[0] = "METHOD_ELEMENT";
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
    }

    private void validate(ContainerManagedEntityExtension containerManagedEntityExtension) {
        if (containerManagedEntityExtension.getPersistenceSecurityIdentity() != null) {
            this.validate(containerManagedEntityExtension.getPersistenceSecurityIdentity());
        }
        EList eList = containerManagedEntityExtension.getAccessIntents();
        BasicEList basicEList = new BasicEList();
        for (int i = 0; i < eList.size(); ++i) {
            AccessIntent accessIntent = (AccessIntent)eList.get(i);
            this.validate(accessIntent);
            basicEList.add((Object)accessIntent.getMethodElements());
        }
        this.validateMethodElements((EList)basicEList, "ACCESS_INTENT");
        this.validateForFinders(containerManagedEntityExtension);
        this.validateForAssociations(containerManagedEntityExtension);
    }

    private void validate(EjbGeneralization ejbGeneralization) {
        String[] stringArray = new String[2];
        stringArray[1] = "EJB_GENERALIZATION";
        stringArray[0] = "SUPER_TYPE";
        if (ejbGeneralization.getSupertype() == null) {
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
        stringArray[0] = "SUB_TYPE";
        if (ejbGeneralization.getSubtype() == null) {
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
        stringArray[0] = "EJB_JAR_EXTENSION";
        if (ejbGeneralization.getEjbJarExtension() == null) {
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
    }

    private void validate(EJBJarExtension eJBJarExtension) {
        String[] stringArray = new String[3];
        EJBJar eJBJar = eJBJarExtension.getEjbJar();
        if (eJBJar == null) {
            stringArray[0] = "EJB_JAR";
            stringArray[1] = "EJB_JAR_EXTENSION";
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
        EList eList = eJBJarExtension.getEjbExtensions();
        BasicEList basicEList = new BasicEList();
        for (int i = 0; i < eList.size(); ++i) {
            EnterpriseBeanExtension enterpriseBeanExtension = (EnterpriseBeanExtension)eList.get(i);
            EnterpriseBean enterpriseBean = enterpriseBeanExtension.getEnterpriseBean();
            if (eJBJar != null && !eJBJar.getEnterpriseBeans().contains((Object)enterpriseBean)) {
                stringArray[0] = "ENTERPRISE_BEAN";
                stringArray[1] = "ENTERPRISE_BEAN_EXTENSION";
                stringArray[2] = "EJB_JAR";
                this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_UNDEFINED", stringArray);
            }
            if (basicEList.contains((Object)enterpriseBean)) {
                stringArray[0] = "ENTERPRISE_BEAN_EXTENSION";
                stringArray[1] = "EJB_JAR_EXTENSION";
                this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_DUPLICATE", stringArray);
            } else {
                basicEList.add((Object)enterpriseBean);
            }
            this.validate(enterpriseBeanExtension);
        }
        this.validateForAssociations(eJBJarExtension);
    }

    private void validate(EjbqlFinderDescriptor ejbqlFinderDescriptor) {
    }

    private void validate(EjbRelationship ejbRelationship) {
        String[] stringArray = new String[3];
        stringArray[1] = "EJB_RELATIONSHIP";
        if (ejbRelationship.getEjbJarExtension() == null) {
            stringArray[0] = "EJB_JAR_EXTENSION";
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
        if (ejbRelationship.getRelationshipRoles().size() != 2) {
            stringArray[0] = "EJB_JAR_EXTENSION";
            stringArray[2] = "2";
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NUMBER", stringArray);
            return;
        }
        EjbRelationshipRole ejbRelationshipRole = ejbRelationship.getFirstRole();
        EjbRelationshipRole ejbRelationshipRole2 = ejbRelationship.getSecondRole();
        if (!ejbRelationshipRole.getMultiplicity().isMany() && ejbRelationshipRole2.getMultiplicity().isMany()) {
            stringArray[0] = "ONE_MANY";
            if (ejbRelationshipRole.isForward()) {
                stringArray[1] = "FIRST_ROLE";
                stringArray[2] = new Boolean(ejbRelationshipRole.isForward()).toString();
                this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_EJBRELATIONSHIP_FORWARD_VALUE", stringArray);
            }
            if (!ejbRelationshipRole2.isForward()) {
                stringArray[1] = "SECOND_ROLE";
                stringArray[2] = new Boolean(ejbRelationshipRole2.isForward()).toString();
                this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_EJBRELATIONSHIP_FORWARD_VALUE", stringArray);
            }
        }
        if (ejbRelationshipRole.getMultiplicity().isMany() && !ejbRelationshipRole2.getMultiplicity().isMany()) {
            stringArray[0] = "MANY_ONE";
            if (!ejbRelationshipRole.isForward()) {
                stringArray[1] = "FIRST_ROLE";
                stringArray[2] = new Boolean(ejbRelationshipRole.isForward()).toString();
                this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_EJBRELATIONSHIP_FORWARD_VALUE", stringArray);
            }
            if (ejbRelationshipRole2.isForward()) {
                stringArray[1] = "SECOND_ROLE";
                stringArray[2] = new Boolean(ejbRelationshipRole2.isForward()).toString();
                this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_EJBRELATIONSHIP_FORWARD_VALUE", stringArray);
            }
        }
        if (!ejbRelationshipRole.getMultiplicity().isMany() && !ejbRelationshipRole2.getMultiplicity().isMany() && !ejbRelationshipRole.isForward() != ejbRelationshipRole2.isForward()) {
            stringArray[0] = "ONE_ONE";
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_EJBRELATIONSHIP_FORWARD_OPPOSITE");
        }
    }

    private void validate(EjbRelationshipRole ejbRelationshipRole) {
        String[] stringArray = new String[2];
        stringArray[1] = "EJB_RELATIONSHIP_ROLE";
        stringArray[0] = "CONTAINER_MANAGED_ENTITY_EXTENSION ";
        if (ejbRelationshipRole.getBeanExtension() == null) {
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
        stringArray[0] = "EJB_RELATIONSHIP";
        if (ejbRelationshipRole.getRelationship() == null) {
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
    }

    private void validate(EnterpriseBeanExtension enterpriseBeanExtension) {
        Object object;
        int n;
        String[] stringArray = new String[2];
        stringArray[1] = "ENTERPRISE_BEAN_EXTENSION";
        stringArray[0] = "EJB_JAR_EXTENSION";
        if (enterpriseBeanExtension.getEjbJarExtension() == null) {
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
        stringArray[0] = "ENTERPRISE_BEAN";
        if (enterpriseBeanExtension.getEnterpriseBean() == null) {
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
        EList eList = enterpriseBeanExtension.getIsolationLevelAttributes();
        BasicEList basicEList = new BasicEList();
        for (n = 0; n < eList.size(); ++n) {
            object = (IsolationLevelAttributes)eList.get(n);
            this.validate((IsolationLevelAttributes)object);
            basicEList.add((Object)object.getMethodElements());
        }
        this.validateMethodElements((EList)basicEList, "ISOLATION_LEVEL_ATTRIBUTES");
        eList = enterpriseBeanExtension.getMethodSessionAttributes();
        basicEList = new BasicEList();
        for (n = 0; n < eList.size(); ++n) {
            object = (ContainerActivitySession)eList.get(n);
            this.validate((ContainerActivitySession)object);
            basicEList.add((Object)object.getMethodElement());
        }
        this.validateMethodElements((EList)basicEList, "CONTAINER_ACTIVITY_SESSION");
        eList = enterpriseBeanExtension.getRunAsSettings();
        basicEList = new BasicEList();
        for (n = 0; n < eList.size(); ++n) {
            object = (SecurityIdentity)eList.get(n);
            this.validate((SecurityIdentity)object);
            basicEList.add((Object)object.getMethodElements());
        }
        this.validateMethodElements((EList)basicEList, "SECURITY_IDENTITY");
        if (enterpriseBeanExtension.getLocalTran() != null) {
            this.validate(enterpriseBeanExtension.getLocalTran());
        }
        if (enterpriseBeanExtension.getBeanCache() != null) {
            this.validate(enterpriseBeanExtension.getBeanCache());
        }
        if (enterpriseBeanExtension.getInternationalization() != null) {
            this.validate(enterpriseBeanExtension.getInternationalization());
        }
        if (enterpriseBeanExtension.getStructure() != null) {
            this.validate(enterpriseBeanExtension.getStructure());
        }
        if (enterpriseBeanExtension instanceof SessionExtension) {
            this.validate((SessionExtension)enterpriseBeanExtension);
        } else if (enterpriseBeanExtension instanceof ContainerManagedEntityExtension) {
            this.validate((ContainerManagedEntityExtension)enterpriseBeanExtension);
        }
    }

    private void validate(FinderDescriptor finderDescriptor) {
        String[] stringArray = new String[4];
        stringArray[1] = "FINDER_DESCRIPTOR";
        stringArray[0] = "METHOD_ELEMENT";
        EList eList = finderDescriptor.getFinderMethodElements();
        if (eList.size() != 1) {
            stringArray[2] = "1";
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NUMBER", stringArray);
        }
        for (int i = 0; i < eList.size(); ++i) {
            MethodElement methodElement = (MethodElement)eList.get(i);
            if (methodElement.getType().getValue() != 2) {
                stringArray[2] = "HOME ";
                this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_TYPE", stringArray);
            }
            if (methodElement.getMethods().length == 1) continue;
            stringArray[2] = "METHOD ";
            stringArray[3] = "1";
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_FINDERDESCRIPTOR_WRONG_METHOD", stringArray);
        }
        if (finderDescriptor instanceof EjbqlFinderDescriptor) {
            this.validate((EjbqlFinderDescriptor)finderDescriptor);
        }
        if (finderDescriptor instanceof FullSelectFinderDescriptor) {
            this.validate((FullSelectFinderDescriptor)finderDescriptor);
        }
        if (finderDescriptor instanceof WhereClauseFinderDescriptor) {
            this.validate((WhereClauseFinderDescriptor)finderDescriptor);
        }
    }

    private void validate(FullSelectFinderDescriptor fullSelectFinderDescriptor) {
    }

    private void validate(IsolationLevelAttributes isolationLevelAttributes) {
        if (isolationLevelAttributes.getMethodElements().size() == 0) {
            String[] stringArray = new String[2];
            stringArray[1] = "ISOLATION_LEVEL_ATTRIBUTES";
            stringArray[0] = "METHOD_ELEMENT";
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
    }

    private void validate(LocalTran localTran) {
    }

    private void validate(PersistenceSecurityIdentity persistenceSecurityIdentity) {
        RunAsMode runAsMode = persistenceSecurityIdentity.getRunAsMode();
        if (runAsMode == null) {
            String[] stringArray = new String[2];
            stringArray[1] = "PERSISTENCE_SECURITY_IDENTITY";
            stringArray[0] = "RUN_AS_MODE";
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        } else {
            this.validate(runAsMode);
        }
    }

    private void validate(RunAsMode runAsMode) {
        if (runAsMode instanceof RunAsSpecifiedIdentity) {
            this.validate((RunAsSpecifiedIdentity)runAsMode);
        } else if (runAsMode instanceof UseSystemIdentity) {
            this.validate((UseSystemIdentity)runAsMode);
        } else if (runAsMode instanceof UseCallerIdentity) {
            this.validate((UseCallerIdentity)runAsMode);
        }
    }

    private void validate(RunAsSpecifiedIdentity runAsSpecifiedIdentity) {
    }

    private void validate(SecurityIdentity securityIdentity) {
        String[] stringArray = new String[2];
        stringArray[1] = "SECURITY_IDENTITY";
        RunAsMode runAsMode = securityIdentity.getRunAsMode();
        if (runAsMode == null) {
            stringArray[0] = "RUN_AS_MODE";
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        } else {
            this.validate(runAsMode);
        }
        if (securityIdentity.getMethodElements().size() == 0) {
            stringArray[0] = "METHOD_ELEMENT";
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_REFERENCE_NOTEXIST", stringArray);
        }
    }

    private void validate(SessionExtension sessionExtension) {
        if (sessionExtension.getTimeout() < 0) {
            String[] stringArray = new String[3];
            stringArray[1] = "SESSION_EXTENSION ";
            stringArray[0] = "TIMEOUT ";
            stringArray[2] = String.valueOf(sessionExtension.getTimeout());
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_VALUE_RANGE", stringArray);
        }
    }

    private void validate(UseCallerIdentity useCallerIdentity) {
    }

    private void validate(UseSystemIdentity useSystemIdentity) {
    }

    private void validate(WhereClauseFinderDescriptor whereClauseFinderDescriptor) {
    }

    public void validate(IHelper iHelper, IReporter iReporter, IFileDelta[] iFileDeltaArray) throws ValidationException {
        super.validate(iHelper, iReporter, iFileDeltaArray);
        if (iHelper == null || iReporter == null) {
            return;
        }
        this.validate(iHelper.loadModel(""));
    }

    public void validate(Object object) {
        if (object instanceof List) {
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                this.validate(iterator.next());
            }
        } else if (object instanceof EJBJarExtension) {
            this.validate((EJBJarExtension)object);
        } else {
            this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "ERROR_TARGET", new String[]{object.getClass().getName()});
        }
    }

    private void validateForAssociations(ContainerManagedEntityExtension containerManagedEntityExtension) {
        EList eList = containerManagedEntityExtension.getLocalRelationshipRoles();
        for (int i = 0; i < eList.size(); ++i) {
            this.validate((EjbRelationshipRole)eList.get(i));
        }
    }

    private void validateForAssociations(EJBJarExtension eJBJarExtension) {
        int n;
        EList eList = eJBJarExtension.getGeneralizations();
        for (n = 0; n < eList.size(); ++n) {
            this.validate((EjbGeneralization)eList.get(n));
        }
        eList = eJBJarExtension.getEjbRelationships();
        for (n = 0; n < eList.size(); ++n) {
            this.validate((EjbRelationship)eList.get(n));
        }
    }

    private void validateForFinders(ContainerManagedEntityExtension containerManagedEntityExtension) {
        EList eList = containerManagedEntityExtension.getFinderDescriptors();
        for (int i = 0; i < eList.size(); ++i) {
            this.validate((FinderDescriptor)eList.get(i));
        }
    }

    private void validateMethodElements(EList eList, String string) {
        String[] stringArray = new String[2];
        stringArray[1] = string;
        BasicEList basicEList = new BasicEList();
        for (int i = 0; i < eList.size(); ++i) {
            EList eList2 = (EList)eList.get(i);
            for (int j = 0; j < eList2.size(); ++j) {
                MethodElement methodElement = (MethodElement)eList2.get(j);
                String string2 = methodElement.getType().toString();
                stringArray[0] = string2 + "." + methodElement.getName();
                if (basicEList.contains((Object)stringArray[0])) {
                    this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "MESSAGE_DEFINITION_OVERLAP", stringArray);
                    continue;
                }
                if (methodElement.getName().equals("*")) {
                    if (basicEList.contains((Object)(string2 + ".**"))) {
                        this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "MESSAGE_DEFINITION_OVERLAP", stringArray);
                    }
                } else if (basicEList.contains((Object)(string2 + ".*"))) {
                    this.addError("com.ibm.websphere.validation.base.extensions.ejbext.ejbextvalidation", "MESSAGE_DEFINITION_OVERLAP", stringArray);
                } else {
                    basicEList.add((Object)(string2 + ".**"));
                }
                basicEList.add((Object)stringArray[0]);
            }
        }
    }
}

