/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.security.AuthMechanism;
import com.ibm.websphere.models.config.security.LTPA;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level60.SecurityValidator_60_Default;
import java.util.Iterator;

public class SecurityNDValidator_60_Default
extends SecurityValidator_60_Default {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";

    public SecurityNDValidator_60_Default(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    public String getTraceName() {
        return "SecurityNDValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof LTPA) {
            this.trace("Object recognized as an LTPA; validating");
            this.validateLocal((LTPA)object);
            this.validateAcross((LTPA)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(LTPA lTPA) {
        if (lTPA.getShared() == null) {
            this.addError("ERROR_LTPA_SHARED_KEY_REQUIRED", new String[]{lTPA.getOID()}, lTPA);
        }
        if (lTPA.getPublic() == null) {
            this.addError("ERROR_LTPA_PUBLIC_KEY_REQUIRED", new String[]{lTPA.getOID()}, lTPA);
        }
        if (lTPA.getPrivate() == null) {
            this.addError("ERROR_LTPA_PRIVATE_KEY_REQUIRED", new String[]{lTPA.getOID()}, lTPA);
        }
        this.validateAcross((AuthMechanism)lTPA);
    }

    protected void validateActiveUserRegistry(Security security) {
        UserRegistry userRegistry;
        String string;
        boolean bl = security.isEnabled();
        if (bl && ((string = (userRegistry = security.getActiveUserRegistry()).getServerId()) == null || string.length() == 0)) {
            this.addError("ERROR_USER_REGISTRY_SERVER_ID_REQUIRED", new String[]{this.getCurrentFileName()}, userRegistry);
        }
    }

    protected void validateCacheTimeouts(Security security) {
        int n = security.getCacheTimeout();
        if (n < 1) {
            return;
        }
        Iterator iterator = security.getAuthMechanisms().iterator();
        while (iterator.hasNext()) {
            LTPA lTPA;
            long l;
            AuthMechanism authMechanism = (AuthMechanism)iterator.next();
            if (!(authMechanism instanceof LTPA) || (l = (lTPA = (LTPA)authMechanism).getTimeout()) <= 0L || (long)n >= l) continue;
            this.addError("ERROR_LTPA_SECURITY_CACHE_TIMEOUT_LESS_THAN_LTPA_TIMEOUT", new String[]{this.getCurrentFileName(), String.valueOf(n), lTPA.getOID(), String.valueOf(l)}, lTPA);
        }
    }
}

