/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroup;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroupMember;
import com.ibm.websphere.validation.base.config.WebSphereLevelCrossValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.base.config.level60.NodeGroupValidationConstants_60;
import java.util.HashSet;
import java.util.Iterator;

public class NodeGroupCrossValidator_60
extends WebSphereLevelCrossValidator
implements NodeGroupValidationConstants_60 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";

    public NodeGroupCrossValidator_60(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level60.nodegroupvalidation_60_NLS";
    }

    public String getTraceName() {
        return "NodeGroupCrossValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof NodeGroup) {
            this.trace("Object recognized as an NodeGroup; validating");
            this.validateAcross((NodeGroup)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(NodeGroup nodeGroup) {
        this.traceBegin("validateAcross(NodeGroup) [Document]");
        HashSet hashSet = this.getNodeNames();
        Iterator iterator = nodeGroup.getMembers().iterator();
        while (iterator.hasNext()) {
            NodeGroupMember nodeGroupMember = (NodeGroupMember)iterator.next();
            this.validateNodeGroupMemberName(nodeGroupMember, hashSet);
        }
        this.traceEnd();
    }

    protected void validateNodeGroupMemberName(NodeGroupMember nodeGroupMember, HashSet hashSet) {
        String string = nodeGroupMember.getNodeName();
        this.traceBegin("validateNodeGroupMemberName(NodeGroupMember)", string);
        if (!hashSet.contains(string)) {
            this.addError("ERROR_NO_MATCHING_MEMBER_NODES", new String[]{string}, nodeGroupMember);
        }
        this.traceEnd();
    }
}

