/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.hamanagerservice.HAManagerService;
import com.ibm.websphere.models.config.process.ThreadPool;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level60.HAManagerServiceValidationConstants_60;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class HAManagerServiceValidator_60
extends WebSphereLevelValidator
implements HAManagerServiceValidationConstants_60 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";

    public HAManagerServiceValidator_60(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level60.hamanagerservicevalidation_60_NLS";
    }

    public String getTraceName() {
        return "HAManagerServiceValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof HAManagerService) {
            this.trace("Object recognized as an instance of HAManagerService; validating");
            HAManagerService hAManagerService = (HAManagerService)object;
            this.validateLocal(hAManagerService);
            this.validateAcross(hAManagerService);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateLocal(HAManagerService hAManagerService) {
        String string = hAManagerService.getCoreGroupName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_NULL_OR_EMPTY_COREGROUP_NAME", new String[]{this.getCurrentFileName()}, hAManagerService);
        } else if (!this.testName(string)) {
            this.addError("ERROR_INVALID_COREGROUP_NAME", new String[]{string}, hAManagerService);
        }
        int n = hAManagerService.getIsAlivePeriodSec();
        if (n < -1) {
            this.addError("ERROR_INVALID_ISALIVEPERIODSEC", new String[]{String.valueOf(n), String.valueOf(-1)}, hAManagerService);
        }
        int n2 = hAManagerService.getTransportBufferSize();
        this.testInteger(n2, 1, 10, "ERROR_TRANSPORT_BUFFER_SIZE_OUT_OF_RANGE", hAManagerService);
        ThreadPool threadPool = hAManagerService.getThreadPool();
        if (threadPool == null) {
            this.addError("ERROR_NULL_THREAD_POOL", new String[]{this.getCurrentFileName()}, hAManagerService);
        } else {
            this.validateLocal(threadPool);
            this.validateAcross(threadPool);
        }
        EList eList = hAManagerService.getProperties();
        if (!eList.isEmpty()) {
            this.validateProperties(hAManagerService, null, (List)eList, "ERROR_CUSTOMPROPERTY_DUPLICATION", "ERROR_CUSTOMPROPERTY_NAME_REQUIRED");
        }
    }

    private void validateAcross(HAManagerService hAManagerService) {
    }
}

