/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.coregroupbridgeservice.AccessPointGroup;
import com.ibm.websphere.models.config.coregroupbridgeservice.BridgeInterface;
import com.ibm.websphere.models.config.coregroupbridgeservice.CoreGroupAccessPoint;
import com.ibm.websphere.models.config.coregroupbridgeservice.CoreGroupBridgeSettings;
import com.ibm.websphere.models.config.coregroupbridgeservice.PeerAccessPoint;
import com.ibm.websphere.models.config.coregroupbridgeservice.WLMCoreGroupBridgePlugin;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level60.CoreGroupBridgeValidationConstants_60;
import com.ibm.websphere.validation.base.config.level60.ServerContextValidator_60;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;

public class CoreGroupBridgeValidator_60_Default
extends ServerContextValidator_60
implements CoreGroupBridgeValidationConstants_60 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    protected boolean _pastTopList = false;
    protected CoreGroupBridgeSettings _boundCGBridgeSettings = null;

    public CoreGroupBridgeValidator_60_Default(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._pastTopList = false;
        this._boundCGBridgeSettings = null;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._pastTopList = false;
        this._boundCGBridgeSettings = null;
    }

    protected void bindCGBridgeSettings(CoreGroupBridgeSettings coreGroupBridgeSettings) {
        this._boundCGBridgeSettings = coreGroupBridgeSettings;
    }

    protected CoreGroupBridgeSettings getBoundCGBridgeSettings() {
        return this._boundCGBridgeSettings;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level60.coregroupbridgevalidation_60_NLS";
    }

    public String getTraceName() {
        return "CoreGroupBridgeBaseValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        if (object instanceof CoreGroupBridgeSettings) {
            this.trace("Object recognized as a CoreGroupBridgeSettings; validating");
            this.bindCGBridgeSettings((CoreGroupBridgeSettings)object);
            this.validateLocal((CoreGroupBridgeSettings)object);
            this.validateAcross((CoreGroupBridgeSettings)object);
        } else if (object instanceof WLMCoreGroupBridgePlugin) {
            this.trace("Object recognized as a WLMCoreGroupBridgePlugin; validating");
            this.validateLocal((WLMCoreGroupBridgePlugin)object);
            this.validateAcross((WLMCoreGroupBridgePlugin)object);
        } else if (object instanceof AccessPointGroup) {
            this.trace("Object recognized as a AccessPointGroup; validating");
            this.validateLocal((AccessPointGroup)object);
            this.validateAcross((AccessPointGroup)object);
        } else if (object instanceof PeerAccessPoint) {
            this.trace("Object recognized as a PeerAccessPoint; validating");
            this.validateLocal((PeerAccessPoint)object);
            this.validateAcross((PeerAccessPoint)object);
        } else if (object instanceof CoreGroupAccessPoint) {
            this.trace("Object recognized as a CoreGroupAccessPoint; validating");
            this.validateLocal((CoreGroupAccessPoint)object);
            this.validateAcross((CoreGroupAccessPoint)object);
        } else if (object instanceof BridgeInterface) {
            this.trace("Object recognized as a BridgeInterface; validating");
            this.validateLocal((BridgeInterface)object);
        } else if (object instanceof EndPoint) {
            this.trace("Object recognized as a EndPoint; validating");
            super.validateLocal((EndPoint)object);
        }
        return true;
    }

    public void validateAcross(CoreGroupBridgeSettings coreGroupBridgeSettings) {
        this.traceStub("validateAcross(CoreGroupBridgeSettings)");
        EList eList = coreGroupBridgeSettings.getAccessPointGroups();
        int n = eList.size();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            AccessPointGroup accessPointGroup = (AccessPointGroup)eList.get(i);
            if (hashSet.contains(accessPointGroup.getName())) {
                this.addError("ERROR_CGBRIDGE_ACCESSPOINTGROUP_NAME_COLLISION", new String[]{accessPointGroup.getName()}, coreGroupBridgeSettings);
            }
            hashSet.add(accessPointGroup.getName());
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        EList eList2 = coreGroupBridgeSettings.getCoreGroupAccessPoints();
        int n2 = eList2.size();
        for (int i = 0; i < n2; ++i) {
            CoreGroupAccessPoint coreGroupAccessPoint = (CoreGroupAccessPoint)eList2.get(i);
            EList eList3 = coreGroupAccessPoint.getBridgeInterfaces();
            int n3 = eList3.size();
            for (int j = 0; j < n3; ++j) {
                BridgeInterface bridgeInterface = (BridgeInterface)eList3.get(j);
                String string = bridgeInterface.getNode();
                String string2 = bridgeInterface.getServer();
                String string3 = bridgeInterface.getServer();
                if (string == null || string2 == null || string3 == null) continue;
                String string4 = string + ":" + string2 + ":" + string3;
                if (hashSet2.contains(string4)) {
                    this.addError("ERROR_CGBRIDGE_CHAIN_COLLISION", new String[]{bridgeInterface.getChain(), bridgeInterface.getServer(), bridgeInterface.getNode()}, coreGroupBridgeSettings);
                    return;
                }
                hashSet2.add(string4);
            }
        }
    }

    public void validateAcross(WLMCoreGroupBridgePlugin wLMCoreGroupBridgePlugin) {
    }

    public void validateAcross(AccessPointGroup accessPointGroup) {
        int n;
        this.traceStub("validateAcross(AccessPointGroup)");
        EList eList = accessPointGroup.getCoreGroupAccessPointRefs();
        int n2 = eList.size();
        if (n2 == 0) {
            this.addError("ERROR_ACCESSPOINTGROUP_COREGROUPACCESSPOINTS_REQUIRED", new String[]{accessPointGroup.getName()}, accessPointGroup);
        }
        eList = accessPointGroup.getCoreGroupAccessPointRefs();
        int n3 = eList.size();
        HashSet<String> hashSet = new HashSet<String>();
        for (n = 0; n < n3; ++n) {
            CoreGroupAccessPoint coreGroupAccessPoint = (CoreGroupAccessPoint)eList.get(n);
            if (hashSet.contains(coreGroupAccessPoint.getName())) {
                this.addError("ERROR_ACCESSPOINTGROUP_COREGROUPACCESSPOINT_NAME_COLLISION", new String[]{accessPointGroup.getName(), coreGroupAccessPoint.getName()}, accessPointGroup);
            }
            hashSet.add(coreGroupAccessPoint.getName());
        }
        eList = accessPointGroup.getPeerAccessPointRefs();
        n = eList.size();
        hashSet.clear();
        for (int i = 0; i < n; ++i) {
            PeerAccessPoint peerAccessPoint = (PeerAccessPoint)eList.get(i);
            if (hashSet.contains(peerAccessPoint.getName())) {
                this.addError("ERROR_ACCESSPOINTGROUP_PEERPACCESSPOINT_NAME_COLLISION", new String[]{accessPointGroup.getName(), peerAccessPoint.getName()}, accessPointGroup);
            }
            hashSet.add(peerAccessPoint.getName());
        }
        if (n != 0 && n2 != 1) {
            this.addError("ERROR_ACCESSPOINTGROUP_COREGROUPACCESSPOINT_COUNT_FOR_PEER", new String[]{accessPointGroup.getName()}, accessPointGroup);
        }
    }

    public void validateAcross(PeerAccessPoint peerAccessPoint) {
        this.traceStub("validateAcross(PeerAccessPoint)");
        EList eList = peerAccessPoint.getPeerEndPoints();
        int n = eList.size();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            EndPoint endPoint = (EndPoint)eList.get(i);
            String string = endPoint.getHost() + ":" + endPoint.getPort();
            if (hashSet.contains(string)) {
                this.addError("ERROR_PEERACCESSPOINT_ENDPOINT_NAME_COLLISION", peerAccessPoint);
            }
            hashSet.add(string);
        }
        PeerAccessPoint peerAccessPoint2 = peerAccessPoint.getProxyPeerAccessPointRef();
        if (peerAccessPoint2 != null && peerAccessPoint2.getPeerEndPoints().size() == 0) {
            this.addError("ERROR_PEERACCESSPOINT_PROXYPEERACCESSPOINT_ENDPOINT_REQUIRED", new String[]{peerAccessPoint.getName()}, peerAccessPoint);
        }
    }

    public void validateAcross(CoreGroupAccessPoint coreGroupAccessPoint) {
        this.traceStub("validateAcross(CoreGroupAccessPoint)");
        EList eList = coreGroupAccessPoint.getBridgeInterfaces();
        int n = eList.size();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            BridgeInterface bridgeInterface = (BridgeInterface)eList.get(i);
            String string = bridgeInterface.getNode();
            String string2 = bridgeInterface.getServer();
            if (string == null || string2 == null) continue;
            String string3 = string + ":" + string2;
            if (hashSet.contains(string3)) {
                this.addError("ERROR_COREGROUPACCESSPOINT_BRIDGEINTERFACE_NAME_COLLISION", new String[]{coreGroupAccessPoint.getName(), string2, string}, coreGroupAccessPoint);
                return;
            }
            hashSet.add(string3);
        }
    }

    public void validateAcross(EndPoint endPoint) {
        this.traceStub("validateAcross(Property)");
        super.validateAcross(endPoint);
    }

    public void validateLocal(CoreGroupBridgeSettings coreGroupBridgeSettings) {
    }

    public void validateLocal(WLMCoreGroupBridgePlugin wLMCoreGroupBridgePlugin) {
        String string = wLMCoreGroupBridgePlugin.getCoreGroup();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_WLMCGBRIDGEPLUGIN_COREGROUP_REQUIRED", wLMCoreGroupBridgePlugin);
        }
    }

    public void validateLocal(AccessPointGroup accessPointGroup) {
        this.traceStub("validateLocal(AccessPointGroup)");
        String string = accessPointGroup.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_ACCESSPOINTGROUP_NAME_REQUIRED", accessPointGroup);
        }
    }

    public void validateLocal(PeerAccessPoint peerAccessPoint) {
        this.traceStub("validateLocal(PeerAccessPoint)");
        String string = peerAccessPoint.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_PEERACCESSPOINT_NAME_REQUIRED", peerAccessPoint);
        }
        if ((string = peerAccessPoint.getCell()) == null || string.length() == 0) {
            this.addError("ERROR_PEERACCESSPOINT_CELL_REQUIRED", peerAccessPoint);
        }
        if ((string = peerAccessPoint.getCoreGroup()) == null || string.length() == 0) {
            this.addError("ERROR_PEERACCESSPOINT_COREGROUP_REQUIRED", peerAccessPoint);
        }
        if ((string = peerAccessPoint.getCoreGroupAccessPoint()).length() == 0) {
            this.addError("ERROR_PEERACCESSPOINT_COREGROUPACCESSPOINT_REQUIRED", peerAccessPoint);
        }
        if (peerAccessPoint.getProxyPeerAccessPointRef() != null && peerAccessPoint.getPeerEndPoints().size() > 0) {
            this.addError("ERROR_PEERACCESSPOINT_PROXYPEERACCESSPOINT_ENDPOINT_COLLISION", new String[]{peerAccessPoint.getName()}, peerAccessPoint);
        }
    }

    public void validateLocal(CoreGroupAccessPoint coreGroupAccessPoint) {
        this.traceStub("validateLocal(CoreGroupAccessPoint)");
        String string = coreGroupAccessPoint.getName();
        if (string.length() == 0) {
            this.addError("ERROR_COREGROUPACCESSPOINT_NAME_REQUIRED", coreGroupAccessPoint);
        }
        if ((string = coreGroupAccessPoint.getCoreGroup()) == null || string.length() == 0) {
            this.addError("ERROR_COREGROUPACCESSPOINT_COREGROUP_REQUIRED", coreGroupAccessPoint);
        }
    }

    public void validateLocal(BridgeInterface bridgeInterface) {
        this.traceStub("validateLocal(BridgeInterface)");
        String string = bridgeInterface.getNode();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_BRIDGEINTERFACE_NODE_REQUIRED", bridgeInterface);
        }
        if ((string = bridgeInterface.getServer()) == null || string.length() == 0) {
            this.addError("ERROR_BRIDGEINTERFACE_SERVER_REQUIRED", bridgeInterface);
        }
        if ((string = bridgeInterface.getChain()) == null || string.length() == 0) {
            this.addError("ERROR_BRIDGEINTERFACE_CHAIN_REQUIRED", bridgeInterface);
        }
    }
}

