/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level51;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.datareplicationserver.SystemMessageServer;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.multibroker.MultiBrokerRoutingEntry;
import com.ibm.websphere.models.config.multibroker.MultibrokerDomain;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.validation.base.config.WebSphereLevelCrossValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.base.config.level51.ServerValidationConstants_51;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;

public class ServerCrossValidator_51
extends WebSphereLevelCrossValidator
implements ServerValidationConstants_51 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";

    public ServerCrossValidator_51(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level51.servervalidation_51_NLS";
    }

    public String getTraceName() {
        return "ServerCrossValidator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Object object) throws ValidationException {
        block10: {
            this.traceBegin("visit(Object)");
            try {
                if (object instanceof List) {
                    this.visitList((List)object);
                    break block10;
                }
                if (object instanceof EObject && !(object instanceof EEnumLiteral)) {
                    if (!this._parents.contains(object)) {
                        this._parents.add(object);
                        try {
                            this.basicVisit(object);
                            this.visitList(this.getChildren(object));
                            break block10;
                        }
                        finally {
                            this._parents.remove(object);
                        }
                    }
                    this.trace("Object already visited; skipping");
                    break block10;
                }
                if (this.isTraceEnabled()) {
                    this.trace("Not a Ref Object; skipping");
                }
            }
            finally {
                this.traceEnd();
            }
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        if (object instanceof Server) {
            this.trace("Object recognized as a server; validating");
            this.validateAcross((Server)object);
        } else if (object instanceof SystemMessageServer) {
            this.trace("Object recognized as a system message server; validating");
            this.validateAcross((SystemMessageServer)object);
        } else if (object instanceof DRSSettings) {
            this.trace("Object recognized as DRS settings; validating");
            this.validateAcross((DRSSettings)object);
        } else if (object instanceof WebContainer) {
            this.trace("Object recognized as a session manager; validating");
            this.validateAcross((WebContainer)object);
        }
        return true;
    }

    public void validateAcross(Server server) {
        this.validateServerClusterName(server);
    }

    protected void validateServerClusterName(Server server) {
        Object object;
        String string;
        String string2 = server.getName();
        this.trace("Validating cluster name for server: ", string2);
        String string3 = server.getClusterName();
        this.trace("Validating cluster name for server: ", string2);
        if (string3 == null || string3.length() == 0) {
            this.trace("No cluster name was specified; returning.");
            return;
        }
        this.trace("Cluster name of server: ", string3);
        Iterator iterator = this.getClusterNames().iterator();
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            string = (String)iterator.next();
            bl = string3.equals(string);
        }
        if (!bl) {
            this.addError("ERROR_SERVER_CLUSTER_NAME_MATCHES_NO_CLUSTER", new String[]{string2, string3}, server);
            return;
        }
        string = this.getCellUri() + "/" + "clusters" + "/" + string3 + "/" + "cluster.xml";
        this.trace("Cluster URI: ", string);
        Object object2 = this.loadModel(string);
        if (object2 == null) {
            this.trace("Unable to load cluster.");
            object = null;
        } else if (!(object2 instanceof List)) {
            this.trace("Loaded cluster is not a list.");
            object = object2;
        } else {
            Iterator iterator2 = ((List)object2).iterator();
            if (!iterator2.hasNext()) {
                this.trace("Loaded cluster is an empty list.");
                object = null;
            } else {
                object = iterator2.next();
            }
        }
        boolean bl2 = false;
        if (object != null && !(object instanceof ServerCluster)) {
            this.trace("Loaded cluster is not a server cluster.");
            object = null;
        } else {
            ServerCluster serverCluster = (ServerCluster)object;
            Iterator iterator3 = serverCluster.getMembers().iterator();
            while (!bl2 && iterator3.hasNext()) {
                ClusterMember clusterMember = (ClusterMember)iterator3.next();
                String string4 = clusterMember.getMemberName();
                bl2 = string2.equals(string4);
                if (bl2) {
                    this.trace("Match against member name: ", string4);
                    continue;
                }
                this.trace("No match against member name: ", string4);
            }
        }
        if (!bl2) {
            this.trace("No member was found");
            this.addError("ERROR_SERVER_NOT_PRESENT_IN_CLUSTER", new String[]{string2, string3}, server);
        } else {
            this.trace("A member was found");
        }
    }

    protected void validateAcross(SystemMessageServer systemMessageServer) {
        this.trace("validateAcross(SystemMessageServer)");
        String string = systemMessageServer.getBrokerName();
        String string2 = systemMessageServer.getDomainName();
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return;
        }
        Iterator iterator = this.getMultibrokerDomains().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            MultibrokerDomain multibrokerDomain = (MultibrokerDomain)iterator.next();
            String string3 = multibrokerDomain.getName();
            if (!string2.equals(string3)) continue;
            Iterator iterator2 = multibrokerDomain.getEntries().iterator();
            while (iterator2.hasNext()) {
                MultiBrokerRoutingEntry multiBrokerRoutingEntry = (MultiBrokerRoutingEntry)iterator2.next();
                String string4 = multiBrokerRoutingEntry.getBrokerName();
                if (!string.equals(string4)) continue;
                ++n;
            }
        }
        if (n == 0) {
            if (this.isSetToStart(systemMessageServer)) {
                this.addError("ERROR_SYSTEM_MESSAGE_SERVER_NO_BROKER_MATCHES", new String[]{systemMessageServer.getName(), string2, string}, systemMessageServer);
            } else {
                this.addWarning("WARNING_SYSTEM_MESSAGE_SERVER_NO_BROKER_MATCHES", new String[]{systemMessageServer.getName(), string2, string}, systemMessageServer);
            }
        } else if (n != 1) {
            this.addError("ERROR_SYSTEM_MESSAGE_SERVER_MULTIPLE_BROKER_MATCHES", new String[]{systemMessageServer.getName(), string2, string}, systemMessageServer);
        }
    }

    public void validateAcross(SessionManager sessionManager) {
        Object object;
        Object object2;
        int n = sessionManager.getSessionPersistenceMode().getValue();
        if (n == 2) {
            return;
        }
        DRSSettings dRSSettings = sessionManager.getSessionDRSPersistence();
        if (dRSSettings == null) {
            return;
        }
        String string = dRSSettings.getMessageBrokerDomainName();
        if (string == null || string.length() == 0) {
            return;
        }
        Iterator iterator = this.getMultibrokerDomains().iterator();
        Object object3 = null;
        while (object3 == null && iterator.hasNext()) {
            object2 = (MultibrokerDomain)iterator.next();
            object = object2.getName();
            if (!string.equals(object)) continue;
            object3 = object2;
        }
        if (object3 == null) {
            this.addError("ERROR_SESSION_MANAGER_NO_MATCHING_DOMAIN", new String[]{string}, sessionManager);
            return;
        }
        object2 = dRSSettings.getPreferredLocalDRSBrokerName();
        if (object2 == null || ((String)object2).length() == 0) {
            return;
        }
        object = object3.getEntries().iterator();
        MultiBrokerRoutingEntry multiBrokerRoutingEntry = null;
        while (multiBrokerRoutingEntry == null && object.hasNext()) {
            MultiBrokerRoutingEntry multiBrokerRoutingEntry2 = (MultiBrokerRoutingEntry)object.next();
            String string2 = multiBrokerRoutingEntry2.getBrokerName();
            if (!((String)object2).equals(string2)) continue;
            multiBrokerRoutingEntry = multiBrokerRoutingEntry2;
        }
        if (object3 == null) {
            this.addError("ERROR_SESSION_MANAGER_NO_MATCHING_ENTRY", new String[]{string, object2}, sessionManager);
        }
    }

    public void validateAcross(WebContainer webContainer) {
        Iterator iterator = webContainer.getTransports().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        HashSet hashSet = this.getCellSecurityAliasTable();
        while (iterator.hasNext()) {
            String string;
            Transport transport = (Transport)iterator.next();
            boolean bl = transport.isSslEnabled();
            if (!bl || (string = transport.getSslConfig()) == null && string.length() == 0 || hashSet.contains(string)) continue;
            EndPoint endPoint = transport.getAddress();
            String string2 = endPoint != null ? endPoint.getHost() : null;
            int n = endPoint != null ? endPoint.getPort() : 0;
            String string3 = String.valueOf(n);
            this.addError("ERROR_TRANSPORT_ALIAS_NOT_FOUND", new String[]{webContainer.getName(), string2, string3, string}, transport);
        }
    }

    public void validateAcross(DRSSettings dRSSettings) {
        String string = dRSSettings.getPreferredLocalDRSBrokerName();
        if (string == null || string.length() == 0) {
            return;
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
        Iterator iterator = this.getNodeSystemMessageServers().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            SystemMessageServer systemMessageServer = (SystemMessageServer)objectArray[3];
            String string2 = systemMessageServer.getBrokerName();
            if (!string.equals(string2)) continue;
            if (this.isSetToStart(systemMessageServer)) {
                arrayList.add(objectArray);
                continue;
            }
            arrayList2.add(objectArray);
        }
        int n = arrayList.size();
        int n2 = arrayList2.size();
        if (n == 0) {
            if (n2 == 0) {
                this.addError("ERROR_DRS_SETTINGS_NO_SYSTEM_MESSAGE_SERVER", new String[]{string}, dRSSettings);
            } else {
                this.addError("ERROR_DRS_SETTINGS_STOPPED_SYSTEM_MESSAGE_SERVER", new String[]{string}, dRSSettings);
            }
        } else if (n > 0) {
            this.addError("ERROR_DRS_SETTINGS_MULTIPLE_STARTING_SYSTEM_MESSAGE_SERVERS", new String[]{string}, dRSSettings);
        }
    }
}

