/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level51;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level51.NodeValidationConstants_51;
import java.util.List;

public class NodeValidator_51
extends WebSphereLevelValidator
implements NodeValidationConstants_51 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";

    public NodeValidator_51(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level51.nodevalidation_51_NLS";
    }

    public String getTraceName() {
        return "NodeValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof Node) {
            this.trace("Object recognized as a node; validating");
            this.validateLocal((Node)object);
            this.validateAcross((Node)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(Node node) {
        this.validateProperties(node, node.getName(), (List)node.getProperties(), "ERROR_NODE_PROPERTY_DUPLICATION", "ERROR_NODE_PROPERTY_INVALID");
    }

    public void validateLocal(Node node) {
        String string = node.getName();
        this.traceBegin("validateLocal(Node)", string);
        if (string == null || string.length() == 0) {
            this.addError("ERROR_NODE_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, node);
        } else if (!this.testNodeName(string)) {
            this.addError("ERROR_NODE_NAME_INVALID", new String[]{string, this.getCurrentFileName()}, node);
        }
        this.traceEnd();
    }

    public void validateNodePortDuplication(Node node) {
        this.traceBegin("validateNodePortDuplication(Node)", node.getName());
        this.traceEnd();
    }

    public boolean testNodeName(String string) {
        this.traceStub("Syntax test of node name: ", string);
        return true;
    }
}

