/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level51;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.process.ManagedObject;
import com.ibm.websphere.models.config.topology.cluster.BackupCluster;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.validation.base.config.DuplicationTester;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level51.ClusterValidationConstants_51;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class ClusterValidator_51
extends WebSphereLevelValidator
implements ClusterValidationConstants_51 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    public static final int minWeight = 0;
    public static final int maxWeight = 20;
    ServerCluster _boundCluster = null;

    public ClusterValidator_51(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._boundCluster = null;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._boundCluster = null;
    }

    protected void bindCluster(ServerCluster serverCluster) {
        this._boundCluster = serverCluster;
    }

    protected ServerCluster getBoundCluster() {
        return this._boundCluster;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level51.clustervalidation_51_NLS";
    }

    public String getTraceName() {
        return "ClusterValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof ServerCluster) {
            this.trace("Object recognized as an server cluster; validating");
            this.bindCluster((ServerCluster)object);
            this.validateLocal((ServerCluster)object);
            this.validateAcross((ServerCluster)object);
        } else if (object instanceof BackupCluster) {
            this.trace("Object recognized as a backup cluster container; validating");
            this.validateLocal((BackupCluster)object);
            this.validateAcross((BackupCluster)object);
        } else if (object instanceof ClusterMember) {
            this.trace("Object recognized as a cluster member; validating");
            this.validateLocal((ClusterMember)object);
            this.validateAcross((ClusterMember)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(ServerCluster serverCluster) {
        this.validateServerClusterMemberNames(serverCluster);
        this.validateServerClusterMemberIds(serverCluster);
        this.validateAcross((ManagedObject)serverCluster);
    }

    protected void validateServerClusterMemberNames(ServerCluster serverCluster) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((ClusterMember)eObject).getMemberName().toUpperCase();
            }

            protected String getEmptyMessage() {
                return "ERROR_CLUSTER_MUST_HAVE_A_MEMBER";
            }

            protected String getDuplicateMessage() {
                return "ERROR_CLUSTER_MEMBER_NAME_DUPLICATION";
            }
        };
        duplicationTester.test((List)serverCluster.getMembers(), true, this, serverCluster);
    }

    protected void validateServerClusterMemberIds(ServerCluster serverCluster) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((ClusterMember)eObject).getUniqueId().toUpperCase();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_CLUSTER_MEMBER_UNIQUE_ID_DUPLICATION";
            }
        };
        duplicationTester.test((List)serverCluster.getMembers(), false, this, serverCluster);
    }

    public void validateAcross(BackupCluster backupCluster) {
        if (backupCluster.getDomainBootstrapAddress() == null) {
            this.addError("ERROR_BACKUP_CLUSTER_BOOTSTRAP_ADDRESS_REQUIRED", new String[]{backupCluster.getBackupClusterName()}, backupCluster);
        }
    }

    public void validateAcross(ClusterMember clusterMember) {
        this.traceStub("validateAcross(ClusterMember)");
    }

    public void validateLocal(BackupCluster backupCluster) {
        String string = backupCluster.getBackupClusterName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_BACKUP_CLUSTER_NAME_REQUIRED", new String[]{this.getBoundCluster().getName()}, backupCluster);
        }
    }

    public void validateLocal(ClusterMember clusterMember) {
        String string;
        int n;
        String string2 = clusterMember.getMemberName();
        if (string2 == null || string2.length() == 0) {
            this.addError("ERROR_CLUSTER_MEMBER_NAME_REQUIRED", new String[]{this.getBoundCluster().getName()}, clusterMember);
        }
        if ((n = clusterMember.getWeight()) < 0 || n > 20) {
            this.addWarning("WARNING_CLUSTER_MEMBER_WEIGHT_INVALID", new String[]{String.valueOf(n), String.valueOf(0), String.valueOf(20)}, clusterMember);
        }
        if ((string = clusterMember.getUniqueId()) == null || string.length() == 0) {
            this.addError("ERROR_CLUSTER_MEMBER_UNIQUE_ID_REQUIRED", new String[]{string2}, clusterMember);
        }
    }

    public void validateLocal(ServerCluster serverCluster) {
        String string = serverCluster.getName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_SERVER_CLUSTER_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, serverCluster);
        }
        this.validateLocal((ManagedObject)serverCluster);
    }
}

