/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level502;

import com.ibm.ejs.models.base.resources.ConnectionFactory;
import com.ibm.ejs.models.base.resources.ConnectionPool;
import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.ResourcesPackage;
import com.ibm.ejs.models.base.resources.env.Referenceable;
import com.ibm.ejs.models.base.resources.env.ResourceEnvEntry;
import com.ibm.ejs.models.base.resources.env.ResourceEnvironmentProvider;
import com.ibm.ejs.models.base.resources.j2c.J2CConnectionFactory;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.models.base.resources.jdbc.CMPConnectorFactory;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jdbc.JDBCProvider;
import com.ibm.ejs.models.base.resources.jdbc.WAS40ConnectionPool;
import com.ibm.ejs.models.base.resources.jdbc.WAS40DataSource;
import com.ibm.ejs.models.base.resources.jms.GenericJMSConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.GenericJMSDestination;
import com.ibm.ejs.models.base.resources.jms.JMSConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.JMSDestination;
import com.ibm.ejs.models.base.resources.jms.JMSProvider;
import com.ibm.ejs.models.base.resources.jms.JmsPackage;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.InternalmessagingPackage;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASQueue;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASQueueConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASTopic;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASTopicConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQQueue;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQQueueConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQTopic;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQTopicConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MqseriesPackage;
import com.ibm.ejs.models.base.resources.mail.MailProvider;
import com.ibm.ejs.models.base.resources.mail.MailSession;
import com.ibm.ejs.models.base.resources.mail.ProtocolProvider;
import com.ibm.ejs.models.base.resources.url.URL;
import com.ibm.ejs.models.base.resources.url.URLProvider;
import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.validation.base.config.DuplicationTester;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.base.config.level502.ResourcesValidationConstants_502;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;

public class ResourcesValidator_502
extends WebSphereLevelValidator
implements ResourcesValidationConstants_502 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    protected boolean _pastTopList = false;
    J2EEResourceProvider _boundProvider = null;
    String _boundProviderName = null;
    J2EEResourceFactory _boundFactory = null;
    String _boundFactoryName = null;
    protected static final String DB2_HELPER_NAME = "com.ibm.websphere.rsadapter.DB2UniversalDataStoreHelper";
    public static final String[] builtInProtocols = new String[]{"appletresource", "doc", "file", "ftp", "gopher", "http", "jar", "mailto", "netdoc", "news", "systemresource", "verbatim"};

    public ResourcesValidator_502(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._pastTopList = false;
        this._boundProvider = null;
        this._boundProviderName = null;
        this._boundFactory = null;
        this._boundFactoryName = null;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._pastTopList = false;
        this._boundProvider = null;
        this._boundProviderName = null;
        this._boundFactory = null;
        this._boundFactoryName = null;
    }

    protected void bindProvider(J2EEResourceProvider j2EEResourceProvider) {
        this._boundProvider = j2EEResourceProvider;
        this._boundProviderName = j2EEResourceProvider.getName();
        this.trace("Binding J2EE resource provider: ", this._boundProviderName);
    }

    protected void bindFactory(J2EEResourceFactory j2EEResourceFactory) {
        this._boundFactory = j2EEResourceFactory;
        this._boundFactoryName = j2EEResourceFactory.getName();
        this.trace("Binding J2EE resource factory: ", this._boundFactoryName);
    }

    protected J2EEResourceProvider getBoundProvider() {
        return this._boundProvider;
    }

    protected String getProviderName() {
        return this._boundProviderName;
    }

    protected J2EEResourceFactory getBoundFactory() {
        return this._boundFactory;
    }

    protected String getFactoryName() {
        return this._boundFactoryName;
    }

    protected String[] namesInProvider() {
        return new String[]{this._boundProviderName};
    }

    protected String[] namesInFactory() {
        return new String[]{this._boundProviderName, this._boundFactoryName};
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level502.resourcesvalidation_502_NLS";
    }

    public String getTraceName() {
        return "ResourcesValidator";
    }

    protected void visitList(List list) throws ValidationException {
        boolean bl;
        if (!this._pastTopList) {
            this._pastTopList = true;
            bl = true;
        } else {
            bl = false;
        }
        super.visitList(list);
        if (bl) {
            this.validateProviderDuplication(list);
            this.validateFactoryDuplication(list);
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof J2EEResourceProvider) {
            this.bindProvider((J2EEResourceProvider)object);
        } else if (object instanceof J2EEResourceFactory) {
            this.bindFactory((J2EEResourceFactory)object);
        }
        if (object instanceof CMPConnectorFactory) {
            this.trace("Object recognized as a CMP connector factory; validating");
            this.validateLocal((CMPConnectorFactory)object);
            this.validateAcross((CMPConnectorFactory)object);
        } else if (object instanceof DataSource) {
            this.trace("Object recognized as a data source; validating");
            this.validateLocal((DataSource)object);
            this.validateAcross((DataSource)object);
        } else if (object instanceof JDBCProvider) {
            this.trace("Object recognized as a JDBC provider; validating");
            this.validateLocal((JDBCProvider)object);
            this.validateAcross((JDBCProvider)object);
        } else if (object instanceof WAS40ConnectionPool) {
            this.trace("Object recognized as a WAS40 connection pool; validating");
            this.validateLocal((WAS40ConnectionPool)object);
            this.validateAcross((WAS40ConnectionPool)object);
        } else if (object instanceof WAS40DataSource) {
            this.trace("Object recognized as a WAS40 data source; validating");
            this.validateLocal((WAS40DataSource)object);
            this.validateAcross((WAS40DataSource)object);
        } else if (object instanceof J2CConnectionFactory) {
            this.trace("Object recognized as a J2C connection factory; validating");
            this.validateLocal((J2CConnectionFactory)object);
            this.validateAcross((J2CConnectionFactory)object);
        } else if (object instanceof J2CResourceAdapter) {
            this.trace("Object recognized as a J2C resource adapter; validating");
            this.validateLocal((J2CResourceAdapter)object);
            this.validateAcross((J2CResourceAdapter)object);
        } else if (object instanceof MQQueue) {
            this.trace("Object recognized as an MQ queue; validating");
            this.validateLocal((MQQueue)object);
            this.validateAcross((MQQueue)object);
        } else if (object instanceof MQQueueConnectionFactory) {
            this.trace("Object recognized as an MQ queue connection factory; validating");
            this.validateLocal((MQQueueConnectionFactory)object);
            this.validateAcross((MQQueueConnectionFactory)object);
        } else if (object instanceof MQTopic) {
            this.trace("Object recognized as an MQ topic; validating");
            this.validateLocal((MQTopic)object);
            this.validateAcross((MQTopic)object);
        } else if (object instanceof MQTopicConnectionFactory) {
            this.trace("Object recognized as an MQ topic connection factory; validating");
            this.validateLocal((MQTopicConnectionFactory)object);
            this.validateAcross((MQTopicConnectionFactory)object);
        } else if (object instanceof WASQueue) {
            this.trace("Object recognized as a WAS queue; validating");
            this.validateLocal((WASQueue)object);
            this.validateAcross((WASQueue)object);
        } else if (object instanceof WASQueueConnectionFactory) {
            this.trace("Object recognized as a WAS queue connection factory; validating");
            this.validateLocal((WASQueueConnectionFactory)object);
            this.validateAcross((WASQueueConnectionFactory)object);
        } else if (object instanceof WASTopic) {
            this.trace("Object recognized as a WAS topic; validating");
            this.validateLocal((WASTopic)object);
            this.validateAcross((WASTopic)object);
        } else if (object instanceof WASTopicConnectionFactory) {
            this.trace("Object recognized as a WAS topic connection factory; validating");
            this.validateLocal((WASTopicConnectionFactory)object);
            this.validateAcross((WASTopicConnectionFactory)object);
        } else if (object instanceof JMSProvider) {
            this.trace("Object recognized as a JMS provider; validating");
            this.validateLocal((JMSProvider)object);
            this.validateAcross((JMSProvider)object);
        } else if (object instanceof GenericJMSConnectionFactory) {
            this.trace("Object recognized as a generic JMS connection factory; validating");
            this.validateLocal((JMSConnectionFactory)object);
            this.validateAcross((JMSConnectionFactory)object);
        } else if (object instanceof GenericJMSDestination) {
            this.trace("Object recognized as a generic JMS destination; validating");
            this.validateLocal((JMSDestination)object);
            this.validateAcross((JMSDestination)object);
        } else if (object instanceof JMSConnectionFactory) {
            this.trace("Object recognized as a JMS connection factory; validating");
            this.validateLocal((JMSConnectionFactory)object);
            this.validateAcross((JMSConnectionFactory)object);
        } else if (object instanceof JMSDestination) {
            this.trace("Object recognized as a JMS destination; validating");
            this.validateLocal((JMSDestination)object);
            this.validateAcross((JMSDestination)object);
        } else if (object instanceof MailProvider) {
            this.trace("Object recognized as a mail provider; validating");
            this.validateLocal((MailProvider)object);
            this.validateAcross((MailProvider)object);
        } else if (object instanceof MailSession) {
            this.trace("Object recognized as a mail session; validating");
            this.validateLocal((MailSession)object);
            this.validateAcross((MailSession)object);
        } else if (object instanceof ProtocolProvider) {
            this.trace("Object recognized as a protocol provider; validating");
            this.validateLocal((ProtocolProvider)object);
            this.validateAcross((ProtocolProvider)object);
        } else if (object instanceof Referenceable) {
            this.trace("Object recognized as a referencable; validating");
            this.validateLocal((Referenceable)object);
            this.validateAcross((Referenceable)object);
        } else if (object instanceof ResourceEnvEntry) {
            this.trace("Object recognized as a resource env entry; validating");
            this.validateLocal((ResourceEnvEntry)object);
            this.validateAcross((ResourceEnvEntry)object);
        } else if (object instanceof ResourceEnvironmentProvider) {
            this.trace("Object recognized as a resource environment provider; validating");
            this.validateLocal((ResourceEnvironmentProvider)object);
            this.validateAcross((ResourceEnvironmentProvider)object);
        } else if (object instanceof URLProvider) {
            this.trace("Object recognized as a URL provider; validating");
            this.validateLocal((URLProvider)object);
            this.validateAcross((URLProvider)object);
        } else if (object instanceof URL) {
            this.trace("Object recognized as a URL; validating");
            this.validateLocal((URL)object);
            this.validateAcross((URL)object);
        } else if (object instanceof ConnectionPool) {
            this.trace("Object recognized as a connection pool; validating");
            this.validateLocal((ConnectionPool)object);
            this.validateAcross((ConnectionPool)object);
        } else if (object instanceof ConnectionFactory) {
            this.trace("Object recognized as a connection factory; validating");
            this.validateLocal((ConnectionFactory)object);
            this.validateAcross((ConnectionFactory)object);
        } else if (object instanceof J2EEResourceProvider) {
            this.trace("Object recognized as a J2EE resource provider; validating");
            this.validateLocal((J2EEResourceProvider)object);
            this.validateAcross((J2EEResourceProvider)object);
        } else if (object instanceof J2EEResourceFactory) {
            this.trace("Object recognized as a J2EE resource factory; validating");
            this.validateLocal((J2EEResourceFactory)object);
            this.validateAcross((J2EEResourceFactory)object);
        } else if (object instanceof J2EEResourceProperty) {
            this.validateLocal((J2EEResourceProperty)object);
            this.validateAcross((J2EEResourceProperty)object);
        } else if (object instanceof J2EEResourcePropertySet) {
            this.trace("Object recognized as a J2EE resource property set; validating");
            this.validateLocal((J2EEResourcePropertySet)object);
            this.validateAcross((J2EEResourcePropertySet)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(DataSource dataSource) {
        J2EEResourcePropertySet j2EEResourcePropertySet;
        this.traceStub("Perform cross validation of the DataSource.");
        String string = dataSource.getDatasourceHelperClassname();
        if (string != null && string.equals(DB2_HELPER_NAME) && ((j2EEResourcePropertySet = dataSource.getPropertySet()) == null || !this.haveResourceProperty(j2EEResourcePropertySet, "databaseName"))) {
            this.addError("ERROR_DATA_SOURCE_DATABASE_NAME_REQUIRED", this.namesInFactory(), dataSource);
        }
        this.validateAcross((ConnectionFactory)dataSource);
    }

    public void validateAcross(WAS40ConnectionPool wAS40ConnectionPool) {
        this.traceStub("Perform cross validation of the WAS40ConnectionPool.");
    }

    public void validateAcross(WAS40DataSource wAS40DataSource) {
        String string;
        Object object;
        JDBCProvider jDBCProvider = (JDBCProvider)wAS40DataSource.getProvider();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (jDBCProvider != null) {
            object = jDBCProvider.getImplementationClassName();
            if (this.isDB2Driver((String)object)) {
                bl = true;
            } else if (this.isAS400Driver((String)object)) {
                bl2 = true;
            } else if (!this.isDB2StdDriver((String)object)) {
                if (this.isOracleDriver((String)object)) {
                    bl3 = true;
                    bl4 = true;
                    bl5 = true;
                } else if (this.isSybaseDriver((String)object)) {
                    bl = true;
                    bl2 = true;
                    bl6 = true;
                } else if (this.isMerantDriver((String)object)) {
                    bl = true;
                    bl2 = true;
                    bl6 = true;
                    bl4 = true;
                    bl5 = true;
                } else if (this.isInstantDBDriver((String)object)) {
                    bl7 = true;
                }
            }
        }
        object = wAS40DataSource.getPropertySet();
        if (!(!bl || (string = wAS40DataSource.getDatabaseName()) != null && string.length() != 0 || object != null && this.haveResourceProperty((J2EEResourcePropertySet)object, "databaseName"))) {
            this.addError("ERROR_DATA_SOURCE_DATABASE_NAME_REQUIRED", this.namesInFactory(), wAS40DataSource);
        }
        if (bl2 && (object == null || !this.haveResourceProperty((J2EEResourcePropertySet)object, "serverName"))) {
            this.addError("ERROR_DATA_SOURCE_SERVER_NAME_REQUIRED", this.namesInFactory(), wAS40DataSource);
        }
        if (bl3 && (object == null || !this.haveResourceProperty((J2EEResourcePropertySet)object, "URL"))) {
            this.addError("ERROR_DATA_SOURCE_BIG_URL_REQUIRED", this.namesInFactory(), wAS40DataSource);
        }
        if (!(!bl4 || (string = wAS40DataSource.getDefaultUser()) != null && string.length() != 0 || object != null && this.haveResourceProperty((J2EEResourcePropertySet)object, "user"))) {
            this.addError("ERROR_DATA_SOURCE_USER_REQUIRED", this.namesInFactory(), wAS40DataSource);
        }
        if (!(!bl5 || (string = wAS40DataSource.getDefaultPassword()) != null && string.length() != 0 || object != null && this.haveResourceProperty((J2EEResourcePropertySet)object, "password"))) {
            this.addError("ERROR_DATA_SOURCE_PASSWORD_REQUIRED", this.namesInFactory(), wAS40DataSource);
        }
        if (bl6 && (object == null || !this.haveResourceProperty((J2EEResourcePropertySet)object, "portNumber"))) {
            this.addError("ERROR_DATA_SOURCE_PORT_NUMBER_REQUIRED", this.namesInFactory(), wAS40DataSource);
        }
        if (bl7 && (object == null || !this.haveResourceProperty((J2EEResourcePropertySet)object, "url"))) {
            this.addError("ERROR_DATA_SOURCE_SMALL_URL_REQUIRED", this.namesInFactory(), wAS40DataSource);
        }
        this.validateAcross((J2EEResourceFactory)wAS40DataSource);
    }

    public void validateAcross(JDBCProvider jDBCProvider) {
        this.traceStub("validateAcross(JDBCProvider)");
        this.validateAcross((J2EEResourceProvider)jDBCProvider);
    }

    public void validateAcross(J2CConnectionFactory j2CConnectionFactory) {
        this.validateAcross((J2EEResourceFactory)j2CConnectionFactory);
    }

    public void validateAcross(J2CResourceAdapter j2CResourceAdapter) {
        this.traceStub("Validation of J2C resource adapter associated factory types.");
        this.validateAcross((J2EEResourceProvider)j2CResourceAdapter);
    }

    public void validateAcross(MQQueue mQQueue) {
        this.traceStub("Perform cross validation of the MQQueue.");
        this.validateAcross((JMSDestination)mQQueue);
    }

    public void validateAcross(MQQueueConnectionFactory mQQueueConnectionFactory) {
        this.traceStub("Perform cross validation of the MQQueueConnectionFactory.");
        this.validateAcross((JMSConnectionFactory)mQQueueConnectionFactory);
    }

    public void validateAcross(MQTopic mQTopic) {
        this.traceStub("Perform cross validation of the MQTopic.");
        this.validateAcross((JMSDestination)mQTopic);
    }

    public void validateAcross(MQTopicConnectionFactory mQTopicConnectionFactory) {
        this.traceStub("Perform cross validation of the MQTopicConnectionFactory.");
        this.validateAcross((JMSConnectionFactory)mQTopicConnectionFactory);
    }

    public void validateAcross(WASQueue wASQueue) {
        this.traceStub("Perform cross validation of the WASQueue.");
        this.validateAcross((JMSDestination)wASQueue);
    }

    public void validateAcross(WASQueueConnectionFactory wASQueueConnectionFactory) {
        this.validateAcross((JMSConnectionFactory)wASQueueConnectionFactory);
    }

    public void validateAcross(WASTopic wASTopic) {
        this.traceStub("Perform cross validation of the WASTopic.");
        this.validateAcross((JMSDestination)wASTopic);
    }

    public void validateAcross(WASTopicConnectionFactory wASTopicConnectionFactory) {
        this.validateAcross((JMSConnectionFactory)wASTopicConnectionFactory);
    }

    public void validateAcross(JMSProvider jMSProvider) {
        this.traceStub("Validation of JMS provider associated factory types.");
        this.validateAcross((J2EEResourceProvider)jMSProvider);
    }

    public void validateAcross(GenericJMSConnectionFactory genericJMSConnectionFactory) {
        this.traceStub("Perform cross validation of the GenericJMSConnectionFactory.");
        this.validateAcross((JMSConnectionFactory)genericJMSConnectionFactory);
    }

    public void validateAcross(GenericJMSDestination genericJMSDestination) {
        this.traceStub("Perform cross validation of the GenericJMSDestination.");
        this.validateAcross((JMSDestination)genericJMSDestination);
    }

    public void validateAcross(JMSConnectionFactory jMSConnectionFactory) {
        this.validateAcross((J2EEResourceFactory)jMSConnectionFactory);
    }

    public void validateAcross(JMSDestination jMSDestination) {
        this.validateAcross((J2EEResourceFactory)jMSDestination);
    }

    public void validateAcross(MailProvider mailProvider) {
        EList eList = mailProvider.getFactories();
        if (eList != null) {
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                J2EEResourceFactory j2EEResourceFactory = (J2EEResourceFactory)eList.get(i);
                if (j2EEResourceFactory instanceof MailSession) continue;
                this.addError("ERROR_MAIL_PROVIDER_INVALID_FACTORY_TYPE", new String[]{j2EEResourceFactory.getClass().getName(), this.getProviderName()}, mailProvider);
            }
        }
        this.validateAcross((J2EEResourceProvider)mailProvider);
    }

    private boolean protocolExists(List list, String string, int n) {
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            ProtocolProvider protocolProvider = (ProtocolProvider)list.get(i);
            if (protocolProvider.getType().getValue() != n || !string.equals(protocolProvider.getProtocol())) continue;
            return true;
        }
        return false;
    }

    public void validateAcross(MailSession mailSession) {
        J2EEResourceProvider j2EEResourceProvider = mailSession.getProvider();
        if (j2EEResourceProvider == null) {
            this.addError("ERROR_MAIL_SESSION_PROVIDER_REQUIRED", new String[]{mailSession.getName()}, mailSession);
        } else if (!(j2EEResourceProvider instanceof MailProvider)) {
            this.addError("ERROR_MAIL_SESSION_INVALID_PROVIDER_TYPE", new String[]{j2EEResourceProvider.getClass().getName(), this.getProviderName(), this.getFactoryName()}, mailSession);
        } else {
            Object object;
            MailProvider mailProvider = (MailProvider)j2EEResourceProvider;
            EList eList = mailProvider.getProtocolProviders();
            ProtocolProvider protocolProvider = mailSession.getMailTransportProtocol();
            if (protocolProvider == null) {
                this.addError("ERROR_MAIL_SESSION_TRANSPORT_PROTOCOL_REQUIRED", this.namesInFactory(), mailSession);
            } else {
                object = protocolProvider.getProtocol();
                if (object == null || !this.protocolExists((List)eList, (String)object, 1)) {
                    this.addError("ERROR_MAIL_SESSION_TRANSPORT_PROTOCOL_NOT_EXIST", new String[]{object, this.getProviderName(), this.getFactoryName()}, mailSession);
                }
            }
            object = mailSession.getMailStoreProtocol();
            if (object == null) {
                this.addError("ERROR_MAIL_SESSION_STORE_PROVIDER_REQUIRED", this.namesInFactory(), mailSession);
            } else {
                String string = object.getProtocol();
                if (string == null || !this.protocolExists((List)eList, string, 0)) {
                    this.addError("ERROR_MAIL_SESSION_STORE_PROTOCOL_NOT_EXIST", new String[]{string, this.getProviderName(), this.getFactoryName()}, mailSession);
                }
            }
        }
        this.validateAcross((J2EEResourceFactory)mailSession);
    }

    public void validateAcross(ProtocolProvider protocolProvider) {
        this.traceStub("Perform cross validation of the ProtocolProvider.");
    }

    public void validateAcross(Referenceable referenceable) {
        this.traceStub("Perform cross validation of the Referenceable.");
    }

    public void validateAcross(ResourceEnvEntry resourceEnvEntry) {
        this.traceStub("Perform cross validation of the ResourceEnvEntry.");
        this.validateAcross((J2EEResourceFactory)resourceEnvEntry);
    }

    public void validateAcross(ResourceEnvironmentProvider resourceEnvironmentProvider) {
        this.traceStub("Perform cross validation of the ResourceEnvironmentProvider.");
        this.validateAcross((J2EEResourceProvider)resourceEnvironmentProvider);
    }

    public void validateAcross(URLProvider uRLProvider) {
        this.validateAcross((J2EEResourceProvider)uRLProvider);
    }

    public void validateAcross(URL uRL) {
        this.validateAcross((J2EEResourceFactory)uRL);
    }

    public void validateAcross(ConnectionPool connectionPool) {
        this.traceStub("Perform cross validation of the ConnectionPool.");
    }

    public void validateAcross(ConnectionFactory connectionFactory) {
        this.traceStub("Perform cross validation of the ConnectionFactory.");
        this.validateAcross((J2EEResourceFactory)connectionFactory);
    }

    public void validateAcross(J2EEResourceProvider j2EEResourceProvider) {
        this.trace("validateAcross(J2EEResourceProvider)");
        EList eList = j2EEResourceProvider.getFactories();
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.basicValidate(eList.get(i));
                continue;
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        }
    }

    protected void validateResourceProviderFactoryNames(J2EEResourceProvider j2EEResourceProvider) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                String string = ((J2EEResourceFactory)eObject).getName().toUpperCase();
                return string;
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_DUPLICATE_RESOURCE_FACTORY_NAME";
            }
        };
        duplicationTester.test((List)j2EEResourceProvider.getFactories(), false, this, j2EEResourceProvider);
    }

    protected void validateResourceProviderFactoryJNDINames(J2EEResourceProvider j2EEResourceProvider) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                String string = ((J2EEResourceFactory)eObject).getJndiName();
                return string;
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_DUPLICATE_RESOURCE_FACTORY_JNDI_NAME";
            }
        };
        duplicationTester.test((List)j2EEResourceProvider.getFactories(), false, this, j2EEResourceProvider);
    }

    protected void validateProviderDuplication(List list) {
        this.trace("Performing provider duplication tests: " + list.size());
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                String string = ((J2EEResourceProvider)eObject).getName().toUpperCase();
                return string;
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_DUPLICATE_RESOURCE_PROVIDER_NAME";
            }
        };
        duplicationTester.test(list, false, this, this.getCurrentFileName());
    }

    protected void validateFactoryDuplication(List list) {
        this.trace("Performing factory duplication tests: " + list.size());
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof J2EEResourceProvider)) continue;
            J2EEResourceProvider j2EEResourceProvider = (J2EEResourceProvider)e;
            EList eList = j2EEResourceProvider.getFactories();
            arrayList.addAll(eList);
            this.trace("Adding factories: " + eList.size());
        }
        this.validateFactoryNames(arrayList);
        this.validateFactoryJNDINames(arrayList);
    }

    protected void validateFactoryNames(List list) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                String string = ((J2EEResourceFactory)eObject).getName().toUpperCase();
                return string;
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_DUPLICATE_RESOURCE_FACTORY_NAME";
            }
        };
        duplicationTester.test(list, false, this, this.getCurrentFileName());
    }

    protected void validateFactoryJNDINames(List list) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                String string = ((J2EEResourceFactory)eObject).getJndiName();
                return string;
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_DUPLICATE_RESOURCE_FACTORY_JNDI_NAME";
            }
        };
        duplicationTester.test(list, false, this, this.getCurrentFileName());
    }

    public void validateAcross(J2EEResourceFactory j2EEResourceFactory) {
        J2EEResourceProvider j2EEResourceProvider = j2EEResourceFactory.getProvider();
        if (j2EEResourceProvider == null) {
            this.addError("ERROR_J2EE_RESOURCE_FACTORY_J2EE_RESOURCE_PROVIDER_ABSENT", new String[]{j2EEResourceFactory.getName()}, j2EEResourceFactory);
        }
    }

    public void validateAcross(J2EEResourceProperty j2EEResourceProperty) {
    }

    public void validateAcross(J2EEResourcePropertySet j2EEResourcePropertySet) {
        this.validatePropertySetProperties(j2EEResourcePropertySet);
    }

    public void validatePropertySetProperties(J2EEResourcePropertySet j2EEResourcePropertySet) {
        DuplicationTester duplicationTester = new DuplicationTester(){

            protected String getTagFrom(EObject eObject) {
                return ((J2EEResourceProperty)eObject).getName();
            }

            protected String getEmptyMessage() {
                return null;
            }

            protected String getDuplicateMessage() {
                return "ERROR_DUPLICATED_RESOURCE_PROPERTY";
            }
        };
        duplicationTester.test((List)j2EEResourcePropertySet.getResourceProperties(), false, this, j2EEResourcePropertySet);
    }

    public void validateAcross(CMPConnectorFactory cMPConnectorFactory) {
        this.traceStub("Perform cross validation of the CMPConnectorFactory.");
        this.validateAcross((J2CConnectionFactory)cMPConnectorFactory);
    }

    public void validateLocal(DataSource dataSource) {
        this.traceStub("Validation of local DataSource values.");
        if (dataSource.getStatementCacheSize() < 0) {
            this.addError("ERROR_DATA_SOURCE_CACHE_SIZE_INVALID", new String[]{String.valueOf(dataSource.getStatementCacheSize()), dataSource.getName()}, dataSource);
        }
        this.validateLocal((ConnectionFactory)dataSource);
    }

    public void validateLocal(WAS40ConnectionPool wAS40ConnectionPool) {
        this.traceStub("Validation of local WAS40ConnectionPool values.");
    }

    public void validateLocal(WAS40DataSource wAS40DataSource) {
        String string = wAS40DataSource.getDatabaseName();
        this.traceBegin("validateLocal(WAS40DataSource)", string);
        WAS40ConnectionPool wAS40ConnectionPool = wAS40DataSource.getConnectionPool();
        if (wAS40ConnectionPool != null) {
            int n = wAS40ConnectionPool.getMinimumPoolSize();
            this.testIntegerMin(n, 0, "ERROR_DATA_SOURCE_MINIMUM_POOL_SIZE_CONFLICT", wAS40DataSource);
            int n2 = wAS40ConnectionPool.getMaximumPoolSize();
            this.testIntegerMin(n2, 2, "ERROR_DATA_SOURCE_MAXIMUM_POOL_SIZE_CONFLICT", wAS40DataSource);
            if (n2 < n) {
                this.addError("ERROR_DATA_SOURCE_MAXIMUM_POOL_SIZE_TOO_LOW", new String[]{String.valueOf(n), String.valueOf(n2), this.getProviderName(), this.getFactoryName()}, wAS40DataSource);
            }
            int n3 = wAS40ConnectionPool.getConnectionTimeout();
            this.testIntegerMin(n3, 1, "ERROR_DATA_SOURCE_CONNECTION_TIMEOUT_CONFLICT", wAS40DataSource);
            int n4 = wAS40ConnectionPool.getIdleTimeout();
            this.testIntegerMin(n4, 1, "ERROR_DATA_SOURCE_IDLE_TIMEOUT_CONFLICT", wAS40DataSource);
            int n5 = wAS40ConnectionPool.getOrphanTimeout();
            this.testIntegerMin(n5, 1, "ERROR_DATA_SOURCE_ORPHAN_TIMEOUT_CONFLICT", wAS40DataSource);
            int n6 = wAS40ConnectionPool.getStatementCacheSize();
            this.testIntegerMin(n6, 0, "ERROR_DATA_SOURCE_STATEMENT_CACHE_SIZE_CONFLICT", wAS40DataSource);
        }
        this.validateLocal((J2EEResourceFactory)wAS40DataSource);
        this.traceEnd();
    }

    public void validateLocal(JDBCProvider jDBCProvider) {
        this.traceStub("validateLocal(JDBCProvider)");
        if (jDBCProvider.getImplementationClassName() == null) {
            this.addError("ERROR_J2EE_RESOURCE_PROVIDER_IMPLEMENTATION_CLASS_NAME_REQUIRED", null, jDBCProvider);
        }
        this.validateLocal((J2EEResourceProvider)jDBCProvider);
    }

    public void validateLocal(J2CConnectionFactory j2CConnectionFactory) {
        this.traceBegin("validateLocal(J2CConnectionFactory)");
        this.traceStub("Validation of local J2C connection factory values.");
        this.validateLocal((J2EEResourceFactory)j2CConnectionFactory);
        this.traceEnd();
    }

    public void validateLocal(J2CResourceAdapter j2CResourceAdapter) {
        String string = j2CResourceAdapter.getName();
        this.traceBegin("validateLocal(J2CResourceAdapter)", string);
        this.validateLocal((J2EEResourceProvider)j2CResourceAdapter);
        this.traceEnd();
    }

    public void validateLocal(MQQueue mQQueue) {
        int n;
        boolean bl;
        int n2;
        int n3;
        this.traceBegin("validateLocal(MQQueue)");
        MqseriesPackage mqseriesPackage = MqseriesPackage.eINSTANCE;
        int n4 = mQQueue.getPersistence().getValue();
        EEnum eEnum = mqseriesPackage.getMQMessagingPersistenceType();
        if (!this.isEnumValueValid(n4, eEnum)) {
            this.addError("ERROR_MQQUEUE_PERSISTENCE_INVALID", new String[]{String.valueOf(n4), this.getProviderName(), this.getFactoryName()}, mQQueue);
        }
        if (this.isEnumValueValid(n3 = mQQueue.getPriority().getValue(), eEnum = mqseriesPackage.getMQMessagingPriorityType())) {
            if (n3 == -3) {
                n2 = mQQueue.getSpecifiedPriority();
                this.testInteger(n2, 0, 10, "ERROR_MQQUEUE_SPECIFIED_PRIORITY_INVALID", mQQueue);
            }
        } else {
            this.addError("ERROR_MQQUEUE_PRIORITY_INVALID", new String[]{String.valueOf(n3), this.getProviderName(), this.getFactoryName()}, mQQueue);
        }
        if (!this.isEnumValueValid(n2 = mQQueue.getExpiry().getValue(), eEnum = mqseriesPackage.getMQMessagingExpiryType())) {
            this.addError("ERROR_MQQUEUE_EXPIRY_INVALID", new String[]{String.valueOf(n2), this.getProviderName(), this.getFactoryName()}, mQQueue);
        }
        if (mQQueue.getBaseQueueName() == null) {
            this.addError("ERROR_MQQUEUE_BASE_QUEUE_NAME_REQUIRED", this.namesInFactory(), mQQueue);
        }
        if (!(bl = mQQueue.isUseNativeEncoding())) {
            int n5;
            int n6;
            n = mQQueue.getIntegerEncoding().getValue();
            if (!this.isEnumValueValid(n, eEnum = mqseriesPackage.getMQIntegerEncoding())) {
                this.addError("ERROR_MQQUEUE_INTEGER_ENCODING_INVALID", new String[]{String.valueOf(n), this.getProviderName(), this.getFactoryName()}, mQQueue);
            }
            if (!this.isEnumValueValid(n6 = mQQueue.getDecimalEncoding().getValue(), eEnum = mqseriesPackage.getMQDecimalEncoding())) {
                this.addError("ERROR_MQQUEUE_DECIMAL_ENCODING_INVALID", new String[]{String.valueOf(n6), this.getProviderName(), this.getFactoryName()}, mQQueue);
            }
            if (!this.isEnumValueValid(n5 = mQQueue.getFloatingPointEncoding().getValue(), eEnum = mqseriesPackage.getMQFloatingPointEncoding())) {
                this.addError("ERROR_MQQUEUE_FLOATINGPOINT_ENCODING_INVALID", new String[]{String.valueOf(n5), this.getProviderName(), this.getFactoryName()}, mQQueue);
            }
        }
        if (!this.isEnumValueValid(n = mQQueue.getTargetClient().getValue(), eEnum = mqseriesPackage.getMQTargetClientType())) {
            this.addError("ERROR_MQQUEUE_TARGET_CLIENT_INVALID", new String[]{String.valueOf(n), this.getProviderName(), this.getFactoryName()}, mQQueue);
        }
        this.validateLocal((JMSDestination)mQQueue);
        this.traceEnd();
    }

    public void validateLocal(MQQueueConnectionFactory mQQueueConnectionFactory) {
        this.traceBegin("validateLocal(MQQueueConnectionFactory)");
        int n = mQQueueConnectionFactory.getTransportType().getValue();
        MqseriesPackage mqseriesPackage = MqseriesPackage.eINSTANCE;
        EEnum eEnum = mqseriesPackage.getMQTransportType();
        if (this.isEnumValueValid(n, eEnum)) {
            if (n == 2) {
                this.addError("ERROR_MQQUEUE_CONNECTION_FACTORY_TRANSPORT_TYPE_INVALID", new String[]{String.valueOf(n), this.getProviderName(), this.getFactoryName()}, mQQueueConnectionFactory);
            } else if (n == 1) {
                String string = mQQueueConnectionFactory.getHost();
                if (string == null || string.length() == 0) {
                    this.addError("ERROR_MQQUEUE_CONNECTION_FACTORY_HOST_REQUIRED", this.namesInFactory(), mQQueueConnectionFactory);
                }
                int n2 = mQQueueConnectionFactory.getPort();
                this.testPort(n2, false, "ERROR_MQQUEUE_CONNECTION_FACTORY_PORT_MUST_BE_PORT", mQQueueConnectionFactory);
            }
        } else {
            this.addError("ERROR_MQQUEUE_CONNECTION_FACTORY_TRANSPORT_TYPE_INVALID", new String[]{String.valueOf(n), this.getProviderName(), this.getFactoryName()}, mQQueueConnectionFactory);
        }
        this.validateLocal((JMSConnectionFactory)mQQueueConnectionFactory);
        this.traceEnd();
    }

    public void validateLocal(MQTopic mQTopic) {
        int n;
        boolean bl;
        int n2;
        int n3;
        this.traceBegin("validateLocal(MQTopic)");
        MqseriesPackage mqseriesPackage = MqseriesPackage.eINSTANCE;
        int n4 = mQTopic.getPersistence().getValue();
        EEnum eEnum = mqseriesPackage.getMQMessagingPersistenceType();
        if (!this.isEnumValueValid(n4, eEnum)) {
            this.addError("ERROR_MQTOPIC_PERSISTENCE_INVALID", new String[]{String.valueOf(n4), this.getProviderName(), this.getFactoryName()}, mQTopic);
        }
        if (this.isEnumValueValid(n3 = mQTopic.getPriority().getValue(), eEnum = mqseriesPackage.getMQMessagingPriorityType())) {
            if (n3 == -3) {
                n2 = mQTopic.getSpecifiedPriority();
                this.testInteger(n2, 0, 10, "ERROR_MQTOPIC_SPECIFIED_PRIORITY_OUT_OF_RANGE", mQTopic);
            }
        } else {
            this.addError("ERROR_MQTOPIC_PRIORITY_INVALID", new String[]{String.valueOf(n3), this.getProviderName(), this.getFactoryName()}, mQTopic);
        }
        if (this.isEnumValueValid(n2 = mQTopic.getExpiry().getValue(), eEnum = mqseriesPackage.getMQMessagingExpiryType())) {
            long l = mQTopic.getSpecifiedExpiry();
        } else {
            this.addError("ERROR_MQTOPIC_EXPIRY_INVALID", new String[]{String.valueOf(n2), this.getProviderName(), this.getFactoryName()}, mQTopic);
        }
        if (mQTopic.getBaseTopicName() == null) {
            this.addError("ERROR_MQTOPIC_BASE_TOPIC_NAME_REQUIRED", this.namesInFactory(), mQTopic);
        }
        if (!(bl = mQTopic.isUseNativeEncoding())) {
            int n5;
            int n6;
            n = mQTopic.getIntegerEncoding().getValue();
            if (!this.isEnumValueValid(n, eEnum = mqseriesPackage.getMQIntegerEncoding())) {
                this.addError("ERROR_MQTOPIC_INTEGER_ENCODING_INVALID", new String[]{String.valueOf(n), this.getProviderName(), this.getFactoryName()}, mQTopic);
            }
            if (!this.isEnumValueValid(n6 = mQTopic.getDecimalEncoding().getValue(), eEnum = mqseriesPackage.getMQDecimalEncoding())) {
                this.addError("ERROR_MQTOPIC_DECIMAL_ENCODING_INVALID", new String[]{String.valueOf(n6), this.getProviderName(), this.getFactoryName()}, mQTopic);
            }
            if (!this.isEnumValueValid(n5 = mQTopic.getFloatingPointEncoding().getValue(), eEnum = mqseriesPackage.getMQFloatingPointEncoding())) {
                this.addError("ERROR_MQTOPIC_FLOATINGPOINT_ENCODING_INVALID", new String[]{String.valueOf(n5), this.getProviderName(), this.getFactoryName()}, mQTopic);
            }
        }
        if (!this.isEnumValueValid(n = mQTopic.getTargetClient().getValue(), eEnum = mqseriesPackage.getMQTargetClientType())) {
            this.addError("ERROR_MQTOPIC_TARGET_CLIENT_INVALID", new String[]{String.valueOf(n), this.getProviderName(), this.getFactoryName()}, mQTopic);
        }
        this.validateLocal((JMSDestination)mQTopic);
        this.traceEnd();
    }

    public void validateLocal(MQTopicConnectionFactory mQTopicConnectionFactory) {
        String string;
        int n;
        EEnum eEnum;
        MqseriesPackage mqseriesPackage = MqseriesPackage.eINSTANCE;
        int n2 = mQTopicConnectionFactory.getTransportType().getValue();
        if (this.isEnumValueValid(n2, eEnum = mqseriesPackage.getMQTransportType())) {
            if (n2 == 2) {
                this.addError("ERROR_MQTOPIC_CONNECTION_FACTORY_TRANSPORT_TYPE_INVALID", new String[]{String.valueOf(n2), this.getProviderName(), this.getFactoryName()}, mQTopicConnectionFactory);
            } else if (n2 == 1) {
                String string2 = mQTopicConnectionFactory.getHost();
                if (string2 == null || string2.length() == 0) {
                    this.addError("ERROR_MQTOPIC_CONNECTION_FACTORY_HOST_REQUIRED", this.namesInFactory(), mQTopicConnectionFactory);
                }
                n = mQTopicConnectionFactory.getPort();
                this.testPort(n, false, "ERROR_MQTOPIC_CONNECTION_FACTORY_PORT_INVALID", mQTopicConnectionFactory);
            }
        } else {
            this.addError("ERROR_MQTOPIC_CONNECTION_FACTORY_TRANSPORT_TYPE_INVALID", new String[]{String.valueOf(n2), this.getProviderName(), this.getFactoryName()}, mQTopicConnectionFactory);
        }
        boolean bl = mQTopicConnectionFactory.isCloneSupport();
        if (bl && ((string = mQTopicConnectionFactory.getClientID()) == null || string.length() == 0)) {
            this.addError("ERROR_MQTOPIC_CONNECTION_FACTORY_CLIENTID_REQUIRED", this.namesInFactory(), mQTopicConnectionFactory);
        }
        if (!this.isEnumValueValid(n = mQTopicConnectionFactory.getBrokerVersion().getValue(), eEnum = mqseriesPackage.getMQBrokerType())) {
            this.addError("ERROR_MQTOPIC_CONNECTION_FACTORY_BROKER_VERSION_INVALID", new String[]{String.valueOf(n), this.getProviderName(), this.getFactoryName()}, mQTopicConnectionFactory);
        }
        this.validateLocal((JMSConnectionFactory)mQTopicConnectionFactory);
    }

    public void validateLocal(WASQueue wASQueue) {
        String string;
        int n;
        EEnum eEnum;
        InternalmessagingPackage internalmessagingPackage = InternalmessagingPackage.eINSTANCE;
        int n2 = wASQueue.getPersistence().getValue();
        if (!this.isEnumValueValid(n2, eEnum = internalmessagingPackage.getMessagingPersistenceType())) {
            this.addError("ERROR_WAS_QUEUE_PERSISTENCE_INVALID", new String[]{String.valueOf(n2), this.getProviderName(), this.getFactoryName()}, wASQueue);
        }
        if (this.isEnumValueValid(n = wASQueue.getPriority().getValue(), eEnum = internalmessagingPackage.getMessagingPriorityType())) {
            if (n == -3) {
                int n3 = wASQueue.getSpecifiedPriority();
                this.testInteger(n3, 0, 9, "ERROR_WAS_QUEUE_SPECIFIED_PRIORITY_INVALID", wASQueue);
                long l = wASQueue.getSpecifiedExpiry();
                String[] stringArray = new String[]{this.getProviderName(), wASQueue.getName()};
                String[] stringArray2 = new String[]{String.valueOf(l), this.getProviderName(), wASQueue.getName()};
                this.testLongMin(new Long(l), 0L, "ERROR_WAS_QUEUE_SPECIFIED_EXPIRY_REQUIRED", stringArray, "ERROR_WAS_QUEUE_SPECIFIED_EXPIRY_INVALID", stringArray2, (Object)wASQueue);
            }
        } else {
            this.addError("ERROR_WAS_QUEUE_PRIORITY_INVALID", new String[]{String.valueOf(n), this.getProviderName(), this.getFactoryName()}, wASQueue);
        }
        if ((string = wASQueue.getName()) != null) {
            String string2;
            if (string.length() > this.MAX_WAS_QUEUE_LENGTH) {
                this.addError("ERROR_WAS_QUEUE_NAME_TOO_LONG", new String[]{string, String.valueOf(string.length()), String.valueOf(this.MAX_WAS_QUEUE_LENGTH)}, wASQueue);
            }
            if (!this.testValidChars(string, string2 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.%_/")) {
                this.addError("ERROR_WAS_QUEUE_NAME_INVALID", new String[]{string, string2}, wASQueue);
            }
        }
        this.validateLocal((JMSDestination)wASQueue);
    }

    public void validateLocal(WASQueueConnectionFactory wASQueueConnectionFactory) {
        String string = wASQueueConnectionFactory.getNode();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_WAS_QUEUE_CONNECTION_FACTORY_NODE_REQUIRED", this.namesInFactory(), wASQueueConnectionFactory);
        }
        this.validateLocal((JMSConnectionFactory)wASQueueConnectionFactory);
    }

    public void validateLocal(WASTopic wASTopic) {
        EEnum eEnum;
        int n;
        InternalmessagingPackage internalmessagingPackage = InternalmessagingPackage.eINSTANCE;
        String string = wASTopic.getTopic();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_WAS_TOPIC_TOPIC_REQUIRED", this.namesInFactory(), wASTopic);
        }
        if (!this.isEnumValueValid(n = wASTopic.getPersistence().getValue(), eEnum = internalmessagingPackage.getMessagingPersistenceType())) {
            this.addError("ERROR_WAS_TOPIC_PERSISTENCE_INVALID", new String[]{String.valueOf(n), this.getProviderName(), this.getFactoryName()}, wASTopic);
        }
        int n2 = wASTopic.getPriority().getValue();
        eEnum = internalmessagingPackage.getMessagingPersistenceType();
        if (this.isEnumValueValid(n, eEnum)) {
            if (n2 == -3) {
                int n3 = wASTopic.getSpecifiedPriority();
                this.testInteger(n3, 0, 9, "ERROR_WAS_TOPIC_SPECIFIED_PRIORITY_INVALID", wASTopic);
                long l = wASTopic.getSpecifiedExpiry();
                String[] stringArray = new String[]{this.getProviderName(), wASTopic.getName()};
                String[] stringArray2 = new String[]{String.valueOf(l), this.getProviderName(), wASTopic.getName()};
                this.testLongMin(new Long(l), 0L, "ERROR_WAS_TOPIC_SPECIFIED_EXPIRY_REQUIRED", stringArray, "ERROR_WAS_TOPIC_SPECIFIED_EXPIRY_INVALID", stringArray2, (Object)wASTopic);
            }
        } else {
            this.addError("ERROR_WAS_TOPIC_PRIORITY_INVALID", new String[]{String.valueOf(n2), this.getProviderName(), this.getFactoryName()}, wASTopic);
        }
        this.validateLocal((JMSDestination)wASTopic);
    }

    public void validateLocal(WASTopicConnectionFactory wASTopicConnectionFactory) {
        String string;
        boolean bl;
        EEnum eEnum;
        int n;
        InternalmessagingPackage internalmessagingPackage = InternalmessagingPackage.eINSTANCE;
        String string2 = wASTopicConnectionFactory.getNode();
        if (string2 == null || string2.length() == 0) {
            this.addError("ERROR_WAS_TOPIC_CONNECTION_FACTORY_NODE_REQUIRED", this.namesInFactory(), wASTopicConnectionFactory);
        }
        if (!this.isEnumValueValid(n = wASTopicConnectionFactory.getPort().getValue(), eEnum = internalmessagingPackage.getWASJMSPortType())) {
            this.addError("ERROR_WAS_TOPIC_CONNECTION_FACTORY_PORT_INVALID", new String[]{String.valueOf(n), this.getProviderName(), this.getFactoryName()}, wASTopicConnectionFactory);
        }
        if ((bl = wASTopicConnectionFactory.isCloneSupport()) && ((string = wASTopicConnectionFactory.getClientID()) == null || string.length() == 0)) {
            this.addError("ERROR_WAS_TOPIC_CONNECTION_FACTORY_CLIENT_ID_REQUIRED", this.namesInFactory(), wASTopicConnectionFactory);
        }
        this.validateLocal((JMSConnectionFactory)wASTopicConnectionFactory);
    }

    public void validateLocal(JMSProvider jMSProvider) {
        this.traceStub("validateLocal(JMSProvider)");
        this.validateLocal((J2EEResourceProvider)jMSProvider);
    }

    public void validateLocal(GenericJMSConnectionFactory genericJMSConnectionFactory) {
        this.traceStub("Validation of local GenericJMSConnectionFactory values.");
        int n = genericJMSConnectionFactory.getType().getValue();
        JmsPackage jmsPackage = JmsPackage.eINSTANCE;
        EEnum eEnum = jmsPackage.getJMSResourceType();
        if (!this.isEnumValueValid(n, eEnum)) {
            this.addError("ERROR_GENERIC_JMS_CONNECTION_FACTORY_TYPE_INVALID", new String[]{String.valueOf(n), this.getProviderName(), genericJMSConnectionFactory.getName()}, genericJMSConnectionFactory);
        }
        this.validateLocal((JMSConnectionFactory)genericJMSConnectionFactory);
    }

    public void validateLocal(GenericJMSDestination genericJMSDestination) {
        this.traceStub("Validation of local GenericJMSDestination values.");
        int n = genericJMSDestination.getType().getValue();
        JmsPackage jmsPackage = JmsPackage.eINSTANCE;
        EEnum eEnum = jmsPackage.getJMSResourceType();
        if (!this.isEnumValueValid(n, eEnum)) {
            this.addError("ERROR_GENERIC_JMS_DESTINATION_TYPE_INVALID", new String[]{String.valueOf(n), this.getProviderName(), genericJMSDestination.getName()}, genericJMSDestination);
        }
        this.validateLocal((JMSDestination)genericJMSDestination);
    }

    public void validateLocal(JMSConnectionFactory jMSConnectionFactory) {
        String string = jMSConnectionFactory.getName();
        this.traceBegin("validateLocal(JMSConnectionFactory)", string);
        this.validateLocal((J2EEResourceFactory)jMSConnectionFactory);
        this.traceEnd();
    }

    public void validateLocal(JMSDestination jMSDestination) {
        this.traceBegin("validateLocal(JMSDestination)");
        this.validateLocal((J2EEResourceFactory)jMSDestination);
        this.traceEnd();
    }

    public void validateLocal(MailProvider mailProvider) {
        this.traceBegin("validateLocal(MailProvider)");
        this.validateLocal((J2EEResourceProvider)mailProvider);
        this.traceEnd();
    }

    public void validateLocal(MailSession mailSession) {
        this.traceBegin("validateLocal(MailSession)");
        this.validateLocal((J2EEResourceFactory)mailSession);
        this.traceEnd();
    }

    public void validateLocal(ProtocolProvider protocolProvider) {
        this.traceStub("Validation of local ProtocolProvider values.");
    }

    public void validateLocal(Referenceable referenceable) {
        this.traceStub("Validation of local Referenceable values.");
    }

    public void validateLocal(ResourceEnvEntry resourceEnvEntry) {
        this.traceStub("Validation of local ResourceEnvEntry values.");
        this.validateLocal((J2EEResourceFactory)resourceEnvEntry);
    }

    public void validateLocal(ResourceEnvironmentProvider resourceEnvironmentProvider) {
        this.traceStub("Validation of local ResourceEnvironmentProvider values.");
        this.validateLocal((J2EEResourceProvider)resourceEnvironmentProvider);
    }

    public void validateLocal(URL uRL) {
        String string = uRL.getSpec();
        this.traceBegin("validateLocal(URL)", string);
        if (string == null || string.length() == 0) {
            this.addError("ERROR_URL_SPEC_REQUIRED", this.namesInFactory(), uRL);
        }
        this.validateLocal((J2EEResourceFactory)uRL);
        this.traceEnd();
    }

    public void validateLocal(URLProvider uRLProvider) {
        this.traceBegin("validateLocal(URLProvider)");
        String string = uRLProvider.getStreamHandlerClassName();
        if (string == null || string.length() == 0) {
            this.addError("ERROR_URL_PROVIDER_STREAM_HANDLER_CLASS_NAME_REQUIRED", this.namesInProvider(), uRLProvider);
        } else if (!this.testJavaClass(string)) {
            this.addError("ERROR_URL_PROVIDER_STREAM_HANDLER_CLASS_NAME_INVALID", new String[]{string, this.getProviderName()}, uRLProvider);
        }
        String string2 = uRLProvider.getProtocol();
        if (string2 == null || string2.length() == 0) {
            this.addError("ERROR_URL_PROVIDER_PROTOCOL_REQUIRED", this.namesInProvider(), uRLProvider);
        }
        this.validateLocal((J2EEResourceProvider)uRLProvider);
        this.traceEnd();
    }

    public void validateLocal(ConnectionPool connectionPool) {
        long l;
        long l2;
        long l3;
        long l4;
        int n;
        this.traceStub("Validation of local ConnectionPool values.");
        int n2 = connectionPool.getMaxConnections();
        if (n2 < 0) {
            this.addError("ERROR_CONNECTIONPOOL_MAX_CONNECTIONS_INVALID", new String[]{String.valueOf(n2)}, connectionPool);
        }
        if ((n = connectionPool.getMinConnections()) < 0 || n > n2) {
            this.addError("ERROR_CONNECTIONPOOL_MIN_CONNECTIONS_INVALID", new String[]{String.valueOf(n)}, connectionPool);
        }
        if ((l4 = connectionPool.getConnectionTimeout()) < 0L) {
            this.addError("ERROR_CONNECTIONPOOL_TIMEOUT_INVALID", new String[]{String.valueOf(l4)}, connectionPool);
        }
        if ((l3 = connectionPool.getReapTime()) < 0L) {
            this.addError("ERROR_CONNECTIONPOOL_REAPTIME_INVALID", new String[]{String.valueOf(l3)}, connectionPool);
        }
        if ((l2 = connectionPool.getUnusedTimeout()) < 0L) {
            this.addError("ERROR_CONNECTIONPOOL_UNUSED_TIMEOUT_INVALID", new String[]{String.valueOf(l2)}, connectionPool);
        }
        if ((l = connectionPool.getAgedTimeout()) < 0L) {
            this.addError("ERROR_CONNECTIONPOOL_AGED_TIMEOUT_INVALID", new String[]{String.valueOf(l)}, connectionPool);
        }
        ResourcesPackage resourcesPackage = ResourcesPackage.eINSTANCE;
        EEnum eEnum = resourcesPackage.getPurgePolicyKind();
        if (!this.isEnumValueValid(connectionPool.getPurgePolicy().getValue(), eEnum)) {
            this.addError("ERROR_CONNECTIONPOOL_PURGEPOLICY_INVALID", connectionPool);
        }
    }

    public void validateLocal(ConnectionFactory connectionFactory) {
        this.traceStub("Validation of local ConnectionFactory values.");
        this.validateLocal((J2EEResourceFactory)connectionFactory);
    }

    public void validateLocal(J2EEResourceProvider j2EEResourceProvider) {
        String string = j2EEResourceProvider.getName();
        this.traceBegin("validateLocal(J2EEResourceProvider)", string);
        if (string == null || string.length() == 0) {
            this.addError("ERROR_J2EE_RESOURCE_PROVIDER_NAME_REQUIRED", new String[]{this.getCurrentFileName()}, j2EEResourceProvider);
        }
        this.traceEnd();
    }

    public void validateLocal(J2EEResourceFactory j2EEResourceFactory) {
        String string;
        String string2 = j2EEResourceFactory.getName();
        this.traceBegin("validateLocal(J2EEResourceFactory)", string2);
        if (string2 == null || string2.length() == 0) {
            this.addError("ERROR_J2EE_RESOURCE_FACTORY_NAME_REQUIRED", this.namesInProvider(), j2EEResourceFactory);
        }
        if ((string = j2EEResourceFactory.getJndiName()) == null || string.length() == 0) {
            this.addError("ERROR_J2EE_RESOURCE_FACTORY_JNDI_NAME_REQUIRED", new String[]{string, this.getProviderName(), this.getFactoryName()}, j2EEResourceFactory);
        }
        this.traceEnd();
    }

    public void validateLocal(J2EEResourceProperty j2EEResourceProperty) {
        String string;
        String string2;
        String string3 = j2EEResourceProperty.getName();
        this.traceBegin("validateLocal(J2EEResourceProperty)", string3);
        if (string3 == null || string3.length() == 0) {
            if (this.getBoundFactory() == null) {
                this.addError("ERROR_PROVIDER_J2EE_RESOURCE_PROPERTY_NAME_REQUIRED", this.namesInProvider(), j2EEResourceProperty);
            } else {
                this.addError("ERROR_FACTORY_J2EE_RESOURCE_PROPERTY_NAME_REQUIRED", this.namesInFactory(), j2EEResourceProperty);
            }
        }
        if ((string2 = j2EEResourceProperty.getType()) == null || string2.length() == 0) {
            if (this.getBoundFactory() == null) {
                this.addError("ERROR_PROVIDER_J2EE_RESOURCE_PROPERTY_TYPE_REQUIRED", this.namesInProvider(), j2EEResourceProperty);
            } else {
                this.addError("ERROR_FACTORY_J2EE_RESOURCE_PROPERTY_TYPE_REQUIRED", this.namesInFactory(), j2EEResourceProperty);
            }
        }
        if ((string = j2EEResourceProperty.getValue()) == null || string.length() == 0) {
            boolean bl = j2EEResourceProperty.isRequired();
            if (bl) {
                if (this.getBoundFactory() == null) {
                    this.addError("ERROR_PROVIDER_J2EE_RESOURCE_PROPERTY_VALUE_REQUIRED", this.namesInProvider(), j2EEResourceProperty);
                } else {
                    this.addError("ERROR_FACTORY_J2EE_RESOURCE_PROPERTY_VALUE_REQUIRED", this.namesInFactory(), j2EEResourceProperty);
                }
            }
        } else if (string != null && string2 != null && !this.isValueValidByType(string, string2)) {
            if (this.getBoundFactory() == null) {
                this.addError("ERROR_PROVIDER_J2EE_RESOURCE_PROPERTY_VALUE_TYPE_MISMATCHED", new String[]{string, string2, this._boundProviderName}, j2EEResourceProperty);
            } else {
                this.addError("ERROR_FACTORY_J2EE_RESOURCE_PROPERTY_VALUE_TYPE_MISMATCHED", new String[]{string, string2, this._boundFactoryName}, j2EEResourceProperty);
            }
        }
        this.traceEnd();
    }

    public void validateLocal(J2EEResourcePropertySet j2EEResourcePropertySet) {
        this.traceBegin("validateLocal(J2EEResourcePropertySet)");
        this.traceEnd();
    }

    protected String integer2String(Integer n) {
        if (n == null) {
            return "Null";
        }
        return n.toString();
    }

    protected String long2String(Long l) {
        if (l == null) {
            return "Null";
        }
        return l.toString();
    }

    public String[] getBuiltInProtocols() {
        return builtInProtocols;
    }

    public boolean haveResourceProperty(J2EEResourcePropertySet j2EEResourcePropertySet, String string) {
        Object object;
        int n;
        EList eList = j2EEResourcePropertySet.getResourceProperties();
        if (eList == null) {
            return false;
        }
        Object object2 = null;
        int n2 = eList.size();
        for (n = 0; n < n2; ++n) {
            object = (J2EEResourceProperty)eList.get(n);
            String string2 = object.getName();
            if (string2 == null || !string2.equals(string)) continue;
            object2 = object;
            break;
        }
        n = object2 != null ? ((object = object2.getValue()) != null && ((String)object).length() != 0 ? 1 : 0) : 0;
        return n != 0;
    }

    public boolean isAS400Driver(String string) {
        return string != null && (string.equals("com.ibm.as400.access.AS400JDBCConnectionPoolDataSource") || string.equals("com.ibm.as400.access.AS400JDBCXADataSource"));
    }

    public boolean isDB2Driver(String string) {
        return string != null && (string.equals("com.ibm.db2.jdbc.DB2ConnectionPoolDataSource") || string.equals("com.ibm.db2.jdbc.DB2XADataSource"));
    }

    public boolean isDB2StdDriver(String string) {
        return string != null && (string.equals("com.ibm.db2.jdbc.app.DB2StdConnectionPoolDataSource") || string.equals("com.ibm.db2.jdbc.app.DB2StdXADataSource"));
    }

    public boolean isInstantDBDriver(String string) {
        return string != null && string.equals("com.ibm.ejs.cm.portability.IDBConnectionPoolDataSource");
    }

    public boolean isMerantDriver(String string) {
        return string != null && string.equals("com.merant.sequelink.jdbcx.datasource.SequeLinkDataSource");
    }

    public boolean isOracleDriver(String string) {
        return string != null && (string.equals("oracle.jdbc.pool.OracleConnectionPoolDataSource") || string.equals("oracle.jdbc.xa.OracleXADataSource"));
    }

    public boolean isSybaseDriver(String string) {
        return string != null && (string.equals("com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource") || string.equals("com.sybase.jdbc2.jdbc.SybXADataSource"));
    }

    protected boolean testJ2CAuthMechanismType(int n) {
        return n == 0 || n == 1;
    }

    protected boolean testJ2CTransactionSupportLevel(int n) {
        return n == 0 || n == 1 || n == 2;
    }

    protected boolean testJMSDomainType(int n) {
        this.traceStub("Validation of JMS domain type: ", new Integer(n));
        return true;
    }
}

