/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config.level502;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.j2c.J2CConnectionFactory;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jms.JMSConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.JMSDestination;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASQueue;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASQueueConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASTopicConnectionFactory;
import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.validation.base.config.WebSphereLevelCrossValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.base.config.level502.ResourcesValidationConstants_502;
import java.util.HashSet;
import java.util.List;

public class ResourcesCrossValidator_502
extends WebSphereLevelCrossValidator
implements ResourcesValidationConstants_502 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    protected J2EEResourceProvider _boundProvider = null;

    public ResourcesCrossValidator_502(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this._boundProvider = null;
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this._boundProvider = null;
    }

    protected void bindProvider(J2EEResourceProvider j2EEResourceProvider) {
        this._boundProvider = j2EEResourceProvider;
    }

    protected J2EEResourceProvider getProvider() {
        return this._boundProvider;
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.base.config.level502.resourcesvalidation_502_NLS";
    }

    public String getTraceName() {
        return "ResourcesCrossValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof WASQueueConnectionFactory) {
            this.trace("Object recognized as an WAS queue connection factory; validating");
            this.validateAcross((WASQueueConnectionFactory)object);
        } else if (object instanceof WASQueue) {
            this.trace("Object recognized as an WAS queue; validating");
            this.validateAcross((WASQueue)object);
        } else if (object instanceof DataSource) {
            this.trace("Object recognized as a DataSource; validating");
            this.validateAcross((DataSource)object);
        } else if (object instanceof J2CConnectionFactory) {
            this.trace("Object recognized as a J2CConnectionFactory; validating");
            this.validateAcross((J2CConnectionFactory)object);
        } else if (object instanceof J2EEResourceFactory) {
            this.trace("Object recognized as a J2EE resource factory; validating");
            this.validateAcross((J2EEResourceFactory)object);
        } else if (object instanceof J2EEResourceProvider) {
            this.trace("Object recognized as a J2EE resource provider; validating");
            this.bindProvider((J2EEResourceProvider)object);
            this.validateAcross((J2EEResourceProvider)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    public void validateAcross(J2EEResourceFactory j2EEResourceFactory) {
    }

    public void validateAcross(J2EEResourceProvider j2EEResourceProvider) throws ValidationException {
        this.visitList((List)j2EEResourceProvider.getFactories());
    }

    public void validateAcross(WASQueueConnectionFactory wASQueueConnectionFactory) {
        this.validateNodeName(wASQueueConnectionFactory, wASQueueConnectionFactory.getNode(), "ERROR_WAS_QUEUE_CONNECTION_FACTORY_NODE_NOT_LOCATED");
        this.validateAcross((JMSConnectionFactory)wASQueueConnectionFactory);
    }

    public void validateAcross(JMSConnectionFactory jMSConnectionFactory) {
        this.traceStub("validateAcross(JMSConnectionFactory)");
        this.validateAcross((J2EEResourceFactory)jMSConnectionFactory);
    }

    public void validateAcross(WASQueue wASQueue) {
        this.validateAcross((JMSDestination)wASQueue);
    }

    public void validateAcross(JMSDestination jMSDestination) {
        this.traceStub("validateAcross(JMSDestination)");
        this.validateAcross((J2EEResourceFactory)jMSDestination);
    }

    public void validateAcross(WASTopicConnectionFactory wASTopicConnectionFactory) {
        this.validateNodeName(wASTopicConnectionFactory, wASTopicConnectionFactory.getNode(), "ERROR_WAS_TOPIC_CONNECTION_FACTORY_NODE_NOT_LOCATED");
        this.validateAcross((JMSConnectionFactory)wASTopicConnectionFactory);
    }

    protected void validateNodeName(J2EEResourceFactory j2EEResourceFactory, String string, String string2) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (!this.getNodeNames().contains(string)) {
            this.addError(string2, new String[]{string, this.getProvider().getName(), j2EEResourceFactory.getName()}, j2EEResourceFactory);
        }
    }

    protected void validateJAASAuthData(J2EEResourceFactory j2EEResourceFactory, String string, String string2) {
        if (string == null || string.length() == 0) {
            return;
        }
        HashSet hashSet = this.getCellSecurityJAASAuthDataTable();
        if (!hashSet.contains(string)) {
            this.addError(string2, new String[]{string, j2EEResourceFactory.getName()}, j2EEResourceFactory);
        }
    }

    public void validateAcross(DataSource dataSource) {
        this.validateJAASAuthData(dataSource, dataSource.getAuthDataAlias(), "ERROR_DATASOURCE_AUTH_DATA_ALIAS_NOT_LOCATED");
        this.validateAcross((J2EEResourceFactory)dataSource);
    }

    public void validateAcross(J2CConnectionFactory j2CConnectionFactory) {
        this.validateJAASAuthData(j2CConnectionFactory, j2CConnectionFactory.getAuthDataAlias(), "ERROR_J2CCONNECTIONFACTORY_AUTH_DATA_ALIAS_NOT_LOCATED");
        this.validateAcross((J2EEResourceFactory)j2CConnectionFactory);
    }
}

