/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.process.ManagedObject;
import com.ibm.websphere.models.config.process.ProcessPackage;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.StateManageable;
import com.ibm.websphere.models.config.process.StatisticsProvider;
import com.ibm.websphere.models.config.process.ThreadPool;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.webserver.WebServer;
import com.ibm.websphere.validation.base.config.FeaturesHelper;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.websphere.validation.base.config.TypeTester;
import com.ibm.websphere.validation.base.config.WebSpherePlatformConstants;
import com.ibm.websphere.validation.base.config.WorkSpaceHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EEnum;

public class WebSpherePlatformValidator
extends MOFValidator
implements WebSpherePlatformConstants {
    public static final String pgmVersion = "%G%";
    public static final String pgmUpdate = "%I%";
    public int MAX_WAS_QUEUE_LENGTH = 45;
    protected WorkSpaceHelper _workSpaceHelper;
    protected FeaturesHelper _featuresHelper;
    protected TypeTester _typeTester = new TypeTester(this);

    public WebSpherePlatformValidator() {
        this._workSpaceHelper = this.createWorkSpaceHelper();
        this._featuresHelper = this.createFeaturesHelper();
        this._featuresHelper.clear();
    }

    protected void clearCachedData() {
        this._workSpaceHelper.clear();
        this._featuresHelper.clear();
    }

    protected void moveToFirstFile() {
        super.moveToFirstFile();
        this.clearCachedData();
    }

    protected void moveToNextFile() {
        super.moveToNextFile();
        this.clearCachedData();
    }

    public void validateFile(String string) throws ValidationException {
        if (!this.isTemplate(string)) {
            super.validateFile(string);
        }
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (!(object instanceof Property)) {
            if (object instanceof EndPoint) {
                this.trace("Object recognized as an end point; validating");
                this.validateLocal((EndPoint)object);
                this.validateAcross((EndPoint)object);
            } else if (object instanceof Transport) {
                this.trace("Object recognized a transport; validating");
                this.validateLocal((Transport)object);
                this.validateAcross((Transport)object);
            } else if (object instanceof ThreadPool) {
                this.trace("Object recognized as a thread pool; validating.");
                this.validateLocal((ThreadPool)object);
                this.validateAcross((ThreadPool)object);
            } else if (object instanceof ManagedObject) {
                this.trace("Object recognized a managed object; validating");
                this.validateLocal((ManagedObject)object);
                this.validateAcross((ManagedObject)object);
            } else if (!(object instanceof StateManageable) && !(object instanceof StatisticsProvider)) {
                bl = super.basicValidate(object);
            }
        }
        return bl;
    }

    public void validateProperties(Object object, String string, List list, String string2, String string3) {
        this.validateProperties(this.getBundleId(), object, string, list, string2, string3);
    }

    public void validateProperties(String string, Object object, String string2, List list, String string3, String string4) {
        Iterator iterator = list.iterator();
        Hashtable<String, Property> hashtable = new Hashtable<String, Property>();
        Hashtable<String, Property> hashtable2 = new Hashtable<String, Property>();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            String string5 = property.getName();
            if (string5 == null || hashtable.put(string5, property) == null || hashtable2.put(string5, property) != null) continue;
            String[] stringArray = string2 == null ? new String[]{string5} : new String[]{string5, string2};
            this.addError(string, string3, stringArray, object);
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            this.basicValidate(string, (Property)iterator.next(), object, string2, string4);
        }
    }

    protected void basicValidate(String string, Property property, Object object, String string2, String string3) {
        String string4 = property.getName();
        if (string4 == null || string4.length() == 0) {
            if (string2 == null) {
                this.addError(string, string3, new String[0], object);
            } else {
                this.addError(string, string3, new String[]{string2}, object);
            }
        }
    }

    public void validateAcross(EndPoint endPoint) {
    }

    public void validateAcross(Transport transport) {
        this.validateProperties("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", transport, null, (List)transport.getProperties(), "ERROR_TRANSPORT_PROPERTY_DUPLICATION", "ERROR_TRANSPORT_PROPERTY_NAME_REQUIRED");
    }

    public void validateLocal(EndPoint endPoint) {
        this.testPort("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", endPoint.getPort(), false, "ERROR_ENDPOINT_PORT_INVALID", endPoint);
    }

    public void validateLocal(Transport transport) {
        String string;
        if (transport.isSslEnabled() && ((string = transport.getSslConfig()) == null || string.length() == 0)) {
            this.addError("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", "ERROR_TRANSPORT_SSLCONFIG_REQUIRED", new String[0], transport);
        }
    }

    public void validateAcross(ThreadPool threadPool) {
        this.traceStub("validateAcross(ThreadPool)");
    }

    public void validateLocal(ThreadPool threadPool) {
        this.traceBegin("validateLocal(ThreadPool)");
        int n = threadPool.getMinimumSize();
        boolean bl = this.testInteger("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", n, 0, Short.MAX_VALUE, "ERROR_THREAD_POOL_MINIMUM_SIZE_OUT_OF_RANGE", (Object)threadPool);
        int n2 = threadPool.getMaximumSize();
        boolean bl2 = this.testInteger("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", n2, 0, Short.MAX_VALUE, "ERROR_THREAD_POOL_MAXIMUM_SIZE_OUT_OF_RANGE", (Object)threadPool);
        if (bl2 && n2 > 500) {
            this.addWarning("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", "WARNING_THREAD_POOL_SIZE_MAYBE_TOO_HIGH", new String[]{String.valueOf(n2), Integer.toString(500)}, threadPool);
        }
        if (bl && bl2 && n > n2) {
            this.addError("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", "ERROR_THREAD_POOL_SIZE_CONFLICT", new String[]{String.valueOf(n), String.valueOf(n2)}, threadPool);
        }
        int n3 = threadPool.getInactivityTimeout();
        this.testIntegerMin("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", n3, -1, "ERROR_THREAD_POOL_INACTIVITY_TIMEOUT_OUT_OF_RANGE", (Object)threadPool);
        this.traceEnd();
    }

    public void validateAcross(ManagedObject managedObject) {
        StateManageable stateManageable;
        StatisticsProvider statisticsProvider = managedObject.getStatisticsProvider();
        if (statisticsProvider != null) {
            this.validateLocal(statisticsProvider, managedObject);
            this.validateAcross(statisticsProvider, managedObject);
        }
        if ((stateManageable = managedObject.getStateManagement()) != null) {
            this.validateLocal(stateManageable, managedObject);
            this.validateAcross(stateManageable, managedObject);
        }
    }

    public void validateLocal(ManagedObject managedObject) {
    }

    public void validateLocal(StateManageable stateManageable, ManagedObject managedObject) {
        EEnum eEnum;
        int n = stateManageable.getInitialState().getValue();
        if (!this.isEnumValueValid(n, eEnum = ProcessPackage.eINSTANCE.getExecutionState())) {
            this.addError("com.ibm.websphere.validation.base.config.websphereplatformvalidationNLS", "ERROR_STATE_MANAGEABLE_INITIAL_STATE_INVALID", new String[]{String.valueOf(n), managedObject.getName()}, stateManageable);
        }
    }

    public void validateAcross(StateManageable stateManageable, ManagedObject managedObject) {
    }

    public void validateLocal(StatisticsProvider statisticsProvider, ManagedObject managedObject) {
        this.traceStub("validateLocal(StatisticsProvider)");
    }

    public void validateAcross(StatisticsProvider statisticsProvider, ManagedObject managedObject) {
        this.traceStub("validateAcross(StatisticsProvider)");
    }

    protected WorkSpaceHelper createWorkSpaceHelper() {
        return new WorkSpaceHelper(this);
    }

    public WorkSpaceHelper getWorkSpaceHelper() {
        return this._workSpaceHelper;
    }

    public WebServer getWebServer(Server server) {
        return this._workSpaceHelper.getWebServer(server);
    }

    public boolean isTemplate(String string) {
        return this._workSpaceHelper.isTemplate(string);
    }

    public String getCellUri() {
        return this._workSpaceHelper.getCellUri();
    }

    public String getCellName() {
        return this._workSpaceHelper.getCellName();
    }

    public String getNodeUri() {
        return this._workSpaceHelper.getNodeUri();
    }

    public String getNodeName() {
        return this._workSpaceHelper.getNodeName();
    }

    public String getServerUri() {
        return this._workSpaceHelper.getServerUri();
    }

    public String getServerName() {
        return this._workSpaceHelper.getServerName();
    }

    public String getNodeUri(String string) {
        return this._workSpaceHelper.getNodeUri(string);
    }

    public HashMap getNodeUris() {
        return this._workSpaceHelper.getNodeUris();
    }

    public HashSet getNodeNames() {
        return this._workSpaceHelper.getNodeNames();
    }

    public List getClusterUris() {
        return this._workSpaceHelper.getClusterUris();
    }

    public List getNodeGroupUris() {
        return this._workSpaceHelper.getNodeGroupUris();
    }

    public List getNodeGroupNames() {
        return this._workSpaceHelper.getNodeGroupNames();
    }

    public List getClusterNames() {
        return this._workSpaceHelper.getClusterNames();
    }

    public List getApplicationUris() {
        return this._workSpaceHelper.getApplicationUris();
    }

    public List getApplicationNames() {
        return this._workSpaceHelper.getApplicationNames();
    }

    public HashSet getCoreGroupNames() {
        return this._workSpaceHelper.getCoreGroupNames();
    }

    public boolean hasNamedCoreGroup(String string) {
        return this._workSpaceHelper.hasNamedCoreGroup(string);
    }

    public HashMap getCoreGroupUris() {
        return this._workSpaceHelper.getCoreGroupUris();
    }

    public String getCoreGroupUri(String string) {
        return this._workSpaceHelper.getCoreGroupUri(string);
    }

    public ServerEntry getServerEntry(String string, String string2) {
        return this._workSpaceHelper.getServerEntry(string, string2);
    }

    public ServerIndex getServerIndex(String string) {
        return this._workSpaceHelper.getServerIndex(string);
    }

    public HashMap getServerIndices() {
        return this._workSpaceHelper.getServerIndices();
    }

    public String getServerType() {
        return this._workSpaceHelper.getServerType();
    }

    public ServerEntry getServerEntry() {
        return this._workSpaceHelper.getServerEntry();
    }

    public ServerIndex getServerIndex() {
        return this._workSpaceHelper.getServerIndex();
    }

    public List getMultibrokerDomains() {
        return this._workSpaceHelper.getMultibrokerDomains();
    }

    public HashMap getNodeServerUris() {
        return this._workSpaceHelper.getNodeServerUris();
    }

    public HashMap getNodeServerNames() {
        return this._workSpaceHelper.getNodeServerNames();
    }

    public List getNodeSystemMessageServers() {
        return this._workSpaceHelper.getNodeSystemMessageServers();
    }

    public HashMap getNodeNodeAgents() {
        return this._workSpaceHelper.getNodeNodeAgents();
    }

    public boolean isFederated() {
        return this._workSpaceHelper.isFederated();
    }

    public HashMap getDeploymentMap() {
        return this._workSpaceHelper.getDeploymentMap();
    }

    public boolean isDeployed(String string) {
        return this._workSpaceHelper.isDeployed(string);
    }

    public Security getCellSecurity() {
        return this._workSpaceHelper.getCellSecurity();
    }

    public HashSet getCellSecurityAliasTable() {
        return this._workSpaceHelper.getCellSecurityAliasTable();
    }

    public HashSet getCellSecurityJAASAuthDataTable() {
        return this._workSpaceHelper.getCellSecurityJAASAuthDataTable();
    }

    public CoreGroup getCoreGroup(String string) {
        return this._workSpaceHelper.getCoreGroup(string);
    }

    public HashMap getCoreGroups() {
        return this._workSpaceHelper.getCoreGroups();
    }

    public boolean isSetToStart(StateManageable stateManageable) {
        return this._workSpaceHelper.isSetToStart(stateManageable);
    }

    public boolean isSetToStart(ManagedObject managedObject) {
        return this._workSpaceHelper.isSetToStart(managedObject);
    }

    protected FeaturesHelper createFeaturesHelper() {
        return new FeaturesHelper(this, this.getWorkSpaceHelper());
    }

    public FeaturesHelper getFeaturesHelper() {
        return this._featuresHelper;
    }

    public boolean isZOS() {
        return this._featuresHelper.isZOS();
    }

    public boolean testName(String string) {
        return this._typeTester.testName(string);
    }

    public boolean testJavaClass(String string) {
        return this._typeTester.testJavaClass(string);
    }

    public boolean testFile(String string) {
        return this._typeTester.testFile(string);
    }

    public boolean testPath(String string) {
        return this._typeTester.testPath(string);
    }

    public boolean testJarPath(String string) {
        return this._typeTester.testJarPath(string);
    }

    public boolean testClassPath(String string) {
        return this._typeTester.testClassPath(string);
    }

    public boolean testPort(int n, boolean bl, String string, Object object) {
        return this._typeTester.testPort(n, bl, string, object);
    }

    public boolean testPort(String string, int n, boolean bl, String string2, Object object) {
        return this._typeTester.testPort(string, n, bl, string2, object);
    }

    public boolean testURI(String string) {
        return this._typeTester.testURI(string);
    }

    public boolean testURL(String string) {
        return this._typeTester.testURL(string);
    }

    public boolean testInteger(int n, int n2, int n3, String string, Object object) {
        return this._typeTester.testInteger(n, n2, n3, string, object);
    }

    public boolean testInteger(String string, int n, int n2, int n3, String string2, Object object) {
        return this._typeTester.testInteger(string, n, n2, n3, string2, object);
    }

    public boolean testInteger(Integer n, String string, int n2, int n3, String string2, Object object) {
        return this._typeTester.testInteger(n, string, n2, n3, string2, object);
    }

    public boolean testInteger(String string, int n, int n2, String string2, String string3, Object object) {
        return this._typeTester.testInteger(string, n, n2, string2, string3, object);
    }

    public boolean testInteger(String string, String string2, Object object) {
        return this._typeTester.testInteger(string, string2, object);
    }

    public boolean testIntegerMax(int n, int n2, String string, Object object) {
        return this._typeTester.testIntegerMax(n, n2, string, object);
    }

    public boolean testIntegerMax(Integer n, String string, int n2, String string2, Object object) {
        return this._typeTester.testIntegerMax(n, string, n2, string2, object);
    }

    public boolean testIntegerMax(String string, int n, String string2, String string3, Object object) {
        return this._typeTester.testIntegerMax(string, n, string2, string3, object);
    }

    public boolean testIntegerMin(int n, int n2, String string, Object object) {
        return this._typeTester.testIntegerMin(n, n2, string, object);
    }

    public boolean testIntegerMin(String string, int n, int n2, String string2, Object object) {
        return this._typeTester.testIntegerMin(string, n, n2, string2, object);
    }

    public boolean testIntegerMin(Integer n, String string, int n2, String string2, Object object) {
        return this._typeTester.testIntegerMin(n, string, n2, string2, object);
    }

    public boolean testIntegerMin(String string, int n, String string2, String string3, Object object) {
        return this._typeTester.testIntegerMin(string, n, string2, string3, object);
    }

    public boolean testLong(long l, long l2, long l3, String string, Object object) {
        return this._typeTester.testLong(l, l2, l3, string, object);
    }

    public boolean testLong(Long l, String string, long l2, long l3, String string2, Object object) {
        return this._typeTester.testLong(l, string, l2, l3, string2, object);
    }

    public boolean testLong(String string, long l, long l2, String string2, String string3, Object object) {
        return this._typeTester.testLong(string, l, l2, string2, string3, object);
    }

    public boolean testLong(String string, String string2, Object object) {
        return this._typeTester.testLong(string, string2, object);
    }

    public boolean testLongMin(long l, long l2, String string, Object object) {
        return this._typeTester.testLongMin(l, l2, string, object);
    }

    public boolean testLongMax(long l, long l2, String string, String[] stringArray, Object object) {
        return this._typeTester.testLongMax(l, l2, string, stringArray, object);
    }

    public boolean testLongMax(Long l, long l2, String string, String[] stringArray, String string2, String[] stringArray2, Object object) {
        return this._typeTester.testLongMax(l, l2, string, stringArray, string2, stringArray2, object);
    }

    public boolean testLongMax(String string, long l, String string2, String[] stringArray, String string3, String[] stringArray2, Object object) {
        return this._typeTester.testLongMax(string, l, string2, stringArray, string3, stringArray2, object);
    }

    public boolean testLongMin(long l, long l2, String string, String[] stringArray, Object object) {
        return this._typeTester.testLongMin(l, l2, string, stringArray, object);
    }

    public boolean testLongMin(Long l, long l2, String string, String[] stringArray, String string2, String[] stringArray2, Object object) {
        return this._typeTester.testLongMin(l, l2, string, stringArray, string2, stringArray2, object);
    }

    public boolean testLongMin(String string, long l, String string2, String[] stringArray, String string3, String[] stringArray2, Object object) {
        return this._typeTester.testLongMin(string, l, string2, stringArray, string3, stringArray2, object);
    }

    public boolean testNullOrEmptyError(Collection collection, String string, Object object) {
        return this._typeTester.testNullOrEmptyError(collection, string, object);
    }

    public boolean testNullOrEmptyWarning(Collection collection, String string, Object object) {
        return this._typeTester.testNullOrEmptyWarning(collection, string, object);
    }

    public boolean testNullOrEmpty(Collection collection) {
        return this._typeTester.testNullOrEmpty(collection);
    }

    public boolean testValidChars(String string, String string2) {
        return this._typeTester.testValidChars(string, string2);
    }

    public boolean isValueValidByType(String string, String string2) {
        return this._typeTester.isValueValidByType(string, string2);
    }
}

