/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.config;

import com.ibm.websphere.validation.base.config.MOFValidator;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.regex.Pattern;

public class TypeTester {
    public static final String pgmVersion = "%G%";
    public static final String pgmUpdate = "%G%";
    public MOFValidator _parentValidator;
    public static final int MIN_TCPIP_PORT = 0;
    public static final int MAX_TCPIP_PORT = 65535;
    public static final String WAS_NAME_EXPRESSION = "^[^ /\\\\*,:;=\\+\\?\\|<>&%'\"`\\.][^/\\\\*,:;=\\+\\?\\|<>&%'\"`]*$";
    public static final Pattern namePattern = Pattern.compile("^[^ /\\\\*,:;=\\+\\?\\|<>&%'\"`\\.][^/\\\\*,:;=\\+\\?\\|<>&%'\"`]*$");
    public static final String SYSTEM_TYPE_PREFIX = "java.lang.";

    public TypeTester(MOFValidator mOFValidator) {
        this._parentValidator = mOFValidator;
    }

    public MOFValidator getParentValidator() {
        return this._parentValidator;
    }

    public boolean testClassPath(String string) {
        this._parentValidator.traceStub("Validation of class path: ", string);
        return true;
    }

    public boolean testFile(String string) {
        this._parentValidator.traceStub("Validation of file name: ", string);
        return true;
    }

    public boolean testJarPath(String string) {
        this._parentValidator.traceStub("Validation of jar path: ", string);
        return true;
    }

    public boolean testJavaClass(String string) {
        this._parentValidator.traceStub("Validation of java class name: ", string);
        return true;
    }

    public boolean testPath(String string) {
        this._parentValidator.traceStub("Validation of path: ", string);
        return true;
    }

    public boolean testURI(String string) {
        this._parentValidator.traceStub("Syntax test of URI", string);
        return true;
    }

    public boolean testURL(String string) {
        this._parentValidator.traceStub("Validation of URL: ", string);
        return true;
    }

    public boolean testPort(int n, boolean bl, String string, Object object) {
        return this.testPort(this._parentValidator.getBundleId(), n, bl, string, object);
    }

    public boolean testPort(String string, int n, boolean bl, String string2, Object object) {
        if (bl && n == -1) {
            return true;
        }
        if (n >= 0 && n <= 65535) {
            return true;
        }
        this._parentValidator.addError(string, string2, new String[]{Integer.toString(n), Integer.toString(0), Integer.toString(65535)}, object);
        return false;
    }

    public boolean testName(String string) {
        return namePattern.matcher(string).matches();
    }

    public boolean testValidChars(String string, String string2) {
        int n = string.length();
        boolean bl = true;
        for (int i = 0; bl && i < n; ++i) {
            char c = string.charAt(i);
            bl = string2.indexOf(c) != -1;
        }
        return bl;
    }

    public boolean testInteger(int n, int n2, int n3, String string, Object object) {
        return this.testInteger(this._parentValidator.getBundleId(), n, n2, n3, string, object);
    }

    public boolean testInteger(String string, int n, int n2, int n3, String string2, Object object) {
        if (n >= n2 && n <= n3) {
            return true;
        }
        String[] stringArray = new String[]{Integer.toString(n), Integer.toString(n2), Integer.toString(n3)};
        this._parentValidator.addError(string, string2, stringArray, object);
        return false;
    }

    public boolean testIntegerMax(int n, int n2, String string, Object object) {
        return this.testIntegerMax(this._parentValidator.getBundleId(), n, n2, string, object);
    }

    public boolean testIntegerMax(String string, int n, int n2, String string2, Object object) {
        if (n <= n2) {
            return true;
        }
        String[] stringArray = new String[]{Integer.toString(n), Integer.toString(n2)};
        this._parentValidator.addError(string, string2, stringArray, object);
        return false;
    }

    public boolean testIntegerMin(int n, int n2, String string, Object object) {
        return this.testIntegerMin(this._parentValidator.getBundleId(), n, n2, string, object);
    }

    public boolean testIntegerMin(String string, int n, int n2, String string2, Object object) {
        if (n >= n2) {
            return true;
        }
        String[] stringArray = new String[]{Integer.toString(n), Integer.toString(n2)};
        this._parentValidator.addError(string, string2, stringArray, object);
        return false;
    }

    public boolean testInteger(Integer n, String string, int n2, int n3, String string2, Object object) {
        if (n == null) {
            this._parentValidator.addError(string, object);
            return false;
        }
        return this.testInteger(n, n2, n3, string2, object);
    }

    public boolean testIntegerMax(Integer n, String string, int n2, String string2, Object object) {
        if (n == null) {
            this._parentValidator.addError(string, object);
            return false;
        }
        return this.testIntegerMax(n, n2, string2, object);
    }

    public boolean testIntegerMin(Integer n, String string, int n2, String string2, Object object) {
        if (n == null) {
            this._parentValidator.addError(string, object);
            return false;
        }
        return this.testIntegerMin(n, n2, string2, object);
    }

    public boolean testInteger(String string, int n, int n2, String string2, String string3, Object object) {
        int n3;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._parentValidator.addError(string2, new String[]{string}, object);
            return false;
        }
        return this.testInteger(n3, n, n2, string3, object);
    }

    public boolean testIntegerMax(String string, int n, String string2, String string3, Object object) {
        int n2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._parentValidator.addError(string2, new String[]{string}, object);
            return false;
        }
        return this.testIntegerMax(n2, n, string3, object);
    }

    public boolean testIntegerMin(String string, int n, String string2, String string3, Object object) {
        int n2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._parentValidator.addError(string2, new String[]{string}, object);
            return false;
        }
        return this.testIntegerMin(n2, n, string3, object);
    }

    public boolean testInteger(String string, String string2, Object object) {
        try {
            int n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._parentValidator.addError(string2, new String[]{string}, object);
            return false;
        }
        return true;
    }

    public boolean testLong(long l, long l2, long l3, String string, Object object) {
        if (l >= l2 && l <= l3) {
            return true;
        }
        String[] stringArray = new String[]{Long.toString(l), Long.toString(l2), Long.toString(l3)};
        this._parentValidator.addError(string, stringArray, object);
        return false;
    }

    public boolean testLongMax(long l, long l2, String string, String[] stringArray, Object object) {
        if (l <= l2) {
            return true;
        }
        this._parentValidator.addError(string, stringArray, object);
        return false;
    }

    public boolean testLongMin(long l, long l2, String string, Object object) {
        return this.testLongMin(this._parentValidator.getBundleId(), l, l2, string, object);
    }

    public boolean testLongMin(String string, long l, long l2, String string2, Object object) {
        if (l >= l2) {
            return true;
        }
        String[] stringArray = new String[]{Long.toString(l), Long.toString(l2)};
        this._parentValidator.addError(string, string2, stringArray, object);
        return false;
    }

    public boolean testLongMin(long l, long l2, String string, String[] stringArray, Object object) {
        if (l >= l2) {
            return true;
        }
        String[] stringArray2 = new String[]{Long.toString(l), Long.toString(l2)};
        this._parentValidator.addError(string, stringArray2, object);
        return false;
    }

    public boolean testLong(Long l, String string, long l2, long l3, String string2, Object object) {
        if (l == null) {
            this._parentValidator.addError(string, object);
            return false;
        }
        return this.testLong(l, l2, l3, string2, object);
    }

    public boolean testLong(String string, long l, long l2, String string2, String string3, Object object) {
        long l3;
        try {
            l3 = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._parentValidator.addError(string2, new String[]{string}, object);
            return false;
        }
        return this.testLong(l3, l, l2, string3, object);
    }

    public boolean testLong(String string, String string2, Object object) {
        try {
            long l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._parentValidator.addError(string2, new String[]{string}, object);
            return false;
        }
        return true;
    }

    public boolean testLongMax(Long l, long l2, String string, String[] stringArray, String string2, String[] stringArray2, Object object) {
        if (l == null) {
            this._parentValidator.addError(string, stringArray, object);
            return false;
        }
        return this.testLongMax(l, l2, string2, stringArray2, object);
    }

    public boolean testLongMin(Long l, long l2, String string, String[] stringArray, String string2, String[] stringArray2, Object object) {
        if (l == null) {
            this._parentValidator.addError(string, stringArray, object);
            return false;
        }
        return this.testLongMin(l, l2, string2, stringArray2, object);
    }

    public boolean testLongMax(String string, long l, String string2, String[] stringArray, String string3, String[] stringArray2, Object object) {
        long l2;
        try {
            l2 = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._parentValidator.addError(string2, stringArray, object);
            return false;
        }
        if (l2 <= l) {
            return true;
        }
        this._parentValidator.addError(string3, stringArray2, object);
        return false;
    }

    public boolean testLongMin(String string, long l, String string2, String[] stringArray, String string3, String[] stringArray2, Object object) {
        long l2;
        try {
            l2 = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            this._parentValidator.addError(string2, stringArray, object);
            return false;
        }
        return this.testLongMin(l2, l, string3, stringArray2, object);
    }

    public boolean testNullOrEmptyError(Collection collection, String string, Object object) {
        if (this.testNullOrEmpty(collection)) {
            this._parentValidator.addError(string, object);
            return true;
        }
        return false;
    }

    public boolean testNullOrEmptyWarning(Collection collection, String string, Object object) {
        if (this.testNullOrEmpty(collection)) {
            this._parentValidator.addWarning(string, object);
            return true;
        }
        return false;
    }

    public boolean testNullOrEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public boolean isValueValidByType(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (this.testValueByType(string, string2)) {
            return true;
        }
        if (string2.startsWith(SYSTEM_TYPE_PREFIX)) {
            return false;
        }
        String string3 = SYSTEM_TYPE_PREFIX + string2;
        return this.testValueByType(string, string3);
    }

    protected boolean testValueByType(String string, String string2) {
        Constructor<?> constructor;
        Class<?> clazz;
        if (string == null || string2 == null) {
            return false;
        }
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        Class<?> clazz2 = string.getClass();
        Class[] classArray = new Class[]{clazz2};
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
        Object[] objectArray = new Object[]{string};
        try {
            constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

