/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.base.bindings.webappbnd;

import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.j2ee.validation.J2EEValidator;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.validation.FullReporter;
import com.ibm.websphere.validation.base.bindings.webappbnd.WebAppBindingMessageConstants;
import com.ibm.websphere.validation.helpers.PassthruHelper;
import java.util.Iterator;

public class WebAppBindingValidator
extends J2EEValidator
implements WebAppBindingMessageConstants {
    public String getBaseName() {
        return "com.ibm.websphere.validation.base.bindings.webappbnd.webappbndvalidation";
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: first arg specifies full path to WAR file.");
        }
        String string = stringArray[0];
        try {
            WARFile wARFile = CommonarchiveFactoryImpl.getActiveFactory().openWARFile(string);
            WebAppBinding webAppBinding = wARFile.getBindings();
            PassthruHelper passthruHelper = new PassthruHelper(webAppBinding);
            FullReporter fullReporter = new FullReporter();
            WebAppBindingValidator webAppBindingValidator = new WebAppBindingValidator();
            webAppBindingValidator.validate(passthruHelper, fullReporter, null);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void validate(WebAppBinding webAppBinding) {
        String string;
        Object object;
        Object object2;
        Object object3;
        String string2;
        WebApp webApp = webAppBinding.getWebapp();
        if (webApp == null) {
            this.addError("NULL_WEBAPP_REFERENCE");
            return;
        }
        String string3 = webApp.getDisplayName();
        if (string3 == null || string3.length() == 0) {
            string3 = "?";
        }
        if ((string2 = webAppBinding.getVirtualHostName()) == null || string2.length() == 0) {
            string2 = "?";
        }
        Iterator iterator = webAppBinding.getEjbRefBindings().iterator();
        while (iterator.hasNext()) {
            object3 = (EjbRefBinding)iterator.next();
            object2 = object3.getBindingEjbRef();
            if (object2 == null) {
                this.addError("NULL_EJBREF_REFERENCE", new String[]{string3});
                continue;
            }
            object = object2.getHome();
            if (object == null || ((String)object).length() == 0) {
                object = "?";
            }
            if ((string = object3.getJndiName()) != null && string.length() != 0) continue;
            this.addWarning("NO_JNDINAME_FOR_EJBREF", new String[]{object, string3});
        }
        object3 = webAppBinding.getResRefBindings().iterator();
        while (object3.hasNext()) {
            String string4;
            String string5;
            object2 = (ResourceRefBinding)object3.next();
            object = object2.getBindingResourceRef();
            if (object == null) {
                this.addError("NULL_RESOURCEREF_REFERENCE", new String[]{string3});
                continue;
            }
            string = object.getType();
            if (string == null || string.length() == 0) {
                string = "?";
            }
            if ((string5 = object.getName()) == null || string5.length() == 0) {
                string5 = "?";
            }
            if ((string4 = object2.getJndiName()) != null && string4.length() != 0) continue;
            this.addWarning("NO_JNDINAME_FOR_RESOURCEREF", new String[]{string5, string, string3});
        }
    }

    public void validate(IHelper iHelper, IReporter iReporter, IFileDelta[] iFileDeltaArray) throws ValidationException {
        this._reporter = iReporter;
        this._helper = iHelper;
        if (this._reporter == null || this._helper == null) {
            return;
        }
        try {
            Object object = this._helper.loadModel("WebAppBinding");
            if (object == null) {
                return;
            }
            this.validate((WebAppBinding)object);
        }
        catch (Exception exception) {
            this.addError("ERROR_WEBAPPBND_VALIDATION_FAILED", new String[]{exception.getMessage()});
            exception.printStackTrace();
        }
    }
}

