/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.roseparser;

import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Util {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String QUOTE = "\"";
    private static Hashtable externalFiles = new Hashtable(10, 0.5f);
    public static final int PATH_NOT_VALID = 0;
    public static final int DIRECTORY_NOT_FOUND = 1;
    public static final int PATH_OK = 2;
    public static final int NOT_A_DIRECTORY = 3;

    public static boolean createDirectory(String string) {
        try {
            File file = new File(string);
            return file.mkdirs();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static String getName(String string) {
        int n = string.lastIndexOf(QUOTE);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        int n2 = string2.lastIndexOf(QUOTE);
        if (n2 == -1) {
            return null;
        }
        String string3 = string.substring(n2 + 1, n);
        if (string3.indexOf("$UNNAMED") != -1) {
            string3 = "";
        }
        return string3;
    }

    public static String getType(String string) {
        return Util.getWord(string, 1);
    }

    public static String getWord(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (++n2 != n) continue;
            return string2;
        }
        return null;
    }

    public static int isValidPath(String string) {
        File file;
        try {
            file = new File(string);
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
        boolean bl = false;
        try {
            bl = file.exists();
        }
        catch (SecurityException securityException) {
            return 0;
        }
        boolean bl2 = false;
        try {
            bl2 = file.isDirectory();
        }
        catch (SecurityException securityException) {
            return 0;
        }
        if (!bl2) {
            if (bl) {
                return 3;
            }
            return 1;
        }
        return 2;
    }

    public static void putIntoExternalFiles(String string, String string2) {
        externalFiles.put(Util.trimQuotes(string.toUpperCase()), Util.trimQuotes(string2));
    }

    public static String resolveFileName(String string) {
        int n;
        string = Util.trimQuotes(string);
        string = Util.updateFileName(string, "\\\\");
        string = Util.updateFileName(string, "\\");
        string = Util.updateFileName(string, "/");
        String string2 = "";
        while ((n = string.indexOf(File.separator)) != -1) {
            String string3 = string.substring(0, n);
            if (string3.length() > 0 && string3.charAt(0) == '$') {
                string3 = string3.substring(1);
                string3 = (String)externalFiles.get(string3.toUpperCase());
            }
            string2 = string2 + string3 + File.separator;
            string = string.substring(n + 1);
        }
        string2 = string2 + string;
        return string2;
    }

    public static String trimQuotes(String string) {
        int n = string.indexOf(QUOTE);
        int n2 = string.lastIndexOf(QUOTE);
        if (n == -1) {
            return string;
        }
        if (n == n2) {
            return string.substring(n + 1);
        }
        return string.substring(n + 1, n2);
    }

    public static String updateFileName(String string, String string2) {
        String string3 = "";
        while (true) {
            int n;
            if ((n = string.indexOf(string2)) == -1) break;
            string3 = string3 + string.substring(0, n) + File.separator;
            string = string.substring(n + string2.length());
        }
        string3 = string3 + string;
        return string3;
    }
}

