/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.roseparser;

import com.ibm.psh.roseparser.RoseLexer;
import com.ibm.psh.roseparser.RoseLoader;
import com.ibm.psh.roseparser.RoseNode;
import com.ibm.psh.roseparser.RoseParser;
import com.ibm.psh.roseparser.RoseWriter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class RoseTree
implements PropertyChangeListener {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private RoseLoader loader;
    private RoseLexer lexer;
    private RoseParser parser;
    private String inFileName;
    private String outFileName;

    public RoseTree(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            this.inFileName = stringArray[0];
        }
        String string = "false";
        String string2 = "false";
        if (stringArray.length > 1) {
            string = stringArray[1];
        }
        if (stringArray.length > 2) {
            string2 = stringArray[2];
        }
        if (stringArray.length > 3) {
            this.outFileName = stringArray[3];
        }
        this.loader = new RoseLoader(this.inFileName);
        this.loader.addPropertyChangeListener(this);
        this.loader.setProgressIncrement(5);
        this.loader.setLower(25);
        this.loader.setUpper(50);
        this.lexer = new RoseLexer(this.loader);
        this.parser = string.equals("true") ? (string2.equals("true") ? new RoseParser(this.lexer, true, true) : new RoseParser(this.lexer, true, false)) : (string2.equals("true") ? new RoseParser(this.lexer, false, true) : new RoseParser(this.lexer, false, false));
        this.parser.parse();
        System.out.println("parser is done");
    }

    public static void main(String[] stringArray) throws Exception {
        RoseTree roseTree = new RoseTree(stringArray);
        roseTree.traverse();
        roseTree.writeRose();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("ROSE_WRITE_PROGRESS")) {
            Integer n = (Integer)propertyChangeEvent.getOldValue();
            Integer n2 = (Integer)propertyChangeEvent.getNewValue();
            System.out.println("saving ... " + n + " " + n2);
        } else if (propertyChangeEvent.getPropertyName().equals("ROSE_LOADER_PROGRESS")) {
            Integer n = (Integer)propertyChangeEvent.getOldValue();
            Integer n3 = (Integer)propertyChangeEvent.getNewValue();
            System.out.println("loading ... " + n + " " + n3);
        }
    }

    public void traverse() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = null;
        Vector<Integer> vector = new Vector<Integer>();
        while (true) {
            try {
                block3: while (true) {
                    this.parser.traverseTree(vector);
                    System.out.print("input path >");
                    string = bufferedReader.readLine();
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    vector.removeAllElements();
                    while (true) {
                        if (!stringTokenizer.hasMoreTokens()) continue block3;
                        String string2 = stringTokenizer.nextToken();
                        if (string2.equals("q")) {
                            return;
                        }
                        Integer n = new Integer(string2);
                        vector.addElement(n);
                    }
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("RoseTree - Exception while readLine");
                continue;
            }
            break;
        }
    }

    public static void traverse(RoseNode roseNode) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = null;
        Vector<Integer> vector = new Vector<Integer>();
        while (true) {
            try {
                block3: while (true) {
                    RoseParser.traverseTree(vector, roseNode);
                    System.out.print("input path >");
                    string = bufferedReader.readLine();
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    vector.removeAllElements();
                    while (true) {
                        if (!stringTokenizer.hasMoreTokens()) continue block3;
                        String string2 = stringTokenizer.nextToken();
                        if (string2.equals("q")) {
                            return;
                        }
                        Integer n = new Integer(string2);
                        vector.addElement(n);
                    }
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("RoseTree - Exception while readLine");
                continue;
            }
            break;
        }
    }

    public void writeRose() throws Exception {
        RoseWriter roseWriter = new RoseWriter(this.outFileName, this.parser.getVersionTree(), this.parser.getModelTree());
        roseWriter.addPropertyChangeListener(this);
        roseWriter.setProgressIncrement(20);
        roseWriter.setLower(20);
        roseWriter.setUpper(60);
        roseWriter.write();
    }
}

