/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.rb30;

import com.ibm.psh.rb30.ResourceUtil;
import com.ibm.psh.rb30.RoseUtil;
import com.ibm.psh.rb30.TableObject;
import com.ibm.psh.rb30.UnitTreeNode;
import com.ibm.psh.roseparser.RoseNode;
import com.ibm.psh.roseparser.Util;
import com.ibm.xmi.uml.Type;
import java.util.Vector;

public class RoseFirstTraverse {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999,2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private String inFileName;
    private String xmiBaseFileName;
    private String xmiFileName;

    public RoseFirstTraverse(String string) {
        this.inFileName = string;
    }

    private String getFullName(RoseNode roseNode) {
        RoseNode roseNode2 = roseNode;
        String string = Util.getName(roseNode2.getValue());
        for (RoseNode roseNode3 = roseNode2.getParent(); roseNode3 != null; roseNode3 = roseNode3.getParent()) {
            String string2 = roseNode3.getKey();
            String string3 = Util.getType(roseNode3.getValue());
            String string4 = Util.getName(roseNode3.getValue());
            if (!string2.equals("") || !string3.equals("Class_Category")) continue;
            string = string4 + "." + string;
        }
        return string;
    }

    private String getParentUUID(RoseNode roseNode) {
        RoseNode roseNode2 = roseNode;
        String string = null;
        for (RoseNode roseNode3 = roseNode2.getParent(); roseNode3 != null; roseNode3 = roseNode3.getParent()) {
            string = (String)roseNode3.getNode();
            if (string == null) continue;
            return string;
        }
        return string;
    }

    public void setXMIBaseFileName(String string) {
        this.xmiBaseFileName = string;
    }

    public void setXMIFileName(String string) {
        this.xmiFileName = string;
    }

    public void traverse(RoseNode roseNode, UnitTreeNode unitTreeNode) throws Exception {
        Vector vector = roseNode.getNodes();
        for (int i = 0; i < vector.size(); ++i) {
            RoseNode roseNode2 = (RoseNode)vector.elementAt(i);
            if (roseNode2.getType() == 2) {
                this.traverseObject(roseNode2, unitTreeNode);
                continue;
            }
            if (roseNode2.getType() != 3) continue;
            this.traverseList(roseNode2, unitTreeNode);
        }
    }

    private void traverseList(RoseNode roseNode, UnitTreeNode unitTreeNode) throws Exception {
        this.traverse(roseNode, unitTreeNode);
    }

    private void traverseObject(RoseNode roseNode, UnitTreeNode unitTreeNode) throws Exception {
        String string = roseNode.getKey();
        String string2 = Util.getType(roseNode.getValue());
        String string3 = Util.getName(roseNode.getValue());
        if (string.equals("root_category") && string2.equals("Class_Category") && string3.equals(ResourceUtil.getString("LOGICAL_VIEW"))) {
            String string4 = unitTreeNode.getQUID();
            if (string4.equals("")) {
                string4 = roseNode.getRoseId();
                string4 = string4 != null ? string4.substring(1, string4.length() - 1) : "";
            }
            if (!string4.equals("")) {
                unitTreeNode.setQUID(string4);
                Vector vector = RoseUtil.getXMIFileVector("\"" + this.inFileName + "\"", roseNode);
                this.xmiBaseFileName = (String)vector.elementAt(0);
                this.xmiFileName = (String)vector.elementAt(1);
                TableObject tableObject = new TableObject(unitTreeNode.getName(), string4, this.xmiBaseFileName, this.xmiFileName, RoseUtil.getUUID(roseNode), Type.MODEL, null, "true");
                RoseUtil.quid_InfoTable.put(string4, tableObject);
                RoseUtil.uuid_InfoTable.put(tableObject.getUUID(), tableObject);
                roseNode.setNode(tableObject.getUUID());
            }
            this.traverse(roseNode, unitTreeNode);
        } else if (string.equals("") && string2.equals("Class_Category")) {
            String string5 = roseNode.getRoseId();
            if (string5 != null) {
                string5 = string5.substring(1, string5.length() - 1);
            }
            String string6 = this.getParentUUID(roseNode);
            RoseNode roseNode2 = roseNode.findNodeWithKey("is_loaded");
            if (roseNode2 != null) {
                RoseNode roseNode3 = roseNode.findNodeWithKey("file_name");
                String string7 = roseNode3.getValue();
                String string8 = Util.resolveFileName(string7);
                if (!(string8.endsWith("boim.cat") || string8.endsWith("managed.cat") || string8.endsWith("services.cat") || string8.endsWith("java.cat") || string8.endsWith("sun.cat"))) {
                    UnitTreeNode unitTreeNode2 = new UnitTreeNode(string3, string5, string8, string7);
                    unitTreeNode.addNode(unitTreeNode2);
                    if (string5 != null) {
                        Vector vector = RoseUtil.getXMIFileVector(string7, roseNode);
                        TableObject tableObject = new TableObject(string3, string5, (String)vector.elementAt(0), (String)vector.elementAt(1), "", Type.PACKAGE, string6, "true");
                        RoseUtil.quid_InfoTable.put(string5, tableObject);
                    }
                    RoseUtil.createRoseUnitTreeAndTable(string7, unitTreeNode2, string6);
                }
            } else {
                if (string5 != null) {
                    TableObject tableObject = new TableObject(string3, string5, this.xmiBaseFileName, this.xmiFileName, RoseUtil.getUUID(roseNode), Type.PACKAGE, string6, "false");
                    RoseUtil.quid_InfoTable.put(string5, tableObject);
                    RoseUtil.uuid_InfoTable.put(tableObject.getUUID(), tableObject);
                    roseNode.setNode(tableObject.getUUID());
                }
                this.traverse(roseNode, unitTreeNode);
            }
        } else if (string2.equals("Class")) {
            String string9;
            Type type = Type.CLASS;
            RoseNode roseNode4 = roseNode.findNodeWithKey("stereotype");
            if (roseNode4 != null) {
                string9 = roseNode4.getValue();
                if ((string9 = string9.substring(1, string9.length() - 1)).equals("Interface")) {
                    type = Type.INTERFACE;
                } else if (string9.equals("primitive")) {
                    type = Type.PRIMITIVE;
                } else if (string9.equals("enumeration")) {
                    type = Type.ENUMERATION;
                } else if (string9.equals("structure")) {
                    type = Type.STRUCTURE;
                }
            }
            if ((string9 = roseNode.getRoseId()) != null) {
                string9 = string9.substring(1, string9.length() - 1);
                TableObject tableObject = new TableObject(string3, string9, this.xmiBaseFileName, this.xmiFileName, RoseUtil.getUUID(roseNode), type, this.getParentUUID(roseNode), "false");
                RoseUtil.quid_InfoTable.put(string9, tableObject);
                RoseUtil.uuid_InfoTable.put(tableObject.getUUID(), tableObject);
                RoseUtil.className_InfoTable.put(string3, tableObject);
                RoseUtil.classFullName_InfoTable.put(this.getFullName(roseNode), tableObject);
                roseNode.setNode(tableObject.getUUID());
            }
            this.traverse(roseNode, unitTreeNode);
        } else if (string2.equals("Operation") || string2.equals("ClassAttribute") || string2.equals("Inheritance_Relationship") || string2.equals("Association") || string2.equals("Role") || string2.equals("Visibility_Relationship") || string2.equals("Uses_Relationship")) {
            Type type = null;
            if (string2.equals("Operation")) {
                type = Type.OPERATION;
            } else if (string2.equals("ClassAttribute")) {
                type = Type.ATTRIBUTE;
            } else if (string2.equals("Inheritance_Relationship")) {
                type = Type.GENERALIZATION;
            } else if (string2.equals("Association")) {
                type = Type.ASSOCIATION;
            } else if (string2.equals("Role")) {
                type = Type.ASSOCIATION_END;
            } else if (string2.equals("Visibility_Relationship") || string2.equals("Uses_Relationship")) {
                type = Type.DEPENDENCY;
            }
            String string10 = roseNode.getRoseId();
            if (string10 != null) {
                String string11;
                string10 = string10.substring(1, string10.length() - 1);
                String string12 = RoseUtil.getUUID(roseNode);
                if (type == Type.GENERALIZATION && RoseUtil.bNamespaceUUID) {
                    string12 = string12 + "/" + "Generalization" + "/" + string10;
                }
                TableObject tableObject = new TableObject(string3, string10, this.xmiBaseFileName, this.xmiFileName, string12, type, this.getParentUUID(roseNode), "false");
                RoseUtil.quid_InfoTable.put(string10, tableObject);
                RoseUtil.uuid_InfoTable.put(tableObject.getUUID(), tableObject);
                roseNode.setNode(tableObject.getUUID());
                if ((string2.equals("Inheritance_Relationship") || string2.equals("Role") || string2.equals("Uses_Relationship") || string2.equals("Visibility_Relationship")) && (string11 = roseNode.getRoseRefId()) != null) {
                    if (RoseUtil.supplier_LinkTable.containsKey(string11 = string11.substring(1, string11.length() - 1))) {
                        Vector vector = (Vector)RoseUtil.supplier_LinkTable.get(string11);
                        vector.addElement(tableObject.getUUID());
                    } else {
                        Vector<String> vector = new Vector<String>();
                        vector.addElement(tableObject.getUUID());
                        RoseUtil.supplier_LinkTable.put(string11, vector);
                    }
                }
            }
            this.traverse(roseNode, unitTreeNode);
        } else if (string.equals("properties") && string2.equals("Properties") && RoseUtil.bForCB) {
            RoseUtil.processDefaultProperties(roseNode);
        }
    }
}

