/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.rb30;

import com.ibm.psh.rb30.ResourceUtil;
import com.ibm.xmi.uml.BadIdException;
import com.ibm.xmi.uml.DuplicateException;
import com.ibm.xmi.uml.Id;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.Type;
import com.ibm.xmi.uml.UML;
import com.ibm.xmi.xmi10.IDLUtil;
import java.util.Vector;

public class ModelElements {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void add(Id id, Link link, Id id2) {
        try {
            id.add(link, id2);
        }
        catch (Exception exception) {
            System.out.println(exception + " thrown from add function for link:  " + link.toString());
        }
    }

    public static Id addConstruct(Id id, Type type) {
        try {
            Id id2 = id.add(type, "");
            return id2;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static Id addConstruct(Id id, Type type, String string) {
        try {
            if (type == Type.EXTENSION) {
                Id id2 = ModelElements.addConstruct(id, type);
                if (id2 != null) {
                    ModelElements.set(id2, Property.EXTENSION_NAME, string);
                }
                return id2;
            }
            if (type == Type.ENUMERATION_LITERAL) {
                Id id3 = ModelElements.addConstruct(id, type);
                if (id3 != null) {
                    ModelElements.set(id3, Property.EL_NAME, string);
                }
                return id3;
            }
            Id id4 = id.add(type, string);
            return id4;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static Id create(Type type) {
        try {
            Id id = UML.instance().create(type);
            return id;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static Id create(UML uML, Type type) {
        try {
            Id id = uML.create(type);
            return id;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static void delete(Id id) {
        try {
            id.delete();
        }
        catch (BadIdException badIdException) {
        }
        catch (Exception exception) {
            System.out.println(exception + " thrown from delete function for model element id");
        }
    }

    public static void delete(Id id, Link link, Id id2) {
        try {
            id.delete(link, id2);
        }
        catch (Exception exception) {
            System.out.println(exception + " thrown from delete function for link");
        }
    }

    public static Vector get(Id id, Link link, boolean bl) {
        try {
            return id.get(link, bl);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static String get(Id id, Property property) {
        try {
            return id.get(property);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static Vector get(Id id, Type type, Vector vector, boolean bl) {
        try {
            return id.get(type, vector, bl);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static Vector get(Id id, Type type, boolean bl) {
        try {
            return id.get(type, bl);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static String get(Id id, String string) {
        try {
            return id.get(string);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static String get(Id id, String string, String string2) {
        try {
            return id.get(string, string2);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static Id getDataTypeId(Id id, String string) {
        return ModelElements.getDataTypeId(id, string, true);
    }

    public static Id getDataTypeId(Id id, String string, boolean bl) {
        Id id2 = null;
        IDLUtil iDLUtil = IDLUtil.instance();
        if (id == iDLUtil.getIDLDatatypePackage()) {
            id2 = iDLUtil.getIdFromType(string);
        }
        if (id2 == null && bl) {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(Property.NAME);
            vector.addElement(string);
            Vector vector2 = ModelElements.get(id, Type.PRIMITIVE, vector, false);
            if (vector2 == null) {
                id2 = ModelElements.addConstruct(id, Type.PRIMITIVE, string);
            } else if (vector2.size() == 1) {
                id2 = (Id)vector2.elementAt(0);
            }
        }
        return id2;
    }

    public static String getJavaFullName(Id id) {
        Vector vector = ModelElements.get(id, Link.NAMESPACE, false);
        String string = ModelElements.get(id, Property.NAME);
        while (vector != null) {
            Id id2 = null;
            if (vector.size() == 1) {
                id2 = (Id)vector.elementAt(0);
                if (id2.getType() == Type.MODEL) {
                    vector = null;
                    continue;
                }
                string = ModelElements.get(id2, Property.NAME) + "." + string;
                vector = ModelElements.get(id2, Link.NAMESPACE, false);
                continue;
            }
            vector = null;
        }
        return string;
    }

    public static Vector getLinks(Id id) {
        try {
            return id.getLinks();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static String getName(Id id) {
        Property property = id.getType() == Type.EXTENSION ? Property.EXTENSION_NAME : (id.getType() == Type.ENUMERATION_LITERAL ? Property.EL_NAME : Property.NAME);
        return ModelElements.get(id, property);
    }

    public static Vector getParameters(Id id) {
        Vector vector = ModelElements.get(id, Type.PARAMETER, false);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Id id2 = (Id)vector.elementAt(i);
                String string = ModelElements.get(id2, Property.PA_KIND);
                if (string == null || !string.equals("return")) continue;
                vector.removeElementAt(i);
            }
        }
        return vector;
    }

    public static Vector getProperties(Id id) {
        try {
            return id.getProperties();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static String getRoseSupplierName(Id id) {
        Vector vector = ModelElements.get(id, Link.NAMESPACE, false);
        String string = ModelElements.get(id, Property.NAME);
        while (vector != null) {
            Id id2 = null;
            if (vector.size() == 1) {
                id2 = (Id)vector.elementAt(0);
                if (id2.getType() == Type.MODEL) {
                    vector = null;
                    continue;
                }
                string = ModelElements.get(id2, Property.NAME) + "::" + string;
                vector = ModelElements.get(id2, Link.NAMESPACE, false);
                continue;
            }
            vector = null;
        }
        return ResourceUtil.getString("LOGICAL_VIEW") + "::" + string;
    }

    public static Vector getSets(Id id) {
        try {
            return id.getSets();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static Vector getTags(Id id, String string) {
        try {
            return id.getTags(string);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public static void set(Id id, Property property, String string) {
        try {
            id.set(property, string);
        }
        catch (Exception exception) {
            System.out.println(exception + " thrown from set function for property: " + property + " and value: " + string);
        }
    }

    public static void set(Id id, String string, String string2, String string3) {
        try {
            id.set(string, string2, string3);
        }
        catch (Exception exception) {
            System.out.println(exception + " thrown from set function for tag-value pair in set: " + string);
        }
    }

    public static void setComplicatedProperty(Id id, Property property, String string) {
        UML uML = UML.instance();
        try {
            Id id2 = uML.create(property.getType());
            ModelElements.set(id2, Property.EXPRESSION_BODY, string);
            ModelElements.add(id, property.getLink(), id2);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void setComplicatedProperty(UML uML, Id id, Property property, String string) {
        try {
            Id id2 = uML.create(property.getType());
            ModelElements.set(id2, Property.EXPRESSION_BODY, string);
            ModelElements.add(id, property.getLink(), id2);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void setUUID(Id id, String string) {
        try {
            id.setUUID(string);
        }
        catch (DuplicateException duplicateException) {
        }
        catch (Exception exception) {
            System.out.println(exception + " thrown from setUUID function");
        }
    }
}

