/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.psh.diffmerge;

import com.ibm.psh.diffmerge.UMLHashValue;
import com.ibm.psh.rb30.ModelElements;
import com.ibm.xmi.uml.Id;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.Type;
import java.util.Vector;

public class IdInfo {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999,2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int NO_CHANGE = 1;
    public static final int UPDATE = 2;
    public static final int ADD = 3;
    public static final int DELETE = 4;
    private Id id;
    private long localHashValue;
    private long globalHashValue;
    private long propsHashValue;
    private long defaultSetHashValue;
    private long setsHashValue;
    private long linksHashValue;
    private int status;
    private boolean bVisited;
    private IdInfo refIdInfo;
    private IdInfo parent;
    private Vector nodes;

    public IdInfo(Id id) {
        this.id = id;
        this.localHashValue = 0L;
        this.globalHashValue = 0L;
        this.propsHashValue = 0L;
        this.defaultSetHashValue = 0L;
        this.setsHashValue = 0L;
        this.linksHashValue = 0L;
        this.status = 1;
        this.bVisited = false;
        this.parent = null;
        this.nodes = new Vector();
        this.calculateLocalHashValue();
    }

    public IdInfo(Id id, long l, long l2, long l3, long l4, long l5, long l6, int n, boolean bl) {
        this.id = id;
        this.localHashValue = l;
        this.globalHashValue = l2;
        this.propsHashValue = l3;
        this.defaultSetHashValue = l4;
        this.setsHashValue = l5;
        this.linksHashValue = l6;
        this.status = n;
        this.bVisited = bl;
        this.parent = null;
        this.nodes = new Vector();
    }

    public void addNode(IdInfo idInfo) {
        idInfo.parent = this;
        this.nodes.addElement(idInfo);
    }

    public void calculateDefaultSetHashValue() {
        Vector vector;
        if (this.defaultSetHashValue != 0L) {
            this.defaultSetHashValue = 0L;
        }
        if ((vector = ModelElements.getTags(this.id, "")) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                this.defaultSetHashValue += (long)string.hashCode();
                String string2 = ModelElements.get(this.id, "", string);
                if (string2 == null) continue;
                this.defaultSetHashValue += (long)string2.hashCode();
            }
        }
    }

    public void calculateGlobalHashValue() {
        if (this.globalHashValue == 0L) {
            if (this.nodes.size() != 0) {
                IdInfo idInfo;
                int n;
                for (n = 0; n < this.nodes.size(); ++n) {
                    idInfo = (IdInfo)this.nodes.elementAt(n);
                    idInfo.calculateGlobalHashValue();
                }
                for (n = 0; n < this.nodes.size(); ++n) {
                    idInfo = (IdInfo)this.nodes.elementAt(n);
                    this.globalHashValue += idInfo.getGlobalHashValue();
                }
                this.globalHashValue += this.localHashValue;
            } else {
                this.globalHashValue = this.localHashValue;
            }
        }
    }

    public void calculateLinksHashValue() {
        Vector vector;
        if (this.linksHashValue != 0L) {
            this.linksHashValue = 0L;
        }
        if ((vector = ModelElements.getLinks(this.id)) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Link link = (Link)vector.elementAt(i);
                this.linksHashValue += (long)UMLHashValue.getUMLHashValueFromLink(link);
                Vector vector2 = ModelElements.get(this.id, link, false);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    Id id = (Id)vector2.elementAt(j);
                    String string = null;
                    try {
                        this.linksHashValue += (long)UMLHashValue.getUMLHashValueFromType(id.getType());
                        string = id.getType() == Type.EXPRESSION ? id.get(Property.EXPRESSION_BODY) : id.get(Property.NAME);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string == null) continue;
                    this.linksHashValue += (long)string.hashCode();
                }
            }
        }
    }

    public void calculateLocalHashValue() {
        this.localHashValue += (long)UMLHashValue.getUMLHashValueFromType(this.id.getType());
        this.calculatePropertiesHashValue();
        this.calculateDefaultSetHashValue();
        this.calculateSetsHashValue();
        this.calculateLinksHashValue();
        this.localHashValue = this.localHashValue + this.propsHashValue + this.defaultSetHashValue + this.setsHashValue + this.linksHashValue;
    }

    public void calculatePropertiesHashValue() {
        Vector vector;
        if (this.propsHashValue != 0L) {
            this.propsHashValue = 0L;
        }
        if ((vector = ModelElements.getProperties(this.id)) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Property property = (Property)vector.elementAt(i);
                this.propsHashValue += (long)UMLHashValue.getUMLHashValueFromProperty(property);
                String string = ModelElements.get(this.id, property);
                if (string == null) continue;
                this.propsHashValue += (long)string.hashCode();
            }
        }
    }

    public void calculateSetsHashValue() {
        Vector vector;
        if (this.setsHashValue != 0L) {
            this.setsHashValue = 0L;
        }
        if ((vector = ModelElements.getSets(this.id)) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                this.setsHashValue += (long)string.hashCode();
                Vector vector2 = ModelElements.getTags(this.id, string);
                if (vector2 == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    String string2 = (String)vector2.elementAt(j);
                    if (!string2.equals("uuid")) {
                        this.setsHashValue += (long)string2.hashCode();
                        String string3 = ModelElements.get(this.id, string, string2);
                        if (string3 == null) continue;
                        this.setsHashValue += (long)string3.hashCode();
                        continue;
                    }
                    if (!string.equals("IDL") || vector2.size() != 1) continue;
                    this.setsHashValue -= (long)string.hashCode();
                }
            }
        }
    }

    public long getDefaultSetHashValue() {
        return this.defaultSetHashValue;
    }

    public long getGlobalHashValue() {
        return this.globalHashValue;
    }

    public Id getId() {
        return this.id;
    }

    public long getLinksHashValue() {
        return this.linksHashValue;
    }

    public long getLocalHashValue() {
        return this.localHashValue;
    }

    public Vector getNodes() {
        return this.nodes;
    }

    public IdInfo getParent() {
        return this.parent;
    }

    public long getPropertiesHashValue() {
        return this.propsHashValue;
    }

    public Id getReferenceId() {
        return this.refIdInfo.getId();
    }

    public IdInfo getReferenceIdInfo() {
        return this.refIdInfo;
    }

    public long getSetsHashValue() {
        return this.setsHashValue;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isBeingVisited() {
        return this.bVisited;
    }

    public void setChildrenStatusToDelete() {
        if (this.nodes.size() > 0) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                IdInfo idInfo = (IdInfo)this.nodes.elementAt(i);
                if (!idInfo.isBeingVisited()) {
                    idInfo.visited(true);
                }
                idInfo.setStatus(4);
                idInfo.setChildrenStatusToDelete();
            }
        }
    }

    public void setChildrenVisitedToTrue() {
        if (this.nodes.size() > 0) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                IdInfo idInfo = (IdInfo)this.nodes.elementAt(i);
                if (!idInfo.isBeingVisited()) {
                    idInfo.visited(true);
                }
                idInfo.setChildrenVisitedToTrue();
            }
        }
    }

    public void setId(Id id) {
        this.id = id;
    }

    public void setReferenceIdInfo(IdInfo idInfo) {
        this.refIdInfo = idInfo;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void visited(boolean bl) {
        this.bVisited = bl;
    }
}

