/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.validation.war;

import com.ibm.etools.j2ee.common.EnvEntry;
import com.ibm.etools.j2ee.common.JNDIEnvRefsGroup;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.etools.j2ee.common.SecurityRoleRef;
import com.ibm.etools.j2ee.common.impl.EJBLocalRefImpl;
import com.ibm.etools.j2ee.common.impl.EjbRefImpl;
import com.ibm.etools.j2ee.common.impl.ResourceRefImpl;
import com.ibm.etools.j2ee.commonarchivecore.EARFile;
import com.ibm.etools.j2ee.commonarchivecore.WARFile;
import com.ibm.etools.j2ee.validation.J2EEValidator;
import com.ibm.etools.j2ee.validation.war.WARMessageConstants;
import com.ibm.etools.j2ee.validation.war.WARValidationResourceHandler;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.Message;
import com.ibm.etools.validation.ValidationException;
import com.ibm.etools.webapplication.AuthConstraint;
import com.ibm.etools.webapplication.ContextParam;
import com.ibm.etools.webapplication.ErrorCodeErrorPage;
import com.ibm.etools.webapplication.ErrorPage;
import com.ibm.etools.webapplication.ExceptionTypeErrorPage;
import com.ibm.etools.webapplication.Filter;
import com.ibm.etools.webapplication.FilterMapping;
import com.ibm.etools.webapplication.FormLoginConfig;
import com.ibm.etools.webapplication.HTTPMethodType;
import com.ibm.etools.webapplication.InitParam;
import com.ibm.etools.webapplication.JSPType;
import com.ibm.etools.webapplication.LoginConfig;
import com.ibm.etools.webapplication.MimeMapping;
import com.ibm.etools.webapplication.SecurityConstraint;
import com.ibm.etools.webapplication.Servlet;
import com.ibm.etools.webapplication.ServletMapping;
import com.ibm.etools.webapplication.SessionConfig;
import com.ibm.etools.webapplication.TagLibRef;
import com.ibm.etools.webapplication.TransportGuaranteeType;
import com.ibm.etools.webapplication.UserDataConstraint;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.etools.webapplication.WebResourceCollection;
import com.ibm.etools.webapplication.WelcomeFile;
import com.ibm.etools.webapplication.WelcomeFileList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.java.impl.JavaClassImpl;

public class WarValidator
extends J2EEValidator
implements WARMessageConstants {
    protected WARFile warFile;
    protected WebApp webDD;
    private Hashtable httpMethods = null;

    public boolean checkIfValidFileForIncValidation(IFileDelta changedFile) {
        String fileName = changedFile.getFileName();
        return fileName.endsWith("xml") || fileName.endsWith("jsp") || fileName.endsWith("html") || fileName.endsWith("java");
    }

    public Hashtable getAndValidateSecurityRoles(EList roles) {
        Hashtable<String, String> secRoles = new Hashtable<String, String>();
        if (roles.isEmpty()) {
            return secRoles;
        }
        Iterator sRoles = roles.iterator();
        while (sRoles.hasNext()) {
            String[] parms;
            SecurityRole role = (SecurityRole)sRoles.next();
            String name = role.getRoleName();
            if (name != null) {
                name = name.trim();
            }
            if (name == null || name.equals("")) {
                parms = new String[]{WARValidationResourceHandler.getString("of_Type_Security_Role_Name_6")};
                this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, role);
                continue;
            }
            if (secRoles.get(name) != null) {
                parms = new String[]{name};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, role);
                continue;
            }
            secRoles.put(name, "Yea");
        }
        return secRoles;
    }

    public String getBaseName() {
        return "warvalidation";
    }

    public String getName() {
        return WARValidationResourceHandler.getString("Web_Archive_Validator_8");
    }

    public String getName(Locale locale) {
        return this.getMessage(null, "webArchiveValidator.name", locale);
    }

    protected boolean isHttpMethod(String method) {
        String compare;
        if (this.httpMethods == null) {
            String[] mList = new String[]{"GET", "PUT", "HEAD", "TRACE", "POST", "DELETE", "OPTIONS", "PROPFIND", "PROPPATCH", "MKCOL", "LOCK", "UNLOCK", "COPY", "MOVE", "ACL", "SEARCH", "CHECKOUT", "CHECKIN", "UNCHECKOUT", "VERSION-CONTROL", "REPORT", "MERGE", "BASELINE-CONTROL", "MK-ACTIVITY"};
            this.httpMethods = new Hashtable();
            int i = 0;
            while (i < mList.length) {
                this.httpMethods.put(mList[i], "bla");
                ++i;
            }
        }
        return this.httpMethods.get(compare = method.trim()) != null;
    }

    public void validate() throws ValidationException {
        this.validateMimeMapping();
        this.validateContextParameters();
        this.validateTagLibs();
        this.validateServletMappings(this.webDD.getServletMappings());
        this.validateWelcomeFileList(this.webDD.getFileList());
        this.validateErrorPages(this.webDD.getErrorPages());
        this.validateSecurityAndServlets();
        this.validateFilters(this.webDD.getFilters());
        this.validateFilterMappings(this.webDD.getFilterMappings());
        this.validateRefs();
        this.validateLoginConfig(this.webDD.getLoginConfig());
        this.validateEnvironmentEntries(this.webDD.getEnvEntries());
        this.validateOther();
        this.validate14();
    }

    private void validate14() {
        int versionId = this.webDD.getVersionID();
        if (versionId == 24) {
            this.validateUrlPattern();
        }
    }

    private void validateUrlPattern() {
        EList servletMappings = this.webDD.getServletMappings();
        int i = 0;
        while (i < servletMappings.size()) {
            ServletMapping mapping = (ServletMapping)servletMappings.get(i);
            String urlPattern = mapping.getUrlPattern();
            int newLineChar = urlPattern.indexOf(13);
            if (newLineChar != -1) {
                String[] parms = new String[]{urlPattern, mapping.getServlet().getDisplayName()};
                this.addError("warvalidation", "MESSAGE_URL_PATTERN_END_WITH_CARRAIGE_RETURN", parms, mapping);
            }
            ++i;
        }
    }

    public void validate(IHelper inHelper, IReporter inReporter, IFileDelta[] inChangedFiles) throws ValidationException {
        super.validate(inHelper, inReporter, inChangedFiles);
        this._reporter.removeAllMessages(this, null);
        try {
            this.warFile = (WARFile)this._helper.loadModel("WAR_VALIDATION");
            if (this.warFile == null) {
                Message errorMsg = new Message(this.getBaseName(), 1, "ERROR_INVALID_WAR_FILE");
                throw new ValidationException(errorMsg);
            }
            this.webDD = this.warFile.getDeploymentDescriptor();
            this.validate();
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (Exception e) {
            String[] parms = new String[]{e.toString()};
            Message errorMsg = new Message(this.getBaseName(), 1, "ERROR_WAR_VALIDATION_FAILED", parms);
            throw new ValidationException(errorMsg, (Throwable)e);
        }
    }

    public void validate(Object aWarFile) throws ValidationException {
        try {
            this.warFile = (WARFile)aWarFile;
            this.webDD = this.warFile.getDeploymentDescriptor();
            this.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
            String[] parms = new String[]{e.toString()};
            Message errorMsg = new Message(this.getBaseName(), 1, "ERROR_WAR_VALIDATION_FAILED", parms);
            throw new ValidationException(errorMsg);
        }
    }

    public void validateAuthConstraint(AuthConstraint authConstraint, Hashtable secRoles) {
        EList roleList = authConstraint.getRoles();
        if (roleList != null && !roleList.isEmpty()) {
            Iterator authRoles = roleList.iterator();
            Hashtable<String, String> remember = new Hashtable<String, String>();
            while (authRoles.hasNext()) {
                String[] parms;
                String role = (String)authRoles.next();
                if (role == null || role.trim().equals("")) {
                    parms = new String[]{WARValidationResourceHandler.getString("of_Type_Role_Name_19")};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, authConstraint);
                    continue;
                }
                if (remember.get(role.trim()) != null) {
                    parms = new String[]{role};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, authConstraint);
                    continue;
                }
                remember.put(role.trim(), "Yea");
                this.validateAuthSecRole("", role, secRoles, authConstraint);
            }
        }
    }

    public void validateContextParameters() {
        Hashtable<String, String> remember = new Hashtable<String, String>();
        Iterator cparams = this.webDD.getContexts().iterator();
        while (cparams.hasNext()) {
            String[] parms;
            ContextParam context = (ContextParam)cparams.next();
            String name = context.getParamName();
            if (name != null) {
                name = name.trim();
            }
            if (name == null || name.equals("")) {
                parms = new String[]{WARValidationResourceHandler.getString("of_Type_Parameter_Name_25")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, context);
                continue;
            }
            if (remember.get(name) != null) {
                parms = new String[]{String.valueOf(WARValidationResourceHandler.getString("of_Type_Parameter_Name_25")) + ": " + name};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, context);
                continue;
            }
            remember.put(name, "Yea");
        }
        Iterator servlets = this.webDD.getServlets().iterator();
        while (servlets.hasNext()) {
            Servlet nextServlet = (Servlet)servlets.next();
            Iterator params = nextServlet.getParams().iterator();
            remember.clear();
            while (params.hasNext()) {
                String[] parms;
                InitParam initParam = (InitParam)params.next();
                String name = initParam.getParamName();
                if (name != null) {
                    name = name.trim();
                }
                if (name == null || name.equals("")) {
                    parms = new String[]{WARValidationResourceHandler.getString("of_Type_Parameter_Name_32")};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, initParam);
                    continue;
                }
                if (remember.get(name) != null) {
                    parms = new String[]{String.valueOf(WARValidationResourceHandler.getString("of_Type_Parameter_Name_25")) + ": " + name};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, initParam);
                    continue;
                }
                remember.put(name, "Yea");
            }
        }
        Iterator filters = this.webDD.getFilters().iterator();
        while (filters.hasNext()) {
            Filter nextFilter = (Filter)filters.next();
            Iterator params = nextFilter.getInitParams().iterator();
            remember.clear();
            while (params.hasNext()) {
                String[] parms;
                InitParam initParam = (InitParam)params.next();
                String name = initParam.getParamName();
                if (name != null) {
                    name = name.trim();
                }
                if (name == null || name.equals("")) {
                    parms = new String[]{WARValidationResourceHandler.getString("of_Type_Parameter_Name_39")};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, initParam);
                    continue;
                }
                if (remember.get(name) != null) {
                    parms = new String[]{String.valueOf(WARValidationResourceHandler.getString("of_Type_Parameter_Name_25")) + ": " + name};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, initParam);
                    continue;
                }
                remember.put(name, "Yea");
            }
        }
    }

    public void validateEJBRefs(EjbRefImpl eref) {
        EARFile earFile = this.warFile.getEARFile();
        JNDIEnvRefsGroup eb = null;
        if (earFile != null) {
            eb = earFile.getEnterpiseBeanFromRef(eref, this.warFile.getURI());
        }
        if (eb != null) {
            EList ejbRefs = eb.getEjbRefs();
            int numRefs = ejbRefs.size();
            HashSet<String> refSet = new HashSet<String>(numRefs);
            int refNo = 0;
            while (refNo < numRefs) {
                String nextName = ((EjbRefImpl)ejbRefs.get(refNo)).getName();
                String[] parms = new String[]{eb.getName()};
                if (!refSet.add(nextName)) {
                    this.addWarning("warvalidation", "ERROR_EAR_DUPLICATE_ROLES", parms, (EjbRefImpl)ejbRefs.get(refNo));
                }
                ++refNo;
            }
        }
    }

    public void validateEJBRefs(List ejbRefs) {
        int numRefs = ejbRefs.size();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        int refNo = 0;
        while (refNo < numRefs) {
            block4: {
                String name;
                EjbRefImpl eref;
                block5: {
                    block2: {
                        String[] parms;
                        block3: {
                            String type;
                            eref = (EjbRefImpl)ejbRefs.get(refNo);
                            if (eref.isSetType() && (type = eref.getType().getName()) == null) {
                                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_EJB_REF_TYPE", null, eref);
                            }
                            if (eref.getName() == null) break block2;
                            name = eref.getName();
                            if (!(name = name.trim()).equals("")) break block3;
                            parms = new String[]{WARValidationResourceHandler.getString("of_Type_ejb-ref-name_44")};
                            this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, eref);
                            break block4;
                        }
                        if (remember.get(name) == null) break block5;
                        parms = new String[]{name};
                        this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_EJB_REF", parms, eref);
                        break block4;
                    }
                    String[] parms = new String[]{WARValidationResourceHandler.getString("of_Type_ejb-ref-name_44")};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, eref);
                    break block4;
                }
                remember.put(name, "Yea");
                this.validateEJBRefs(eref);
                this.validateEJBRefManadatoryElements(eref, this.webDD.getDisplayName());
            }
            ++refNo;
        }
    }

    public void validateEJBLocalRefs(List ejbRefs) {
        int numRefs = ejbRefs.size();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        int refNo = 0;
        while (refNo < numRefs) {
            String type;
            EJBLocalRefImpl eref = (EJBLocalRefImpl)ejbRefs.get(refNo);
            if (eref.isSetType() && (type = eref.getType().getName()) == null) {
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_EJB_REF_TYPE", null, eref);
            }
            if (eref.getName() != null) {
                String[] parms;
                String name = eref.getName();
                if ((name = name.trim()).equals("")) {
                    parms = new String[]{WARValidationResourceHandler.getString("of_Type_ejb-ref-name_44")};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, eref);
                } else if (remember.get(name) != null) {
                    parms = new String[]{name};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_EJB_REF", parms, eref);
                } else {
                    remember.put(name, "Yea");
                }
            } else {
                String[] parms = new String[]{WARValidationResourceHandler.getString("of_Type_ejb-ref-name_44")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, eref);
            }
            ++refNo;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void validateErrorPages(EList errorPageList) {
        errorPages = errorPageList.iterator();
        if (errorPageList != null && !errorPageList.isEmpty()) ** GOTO lbl41
        return;
lbl-1000:
        // 1 sources

        {
            nextPage = (ErrorPage)errorPages.next();
            location = nextPage.getLocation();
            if (location == null || location.equals("")) {
                parms = new String[]{WARValidationResourceHandler.getString("of_Type_Error_Location_47")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, nextPage);
            }
            if (!location.startsWith("/")) {
                parms = new String[]{WARValidationResourceHandler.getString("of_Type_Error_Location_49")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_ERROR_PAGE", parms, nextPage);
            }
            if (nextPage.isErrorCode()) {
                ecep = (ErrorCodeErrorPage)nextPage;
                errorCode = ecep.getErrorCode();
                valid = false;
                if (errorCode.length() == 3) {
                    try {
                        tempInt = new Integer(errorCode);
                        code = tempInt;
                        if (code >= 100 && code < 600) {
                            valid = true;
                        }
                    }
                    catch (NumberFormatException v0) {}
                }
                if (valid) continue;
                parms = new String[]{errorCode};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_ERROR_CODE", parms, ecep);
                continue;
            }
            if (!nextPage.isExceptionType()) continue;
            etep = (ExceptionTypeErrorPage)nextPage;
            javaType = etep.getExceptionType();
            exceptionType = "java.lang.Exception";
            specifiedClassName = etep.getExceptionTypeName();
            if (javaType != null) {
                lookupSet = javaType.eResource().getResourceSet();
                if (lookupSet == null || javaType.inheritsFrom(JavaClassImpl.reflect(exceptionType, lookupSet).getWrapper())) continue;
                parms = new String[]{specifiedClassName};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_EXCEPTION_TYPE", parms, etep);
                continue;
            }
            parms = new String[]{""};
            this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_EXCEPTION_TYPE", parms, etep);
lbl41:
            // 7 sources

            ** while (errorPages.hasNext())
        }
lbl42:
        // 1 sources

    }

    public void validateLoginConfig(LoginConfig loginConfig) {
        if (loginConfig != null) {
            FormLoginConfig cfg;
            String auth = loginConfig.getAuthMethod().getName();
            if (auth == null) {
                String[] parms = new String[]{};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_AUTH_METHOD", parms, loginConfig);
            } else if (!auth.equals("FORM") && (cfg = loginConfig.getFormLoginConfig()) != null) {
                String[] parms = new String[]{auth};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_IGNORE_FORM_LOGIN", parms, loginConfig);
            }
        }
    }

    public void validateEnvironmentEntries(EList envEntries) {
        if (envEntries.isEmpty()) {
            return;
        }
        Iterator entries = envEntries.iterator();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        while (entries.hasNext()) {
            String name;
            EnvEntry entry = (EnvEntry)entries.next();
            if (entry.getType().getName() == null) {
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_ENV_ENTRY", null, entry);
            }
            if ((name = entry.getName()) == null) continue;
            if (remember.get(name) != null) {
                String[] parms = new String[]{String.valueOf(WARValidationResourceHandler.getString("of_Type_Env_Entry_Name___88")) + ": " + name};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, entry);
                continue;
            }
            remember.put(name, "Yea");
        }
    }

    public void validateMimeMapping() {
        if (this.webDD.getMimeMappings().isEmpty()) {
            return;
        }
        Iterator mimes = this.webDD.getMimeMappings().iterator();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        while (mimes.hasNext()) {
            String[] parms;
            MimeMapping mimeMap = (MimeMapping)mimes.next();
            String ext = mimeMap.getExtension();
            String mtype = mimeMap.getMimeType();
            if (ext != null) {
                ext = ext.trim();
            }
            if (mtype != null) {
                mtype = mtype.trim();
            }
            if (ext == null || ext.equals("") || mtype == null || mtype.equals("")) {
                parms = new String[]{ext == null || ext.trim().equals("") ? WARValidationResourceHandler.getString("of_Type_Mime_Extension_54") : WARValidationResourceHandler.getString("of_Type_Mime_Type_55")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, mimeMap);
                continue;
            }
            if (remember.get(ext) != null) {
                parms = new String[]{String.valueOf(WARValidationResourceHandler.getString("of_Type_Mime_Extension___56")) + ": " + ext};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, mimeMap);
                continue;
            }
            remember.put(ext, "Yea");
        }
    }

    public void validateOther() {
        int timeout;
        SessionConfig sessionCfg = this.webDD.getSessionConfig();
        if (sessionCfg != null && (timeout = sessionCfg.getSessionTimeout()) == 0) {
            this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_SESSION_TIMEOUT", null, sessionCfg);
        }
    }

    public void validateRefs() {
        EList resourceRefs;
        EList ejblocalRefs;
        EList ejbRefs = this.webDD.getEjbRefs();
        if (!ejbRefs.isEmpty()) {
            this.validateEJBRefs((List)ejbRefs);
        }
        if (!(ejblocalRefs = this.webDD.getEjbLocalRefs()).isEmpty()) {
            this.validateEJBLocalRefs((List)ejblocalRefs);
        }
        if (!(resourceRefs = this.webDD.getResourceRefs()).isEmpty()) {
            int numRefs = resourceRefs.size();
            HashSet<String> refSet = new HashSet<String>(numRefs);
            boolean isVersion22 = this.warFile.getDeploymentDescriptor().getVersionID() <= 22;
            int refNo = 0;
            while (refNo < numRefs) {
                String[] parms;
                ResourceRefImpl ref = (ResourceRefImpl)resourceRefs.get(refNo);
                String auth = ref.getAuth().getName();
                if (auth == null || !ref.isSetAuth()) {
                    parms = new String[]{ref.getName()};
                    String msgId = isVersion22 ? "MESSAGE_WAR_VALIDATION_RES_AUTH_REQUIRED_22" : "MESSAGE_WAR_VALIDATION_RES_AUTH_REQUIRED_23";
                    this.addError("warvalidation", msgId, parms, ref);
                } else if (isVersion22 && auth.equals("Application")) {
                    parms = new String[]{ref.getName()};
                    this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_RES_AUTH_INVALID_22", parms, ref);
                } else if (!isVersion22 && auth.equals("SERVLET")) {
                    parms = new String[]{ref.getName()};
                    this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_RES_AUTH_INVALID_23", parms, ref);
                }
                String sharingScope = ref.getResSharingScope().getName();
                if (!(isVersion22 || sharingScope != null && ref.isSetResSharingScope())) {
                    String[] parms2 = new String[]{};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_RES_SHARING_SCOPE", parms2, ref);
                }
                String refName = ref.getName();
                String[] parms3 = new String[]{refName};
                if (!refSet.add(refName)) {
                    this.addError("erefvalidation", "ERROR_EAR_DUPLICATE_RESREF", parms3, ref);
                }
                ++refNo;
            }
        }
    }

    protected void validateAuthSecRole(String link, String role, Hashtable definedRoles, EObject targetObject) {
        String rName = role;
        String lName = link;
        if (rName != null) {
            rName = rName.trim();
        }
        if (lName != null) {
            lName = lName.trim();
        }
        if (rName != null && !rName.equals("*") && !rName.equals("") && definedRoles.get(rName) == null && definedRoles.get(lName) == null) {
            String[] parms = new String[]{rName};
            this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_SEC_ROLE_NAME", parms, targetObject);
        }
    }

    protected void validateSecRole(String link, String role, Hashtable definedRoles, EObject targetObject) {
        String[] parms;
        String rName = role;
        String lName = link;
        if (rName != null) {
            rName = rName.trim();
        }
        if (lName != null) {
            lName = lName.trim();
        }
        if (rName == null || rName.equals("")) {
            parms = new String[]{rName};
            this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_SEC_ROLE_NAME", parms, targetObject);
        }
        if (!(rName != null && rName.equals("*") || lName == null || definedRoles.get(lName) != null)) {
            parms = new String[]{lName};
            this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_SEC_ROLE", parms, targetObject);
        }
    }

    public void validateSecurityAndServlets() {
        EARFile module;
        EList webRoles = this.webDD.getSecurityRoles();
        Hashtable secRoles = this.getAndValidateSecurityRoles(webRoles);
        this.validateServlets(this.webDD.getServlets(), secRoles);
        this.validateSecurityConstraints(this.webDD.getConstraints(), secRoles);
        if (!webRoles.isEmpty() && (module = this.warFile.getEARFile()) != null) {
            EList earRoleList = module.getDeploymentDescriptor().getSecurityRoles();
            this.validateWEBRolesWithEARRoles(earRoleList, webRoles);
        }
    }

    public void validateSecurityConstraints(EList constraints, Hashtable secRoles) {
        if (constraints.isEmpty()) {
            return;
        }
        Iterator constList = constraints.iterator();
        while (constList.hasNext()) {
            TransportGuaranteeType transport;
            UserDataConstraint dataConstraint;
            SecurityConstraint constraint = (SecurityConstraint)constList.next();
            EList webResourceList = constraint.getWebResourceCollections();
            if (webResourceList == null || webResourceList.isEmpty()) {
                String[] parms = new String[]{WARValidationResourceHandler.getString("of_Type_Web_Resource_Collection_64")};
                this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, constraint);
                continue;
            }
            this.validateWebResourceCollections(webResourceList);
            AuthConstraint authConstraint = constraint.getAuthConstraint();
            if (authConstraint != null) {
                this.validateAuthConstraint(authConstraint, secRoles);
            }
            if ((dataConstraint = constraint.getUserDataConstraint()) == null || dataConstraint.getTransportGuarantee() == null || (transport = dataConstraint.getTransportGuarantee()) != null && dataConstraint.isSetTransportGuarantee()) continue;
            this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_TRANSPORT", new String[0], dataConstraint);
        }
    }

    public void validateFilters(EList filterList) {
        if (filterList.isEmpty()) {
            return;
        }
        Iterator filters = filterList.iterator();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        while (filters.hasNext()) {
            String[] parms;
            Filter nextFilter = (Filter)filters.next();
            String name = nextFilter.getName();
            if (name != null) {
                name = name.trim();
            }
            if (name == null || name.equals("")) {
                parms = new String[]{WARValidationResourceHandler.getString("of_Type_Filter_Name_66")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, nextFilter);
                continue;
            }
            if (remember.get(name) != null) {
                parms = new String[]{name};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_FILTER", parms, nextFilter);
                continue;
            }
            remember.put(name, "Yea");
        }
    }

    public void validateFilterMappings(EList filterMappingsList) {
        if (filterMappingsList.isEmpty()) {
            return;
        }
        Iterator filterMappings = filterMappingsList.iterator();
        while (filterMappings.hasNext()) {
            String[] parms;
            FilterMapping nextMapping = (FilterMapping)filterMappings.next();
            if (nextMapping.getUrlPattern() != null) {
                String url = nextMapping.getUrlPattern();
                parms = new String[]{url};
                if (url == null) {
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_URL", parms, nextMapping);
                    continue;
                }
                if (nextMapping.getFilter() == null || nextMapping.getFilter().equals("")) {
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_BROKEN_FILTER_MAPPING", parms, nextMapping);
                    continue;
                }
                try {
                    if (!url.equals("")) continue;
                    throw new Exception(WARValidationResourceHandler.getString("Invalid_URL_70"));
                }
                catch (Exception exception) {
                    parms = new String[]{nextMapping.getUrlPattern()};
                    this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_URL", parms, nextMapping);
                }
                continue;
            }
            if (nextMapping.getServletName() == null) continue;
            String servletName = nextMapping.getServletName();
            parms = new String[]{servletName};
            if (nextMapping.getServlet() == null) {
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_BROKEN_SERVLET_MAPPING", parms, nextMapping);
                continue;
            }
            if (nextMapping.getFilter() != null && !nextMapping.getFilter().equals("")) continue;
            this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_BROKEN_FILTER_MAPPING", parms, nextMapping);
        }
    }

    public void validateServletMappings(EList servletMappingsList) {
        if (servletMappingsList.isEmpty()) {
            return;
        }
        Iterator servletMappings = servletMappingsList.iterator();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        while (servletMappings.hasNext()) {
            String[] parms;
            ServletMapping nextMapping = (ServletMapping)servletMappings.next();
            String url = nextMapping.getUrlPattern();
            if (url != null) {
                if (remember.get(url = url.trim()) != null) {
                    parms = new String[]{nextMapping.getUrlPattern()};
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_MAPPING", parms, nextMapping);
                    continue;
                }
                remember.put(nextMapping.getUrlPattern(), "Yea");
            }
            if (url == null || nextMapping.getServlet() == null || nextMapping.getServlet().equals("")) {
                parms = new String[]{url};
                if (url == null) {
                    this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_URL", parms, nextMapping);
                    continue;
                }
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_BROKEN_SERVLET_MAPPING", parms, nextMapping);
                continue;
            }
            try {
                if (!url.equals("")) continue;
                throw new Exception(WARValidationResourceHandler.getString("Invalid_URL_75"));
            }
            catch (Exception exception) {
                parms = new String[]{nextMapping.getUrlPattern()};
                this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_URL", parms, nextMapping);
            }
        }
    }

    public void validateServlets(EList servletList, Hashtable secRoles) {
        if (servletList.isEmpty()) {
            return;
        }
        Iterator servlets = servletList.iterator();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        while (servlets.hasNext()) {
            JSPType jspType;
            String jspFileName;
            String[] parms;
            Servlet nextServlet = (Servlet)servlets.next();
            String name = nextServlet.getServletName();
            if (name != null) {
                name = name.trim();
            }
            if (name == null || name.equals("")) {
                parms = new String[]{WARValidationResourceHandler.getString("of_Type_Servlet_Name_77")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, nextServlet);
                continue;
            }
            if (remember.get(name) != null) {
                parms = new String[]{name};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_SERVLET", parms, nextServlet);
                continue;
            }
            remember.put(name, "Yea");
            EList rolesList = nextServlet.getSecurityRoleRefs();
            if (!rolesList.isEmpty()) {
                Iterator roles = rolesList.iterator();
                while (roles.hasNext()) {
                    SecurityRoleRef role = (SecurityRoleRef)roles.next();
                    this.validateSecRole(role.getLink(), role.getName(), secRoles, role);
                }
            }
            if (!nextServlet.getWebType().isJspType() || (jspFileName = (jspType = (JSPType)nextServlet.getWebType()).getJspFile()) != null && jspFileName.length() > 0) continue;
            String[] parms2 = new String[]{jspFileName, name};
            this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_JSPFILE_REF", parms2, nextServlet);
        }
    }

    public void validateTagLibs() {
        if (this.webDD.getTagLibs().isEmpty()) {
            return;
        }
        Iterator tags = this.webDD.getTagLibs().iterator();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        while (tags.hasNext()) {
            String[] parms;
            TagLibRef taglib = (TagLibRef)tags.next();
            String uri = taglib.getTaglibURI();
            if (uri != null) {
                uri = uri.trim();
            }
            if (uri == null || uri.equals("")) {
                parms = new String[]{WARValidationResourceHandler.getString("of_Type_Taglib_80")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, taglib);
                continue;
            }
            if (remember.get(uri) != null) {
                parms = new String[]{String.valueOf(WARValidationResourceHandler.getString("of_Type_TagLib___81")) + ": " + uri};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, taglib);
                continue;
            }
            remember.put(uri, "Yea");
        }
    }

    public void validateWebResourceCollections(EList webResourceList) {
        Iterator resourceList = webResourceList.iterator();
        while (resourceList.hasNext()) {
            EList httpList;
            WebResourceCollection resource = (WebResourceCollection)resourceList.next();
            String name = resource.getWebResourceName();
            if (name != null) {
                name = name.trim();
            }
            if (name == null || name.equals("")) {
                String[] parms = new String[]{WARValidationResourceHandler.getString("of_Type_Web_Resource_Name_84")};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, resource);
            }
            if ((httpList = resource.getHTTPs()).isEmpty()) continue;
            Iterator https = httpList.iterator();
            while (https.hasNext()) {
                HTTPMethodType httpMethod = (HTTPMethodType)https.next();
                String method = httpMethod.getHttpMethod();
                if (method != null && this.isHttpMethod(method)) continue;
                String[] parms = new String[]{method};
                this.addError("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_HTTP_CMD", parms, httpMethod);
            }
        }
    }

    public void validateWelcomeFileList(WelcomeFileList fileList) {
        if (fileList == null) {
            return;
        }
        Iterator files = fileList.getFile().iterator();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        while (files.hasNext()) {
            String[] parms;
            WelcomeFile nextFile = (WelcomeFile)files.next();
            String fileName = nextFile.getWelcomeFile();
            if (fileName == null || fileName.length() == 0) {
                parms = new String[]{};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_NO_WELCOME_FILE", parms, nextFile);
            } else if (fileName.startsWith("/") || fileName.endsWith("/")) {
                parms = new String[]{};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_WELCOME_FILE", parms, nextFile);
            }
            fileName = fileName.trim();
            if (remember.get(fileName) != null) {
                parms = new String[]{String.valueOf(WARValidationResourceHandler.getString("of_Type_Welcome_File_Name__87")) + ": " + fileName};
                this.addWarning("warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, nextFile);
                continue;
            }
            remember.put(fileName, "Yea");
        }
    }
}

