/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl;

import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EjbPackage;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.Entity;
import com.ibm.etools.ejb.MessageDriven;
import com.ibm.etools.j2ee.validation.IValidationContext;
import com.ibm.etools.j2ee.validation.ValidationCancelledException;
import com.ibm.etools.j2ee.validation.ejb.AValidationRule;
import com.ibm.etools.j2ee.validation.ejb.IValidationRule;
import com.ibm.etools.j2ee.validation.ejb.IValidationRuleList;
import com.ibm.etools.j2ee.validation.ejb.InvalidInputException;
import com.ibm.etools.j2ee.validation.ejb.MessageUtility;
import com.ibm.etools.j2ee.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.j2ee.validation.ejb.ejb20rules.impl.IMessagePrefixEjb20Constants;
import com.ibm.etools.validation.IMessage;
import com.ibm.etools.validation.MessageLimitException;
import com.ibm.etools.validation.ValidationException;
import com.ibm.wtp.common.logger.LogEntry;
import com.ibm.wtp.common.logger.proxy.Logger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.java.JavaClass;

public class EJBExt20VRule
extends AValidationRule
implements IMessagePrefixEjb20Constants {
    private static final Map MESSAGE_IDS;
    private static final Object[] DEPENDS_ON;

    static {
        DEPENDS_ON = new Object[]{IValidationRuleList.EJB20_STATELESS_SESSION_BEANCLASS, IValidationRuleList.EJB20_STATELESS_SESSION_REMOTE, IValidationRuleList.EJB20_STATELESS_SESSION_HOME, IValidationRuleList.EJB20_STATELESS_SESSION_LOCAL, IValidationRuleList.EJB20_STATELESS_SESSION_LOCALHOME, IValidationRuleList.EJB20_STATEFUL_SESSION_BEANCLASS, IValidationRuleList.EJB20_STATEFUL_SESSION_REMOTE, IValidationRuleList.EJB20_STATEFUL_SESSION_HOME, IValidationRuleList.EJB20_STATEFUL_SESSION_LOCAL, IValidationRuleList.EJB20_STATEFUL_SESSION_LOCALHOME, IValidationRuleList.EJB20_CMP_BEANCLASS, IValidationRuleList.EJB20_CMP_REMOTE, IValidationRuleList.EJB20_CMP_HOME, IValidationRuleList.EJB20_CMP_LOCAL, IValidationRuleList.EJB20_CMP_LOCALHOME, IValidationRuleList.EJB20_CMP_KEYCLASS, IValidationRuleList.EJB20_BMP_BEANCLASS, IValidationRuleList.EJB20_BMP_REMOTE, IValidationRuleList.EJB20_BMP_HOME, IValidationRuleList.EJB20_BMP_LOCAL, IValidationRuleList.EJB20_BMP_LOCALHOME, IValidationRuleList.EJB20_BMP_KEYCLASS, IValidationRuleList.EJB20_MESSAGE_BEANCLASS, IValidationRuleList.EJB20_EJBJAR};
        MESSAGE_IDS = new HashMap();
        MESSAGE_IDS.put("CHKJ2106", new String[]{"CHKJ2106.ejb20"});
        MESSAGE_IDS.put("CHKJ2849", new String[]{"CHKJ2849.ejb20"});
        MESSAGE_IDS.put("CHKJ2852", new String[]{"CHKJ2852"});
    }

    public Object[] getDependsOn() {
        return DEPENDS_ON;
    }

    public Object getId() {
        return IValidationRuleList.EJB20_EJBEXT;
    }

    public Map getMessageIds() {
        return MESSAGE_IDS;
    }

    public Object getTarget(Object parent, Object clazz) {
        return null;
    }

    public boolean areBeanComponentsReflected(EnterpriseBean bean) {
        try {
            ValidationRuleUtility.isValidTypeHierarchy(bean, bean.getEjbClass());
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        if (bean instanceof MessageDriven) {
            return true;
        }
        try {
            if (bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_HomeInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(bean, bean.getHomeInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        try {
            if (bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_RemoteInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(bean, bean.getRemoteInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        try {
            if (bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_LocalHomeInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(bean, bean.getLocalHomeInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        try {
            if (bean.eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEnterpriseBean_LocalInterface())) {
                ValidationRuleUtility.isValidTypeHierarchy(bean, bean.getLocalInterface());
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        if (bean.isEntity()) {
            JavaClass primaryKey = ((Entity)bean).getPrimaryKey();
            try {
                if (((Entity)bean).eIsSet((EStructuralFeature)EjbPackage.eINSTANCE.getEntity_PrimaryKey())) {
                    ValidationRuleUtility.isValidTypeHierarchy(bean, primaryKey);
                }
            }
            catch (InvalidInputException invalidInputException) {
                return false;
            }
        }
        return true;
    }

    public void validate(IValidationContext vc, Object targetParent, Object target) throws ValidationCancelledException, ValidationException {
        Logger logger = vc.getMsgLogger();
        if (logger != null && logger.isLoggingLevel(Level.FINEST)) {
            LogEntry entry = vc.getLogEntry();
            entry.setSourceID("EJB20Validator - validate");
            entry.setText(String.valueOf(this.getClass().getName()) + "::validate(" + targetParent + ", " + target);
            logger.write(Level.FINEST, entry);
        }
        EJBJar ejbJar = null;
        if (targetParent == null) {
            ejbJar = (EJBJar)target;
            this.validate(vc, ejbJar);
        } else {
            ejbJar = (EJBJar)vc.loadModel("EJB_MODEL");
            EnterpriseBean bean = (EnterpriseBean)targetParent;
            this.validate(vc, ejbJar, bean);
        }
    }

    public void validate(IValidationContext vc, EJBJar ejbJar) throws ValidationCancelledException, ValidationException {
        EList enterpriseBeans = ejbJar.getEnterpriseBeans();
        Iterator iterator = enterpriseBeans.iterator();
        EnterpriseBean bean = null;
        while (iterator.hasNext()) {
            bean = (EnterpriseBean)iterator.next();
            if (bean == null) continue;
            this.validate(vc, ejbJar, bean);
        }
    }

    public void validate(IValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) throws ValidationCancelledException, ValidationException {
        block6: {
            try {
                if (!this.areBeanComponentsReflected(bean)) {
                    return;
                }
                this.validateAppendixB(vc, ejbJar, bean);
            }
            catch (MessageLimitException e) {
                throw e;
            }
            catch (ValidationCancelledException e) {
                throw e;
            }
            catch (Throwable exc) {
                String superTypeName = this.getEJBInheritanceFileName();
                if (superTypeName == null) {
                    superTypeName = "unknown super type";
                }
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2852", 2, bean, new String[]{superTypeName, bean.getName()}, (IValidationRule)this);
                vc.addMessage(message);
                Logger logger = vc.getMsgLogger();
                if (logger == null || !logger.isLoggingLevel(Level.SEVERE)) break block6;
                logger.write(Level.SEVERE, exc);
            }
        }
    }

    protected void validateAppendixB(IValidationContext vc, EJBJar ejbJar, EnterpriseBean bean) {
        if (bean == null) {
            return;
        }
        if (!bean.isEntity()) {
            return;
        }
        JavaClass thisKey = ((Entity)bean).getPrimaryKey();
        EnterpriseBean supertype = this.getSuperType(bean);
        JavaClass parentKey = null;
        if (supertype != null && supertype instanceof Entity) {
            parentKey = ((Entity)supertype).getPrimaryKey();
            if (thisKey == null || parentKey == null || !thisKey.equals(parentKey)) {
                String[] msgParm = new String[]{bean.getName(), parentKey.getQualifiedName()};
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2106", 1, bean, msgParm, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }
}

