/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl;

import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.Entity;
import com.ibm.etools.j2ee.validation.IValidationContext;
import com.ibm.etools.j2ee.validation.ejb.IValidationRule;
import com.ibm.etools.j2ee.validation.ejb.InvalidInputException;
import com.ibm.etools.j2ee.validation.ejb.MessageUtility;
import com.ibm.etools.j2ee.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl.AValidateHome;
import com.ibm.etools.validation.IMessage;
import java.util.HashSet;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;

public abstract class AValidateEntityHome
extends AValidateHome {
    private HashSet findByPKMethods = new HashSet();

    public void reset() {
        super.reset();
        this.findByPKMethods.clear();
    }

    protected void incrementFindByPrimaryKeyCount(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) {
        if (method == null) {
            return;
        }
        if (method.getName().equals("findByPrimaryKey")) {
            this.findByPKMethods.add(method);
        }
    }

    public boolean isSingleObjectFinder(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return false;
        }
        JavaClass remoteIntf = bean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, remoteIntf);
        return ValidationRuleUtility.isAssignableFrom(method.getReturnType(), remoteIntf);
    }

    public void primValidate(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method hiMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        String name = hiMethod.getName();
        if (name.equals("create")) {
            this.validateCreateMethod(vc, bean, clazz, hiMethod);
        } else if (name.startsWith("find")) {
            this.validateFindMethod(vc, bean, clazz, hiMethod);
        } else {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2005", 1, bean, clazz, hiMethod, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void primValidateExistence(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method ejbMethod) throws InvalidInputException {
        if ("findByPrimaryKey".equals(ejbMethod.getName())) {
            this.incrementFindByPrimaryKeyCount(vc, bean, clazz, ejbMethod);
        }
    }

    public void validateClass(IValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        super.validateClass(vc, bean, clazz);
    }

    public void validateCreateMethod(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        this.validateCreateMethod_beanDep(vc, bean, clazz, method);
        vc.terminateIfCancelled();
        this.validateCreateMethod_remoteDep(vc, bean, clazz, method);
        if (!ValidationRuleUtility.throwsCreateException(bean, method)) {
            String[] msgParm = new String[]{"javax.ejb.CreateException"};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2414", 1, bean, clazz, method, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateLegalRMIMethod(vc, bean, clazz, method);
    }

    public void validateCreateMethod_beanDep(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        super.validateCreateMethod_beanDep(vc, bean, clazz, method);
        this.validateMatchingBeanPostCreateMethod(vc, bean, clazz, method);
    }

    public void validateFindByPrimaryKeyMethod_keyDep(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        boolean hasValidFBPKMethod = false;
        Entity entityBean = (Entity)bean;
        JavaClass keyClass = entityBean.getPrimaryKey();
        ValidationRuleUtility.isValidTypeHierarchy(bean, keyClass);
        vc.terminateIfCancelled();
        JavaParameter[] parms = method.listParametersWithoutReturn();
        if (parms.length == 1) {
            JavaHelpers type = parms[0].getJavaType();
            if (ValidationRuleUtility.isAssignableFrom(type, keyClass)) {
                if (this.isSingleObjectFinder(vc, bean, clazz, method)) {
                    hasValidFBPKMethod = true;
                }
            } else if (ValidationRuleUtility.isSameType(type, ValidationRuleUtility.getType("java.lang.Object", entityBean))) {
                hasValidFBPKMethod = true;
            }
        }
        if (!hasValidFBPKMethod) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2405", 2, bean, clazz, method, new String[]{keyClass.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateFindByPrimaryKeyMethod_remoteDep(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (!this.isSingleObjectFinder(vc, bean, clazz, method)) {
            String remoteIntfName = bean.getRemoteInterface().getName();
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2403", 2, bean, clazz, method, new String[]{remoteIntfName}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateFindMethod(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        JavaHelpers retType;
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        this.validateFindMethod_remoteDep(vc, bean, clazz, method);
        if (!ValidationRuleUtility.throwsFinderException(bean, method)) {
            String[] msgParm = new String[]{"javax.ejb.FinderException"};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2414", 1, bean, clazz, method, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
        boolean validateRMIParameters = true;
        boolean validateRMIRetType = true;
        if (method.getName().equals("findByPrimaryKey")) {
            this.validateFindByPrimaryKeyMethod_keyDep(vc, bean, clazz, method);
            if (ValidationRuleUtility.usesUnknownPrimaryKey(bean)) {
                validateRMIParameters = false;
            }
        }
        boolean bl = validateRMIRetType = !ValidationRuleUtility.isAssignableFrom(retType = method.getReturnType(), ValidationRuleUtility.getType("java.util.Enumeration", bean)) && !ValidationRuleUtility.isAssignableFrom(retType, ValidationRuleUtility.getType("java.util.Collection", bean));
        if (validateRMIParameters) {
            this.validateLegalRMIMethodArguments(vc, bean, clazz, method);
        }
        if (validateRMIRetType) {
            this.validateLegalRMIMethodReturnType(vc, bean, clazz, method);
        }
        this.validateLegalRMIMethodExceptions(vc, bean, clazz, method);
    }

    public void validateFindMethod_remoteDep(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        JavaHelpers returnType;
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        JavaClass remoteIntf = bean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, remoteIntf);
        if (!(method.getName().equals("findByPrimaryKey") || ValidationRuleUtility.isAssignableFromCollection(returnType = method.getReturnType(), bean) || ValidationRuleUtility.isAssignableFromEnumeration(returnType, bean) || ValidationRuleUtility.isAssignableFrom(returnType, remoteIntf))) {
            String[] msgParm = new String[]{remoteIntf.getName()};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2403", 2, bean, clazz, method, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (method.getName().equals("findByPrimaryKey")) {
            this.validateFindByPrimaryKeyMethod_remoteDep(vc, bean, clazz, method);
        }
    }

    public void validateMatchingBeanCreateMethod(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        super.validateMatchingBeanCreateMethod(vc, bean, clazz, method);
        JavaClass beanClass = bean.getEjbClass();
        Method ejbCreateMethod = ValidationRuleUtility.getMethodExtended(beanClass, method, "ejbCreate");
        if (ejbCreateMethod == null) {
            return;
        }
    }

    public void validateMatchingBeanFindMethod(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method homeMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (homeMethod == null) {
            return;
        }
        String findMethodName = "ejbF" + homeMethod.getName().substring(1);
        JavaClass beanClass = bean.getEjbClass();
        ValidationRuleUtility.isValidTypeHierarchy(bean, beanClass);
        Method beanMethod = ValidationRuleUtility.getMethodExtended(beanClass, homeMethod, findMethodName);
        if (beanMethod == null) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2030", 1, bean, clazz, homeMethod, new String[]{beanClass.getName()}, (IValidationRule)this);
            vc.addMessage(message);
            return;
        }
        vc.terminateIfCancelled();
        JavaHelpers homeRetType = homeMethod.getReturnType();
        JavaHelpers beanRetType = beanMethod.getReturnType();
        if (!ValidationRuleUtility.isAssignableFrom(homeRetType, beanRetType)) {
            boolean homeRetTypeIsRemote = ValidationRuleUtility.isAssignableFrom(homeRetType, bean.getRemoteInterface());
            boolean beanRetTypeIsKey = ValidationRuleUtility.isAssignableFrom(beanRetType, ((Entity)bean).getPrimaryKey());
            if (!homeRetTypeIsRemote || !beanRetTypeIsKey) {
                JavaHelpers retType = beanRetTypeIsKey ? bean.getRemoteInterface() : beanRetType;
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2415", 1, bean, clazz, homeMethod, new String[]{retType.getJavaName(), beanClass.getName()}, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    public void validateMatchingBeanPostCreateMethod(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method homeMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (homeMethod == null) {
            return;
        }
        JavaClass beanClass = bean.getEjbClass();
        ValidationRuleUtility.isValidTypeHierarchy(bean, beanClass);
        Method beanMethod = ValidationRuleUtility.getMethodExtended(beanClass, homeMethod, "ejbPostCreate");
        if (beanMethod == null) {
            return;
        }
    }

    protected void validateMethodExists(IValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        if (this.findByPKMethods.size() == 0) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2011", 1, bean, clazz, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }
}

