/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl;

import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.j2ee.validation.IValidationContext;
import com.ibm.etools.j2ee.validation.ejb.IValidationRule;
import com.ibm.etools.j2ee.validation.ejb.InvalidInputException;
import com.ibm.etools.j2ee.validation.ejb.MessageUtility;
import com.ibm.etools.j2ee.validation.ejb.ValidationRuleUtility;
import com.ibm.etools.j2ee.validation.ejb.ejb11rules.impl.AValidateEJB;
import com.ibm.etools.validation.IMessage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;

public abstract class AValidateBean
extends AValidateEJB {
    protected HashSet componentParents = new HashSet();

    public void reset() {
        super.reset();
        this.componentParents.clear();
    }

    protected void buildComponentParents(EnterpriseBean bean) {
        JavaClass parentEjbObject;
        if (bean == null) {
            return;
        }
        EnterpriseBean supertype = this.getSuperType(bean);
        if (supertype == null) {
            return;
        }
        JavaClass thisEjbObject = bean.getEjbClass();
        if (ValidationRuleUtility.isAssignableFrom(thisEjbObject, parentEjbObject = supertype.getEjbClass())) {
            this.componentParents.add(parentEjbObject);
        }
        this.buildComponentParents(supertype);
    }

    public final Object getTarget(Object parent, Object clazz) {
        if (parent == null) {
            return null;
        }
        return ((EnterpriseBean)parent).getEjbClass();
    }

    public static final List getRemoteHomeMethodsExtended(List[] methodsExtendedList) {
        return methodsExtendedList[0];
    }

    public static final List getRemoteComponentMethodsExtended(List[] methodsExtendedList) {
        return methodsExtendedList[1];
    }

    public static final List getBeanClassMethodsExtended(List[] methodsExtendedList) {
        return methodsExtendedList[2];
    }

    public final List[] getMethodsExtended(IValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        List[] result = new List[3];
        JavaClass remoteHome = bean.getHomeInterface();
        result[0] = remoteHome != null ? remoteHome.getMethodsExtended() : null;
        JavaClass remoteComponent = bean.getRemoteInterface();
        result[1] = remoteComponent != null ? remoteComponent.getMethodsExtended() : null;
        JavaClass beanClass = bean.getEjbClass();
        result[2] = beanClass != null ? beanClass.getMethodsExtended() : null;
        return result;
    }

    public final List[] getFieldsExtended(IValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        return null;
    }

    public final Method getMatchingHomeCreateMethod(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return null;
        }
        if (bean == null) {
            return null;
        }
        JavaClass homeIntf = bean.getHomeInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, homeIntf);
        return ValidationRuleUtility.getMethod(method, "create", (List)homeIntf.getMethods());
    }

    public Method getMatchingHomeCreateMethodExtended(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return null;
        }
        if (bean == null) {
            return null;
        }
        JavaClass homeIntf = bean.getHomeInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, homeIntf);
        return ValidationRuleUtility.getMethodExtended(homeIntf, method, "create");
    }

    protected abstract String getParentName();

    public boolean isBusinessMethod(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return false;
        }
        String name = method.getName();
        if (this.isFrameworkMethod(name)) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        if (bean == null) {
            return false;
        }
        JavaClass remoteInterface = bean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, remoteInterface);
        Method remoteInterfaceMethod = ValidationRuleUtility.getMethodExtended(remoteInterface, name, method.listParametersWithoutReturn());
        return remoteInterfaceMethod != null && !ValidationRuleUtility.isEJBObjectMethod(bean, remoteInterfaceMethod);
    }

    protected boolean isComponentInherited(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method meth) throws InvalidInputException {
        if (this.componentParents == null) {
            return false;
        }
        return this.componentParents.contains(meth.getContainingJavaClass());
    }

    public boolean isFrameworkMethod(String name) {
        if (name == null) {
            return false;
        }
        if (name.equals("ejbActivate")) {
            return true;
        }
        if (name.equals("ejbPassivate")) {
            return true;
        }
        if (name.equals("ejbRemove")) {
            return true;
        }
        if (name.startsWith("ejbFind")) {
            return true;
        }
        if (name.equals("ejbCreate")) {
            return true;
        }
        if (name.equals("ejbPostCreate")) {
            return true;
        }
        return name.equals("finalize");
    }

    protected boolean isValid(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field, List[] fieldsExtendedList) throws InvalidInputException {
        if (super.isValid(vc, bean, clazz, field, fieldsExtendedList)) {
            return !ValidationRuleUtility.isJavaLangObjectField(bean, field);
        }
        return false;
    }

    protected final boolean isValid(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedList) throws InvalidInputException {
        if (super.isValid(vc, bean, clazz, method, methodsExtendedList)) {
            if (ValidationRuleUtility.isJavaLangObjectMethod(bean, method)) {
                return false;
            }
            if (method.getName().equals("ejbCreate")) {
                return this.isValidEjbCreateMethod(vc, bean, clazz, method, methodsExtendedList);
            }
            if (method.getName().equals("ejbPostCreate")) {
                return this.isValidEjbCreateMethod(vc, bean, clazz, method, methodsExtendedList);
            }
            return true;
        }
        return false;
    }

    protected final boolean isValidEjbCreateMethod(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method meth, List[] methodsExtendedLists) throws InvalidInputException {
        Method homeMeth;
        boolean isValid = true;
        boolean isComp = this.isComponentInherited(vc, bean, clazz, meth);
        if (isComp && (homeMeth = this.getMatchingHomeCreateMethod(vc, bean, clazz, meth, methodsExtendedLists)) == null) {
            isValid = false;
        }
        return isValid;
    }

    public void primValidate(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field) throws InvalidInputException {
        vc.terminateIfCancelled();
        this.validateStaticField(vc, bean, clazz, field);
    }

    public void validateBusinessMethod(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        if (method.getName().startsWith("ejb")) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2411", 1, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        JavaClass remote = bean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, remote);
        Method remoteMethod = ValidationRuleUtility.getMethodExtended(remote, method, method.getName());
        if (remoteMethod == null) {
            return;
        }
        Set exceptions = ValidationRuleUtility.getNotSubsetExceptions(bean, method, remoteMethod);
        if (exceptions.size() > 0) {
            Iterator iterator = exceptions.iterator();
            while (iterator.hasNext()) {
                JavaClass exc = (JavaClass)iterator.next();
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2432", 1, bean, clazz, method, new String[]{remote.getQualifiedName(), exc.getQualifiedName()}, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
        this.validateMatchingMethodExceptions(vc, bean, clazz, method, bean.getRemoteInterface(), remoteMethod);
    }

    public void validateClass(IValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        IMessage message;
        vc.terminateIfCancelled();
        this.buildComponentParents(bean);
        if (!ValidationRuleUtility.isAssignableFrom(clazz, ValidationRuleUtility.getType(this.getParentName(), bean))) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2013", 1, bean, clazz, new String[]{clazz.getQualifiedName(), this.getParentName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!clazz.isPublic()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2022", 1, bean, clazz, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (clazz.isAbstract()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2014", 1, bean, clazz, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (clazz.isFinal()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2015", 1, bean, clazz, new String[]{clazz.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (ValidationRuleUtility.isUnnamedPackage(clazz.getJavaPackage())) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2041", 4, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateAppendixB(vc, bean, clazz);
    }

    public void validateEjbCreateMethod_homeDep(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        Method createMethod = this.getMatchingHomeCreateMethodExtended(vc, bean, clazz, method);
        if (createMethod == null) {
            return;
        }
        Set exceptions = ValidationRuleUtility.getNotSubsetExceptions(bean, method, createMethod);
        if (exceptions.size() > 0) {
            Iterator iterator = exceptions.iterator();
            while (iterator.hasNext()) {
                JavaClass exc = (JavaClass)iterator.next();
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2420", 1, bean, clazz, method, new String[]{exc.getQualifiedName(), bean.getHomeInterface().getQualifiedName()}, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }

    public void validateHelperMethod(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) {
    }

    public void validateNoRemoteException(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method, String messagePrefix) throws InvalidInputException {
        if (method == null) {
            return;
        }
        if (!ValidationRuleUtility.doesNotThrowRemoteException(bean, method)) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)messagePrefix, 2, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateStaticField(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Field field) throws InvalidInputException {
        if (field == null) {
            return;
        }
        if (field.isStatic() && !field.isFinal()) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2200", 2, bean, clazz, field, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateMatchingMethodExceptions(IValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method, JavaClass matchingClazz, Method matchingMethod) {
        Set exceptions = ValidationRuleUtility.getNotSubsetSubtypeExceptions(bean, matchingMethod, method);
        Iterator eiterator = exceptions.iterator();
        while (eiterator.hasNext()) {
            JavaClass exception = (JavaClass)eiterator.next();
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2456", 2, bean, clazz, method, new String[]{exception.getJavaName(), matchingClazz.getJavaName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    protected void validateAppendixB(IValidationContext vc, EnterpriseBean bean, JavaClass thisEjbObject) {
        if (bean == null) {
            return;
        }
        EnterpriseBean supertype = this.getSuperType(bean);
        JavaClass parentEjbObject = null;
        if (supertype != null) {
            parentEjbObject = supertype.getEjbClass();
            try {
                ValidationRuleUtility.isValidType(thisEjbObject);
                ValidationRuleUtility.isValidType(parentEjbObject);
                if (!ValidationRuleUtility.isAssignableFrom(thisEjbObject, parentEjbObject)) {
                    String[] msgParm = new String[]{thisEjbObject.getQualifiedName(), parentEjbObject.getQualifiedName()};
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2103", 1, bean, thisEjbObject, msgParm, (IValidationRule)this);
                    vc.addMessage(message);
                }
            }
            catch (InvalidInputException e) {
                String[] msgParm = new String[]{e.getJavaClass().getQualifiedName(), bean.getName()};
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2849", 2, bean, msgParm, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }
}

