/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.validation.applicationclient;

import com.ibm.etools.client.ApplicationClient;
import com.ibm.etools.j2ee.commonarchivecore.ApplicationClientFile;
import com.ibm.etools.j2ee.commonarchivecore.command.ValidateXmlCommand;
import com.ibm.etools.j2ee.validation.J2EEValidator;
import com.ibm.etools.j2ee.validation.applicationclient.ApplicationClientMessageConstants;
import com.ibm.etools.validation.IFileDelta;
import com.ibm.etools.validation.IHelper;
import com.ibm.etools.validation.IReporter;
import com.ibm.etools.validation.Message;
import com.ibm.etools.validation.ValidationException;
import org.eclipse.emf.common.command.Command;

public class ApplicationClientValidator
extends J2EEValidator
implements ApplicationClientMessageConstants {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected ApplicationClientFile appClientFile;
    protected ApplicationClient appClientDD;

    public String getBaseName() {
        return "applicationclientvalidation";
    }

    public void validate() throws ValidationException {
        this.validateMainClassInManifest();
    }

    protected void validateMainClassInManifest() {
        String mainClass;
        if (this.appClientFile != null && this.appClientFile.getManifest() != null && ((mainClass = this.appClientFile.getManifest().getMainClass()) == null || mainClass.length() == 0)) {
            Object target = this.getManifestTarget();
            this.addError(this.getBaseName(), "APPCLIENT_MAIN_CLASS_ERROR_", new String[0], target);
        }
    }

    protected Object getManifestTarget() {
        return null;
    }

    public void validate(IHelper inHelper, IReporter inReporter, IFileDelta[] changedFiles) throws ValidationException {
        super.validate(inHelper, inReporter, changedFiles);
        try {
            this.setAppClientFile((ApplicationClientFile)inHelper.loadModel("APPLICATIONCLIENT_VALIDATION"));
            if (this.appClientFile == null) {
                Message errorMsg = new Message(this.getBaseName(), 1, "ERROR_APPLICATIONCLIENT_INVALID_APPCLIENT_FILE");
                throw new ValidationException(errorMsg);
            }
            this.setAppClientDD(this.appClientFile.getDeploymentDescriptor());
            this.validate();
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (Exception e) {
            Message errorMsg = new Message(this.getBaseName(), 1, "ERROR_APPCLIENT_VALIDATION_FAILED");
            throw new ValidationException(errorMsg, (Throwable)e);
        }
    }

    public Command createValidateXMLCommand() {
        ValidateXmlCommand cmd = new ValidateXmlCommand(this.appClientFile);
        return cmd;
    }

    public ApplicationClientFile getAppClientFile() {
        return this.appClientFile;
    }

    public void setAppClientFile(ApplicationClientFile appClientFile) {
        this.appClientFile = appClientFile;
    }

    public ApplicationClient getAppClientDD() {
        return this.appClientDD;
    }

    public void setAppClientDD(ApplicationClient appClientDD) {
        this.appClientDD = appClientDD;
    }
}

