/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commonarchivecore.strategy;

import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.File;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.exception.SaveFailureException;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveManifest;
import com.ibm.etools.j2ee.commonarchivecore.helpers.FileIterator;
import com.ibm.etools.j2ee.commonarchivecore.helpers.SaveFilter;
import com.ibm.etools.j2ee.commonarchivecore.helpers.SaveFilterImpl;
import com.ibm.etools.j2ee.commonarchivecore.nls.CommonArchiveResourceHandler;
import com.ibm.etools.j2ee.commonarchivecore.strategy.ArchiveStrategyImpl;
import com.ibm.etools.j2ee.commonarchivecore.strategy.SaveStrategy;
import com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil;
import com.ibm.wtp.emf.resource.CompatibilityXMIResource;
import com.ibm.wtp.emf.xml.TranslatorResource;
import com.ibm.wtp.internal.emf.utilities.Revisit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public abstract class SaveStrategyImpl
extends ArchiveStrategyImpl
implements SaveStrategy {
    protected SaveFilter filter;

    public void close() throws IOException {
    }

    protected abstract SaveStrategy createNestedSaveStrategy(Archive var1) throws IOException;

    public void finish() throws IOException {
    }

    public SaveFilter getFilter() {
        if (this.filter == null) {
            this.filter = new SaveFilterImpl();
        }
        return this.filter;
    }

    protected abstract OutputStream getOutputStreamForResource(Resource var1) throws IOException;

    public boolean isDirectory() {
        return false;
    }

    protected boolean isLoadedResourceOrManifest(File aFile) {
        return this.getArchive().isMofResourceLoaded(aFile.getURI()) || aFile.getURI().equals("META-INF/MANIFEST.MF");
    }

    public void save() throws SaveFailureException {
        this.saveManifest();
        this.saveMofResources();
        this.saveFiles();
    }

    public void save(Archive anArchive) throws SaveFailureException {
        SaveStrategy strat = null;
        try {
            strat = this.createNestedSaveStrategy(anArchive);
        }
        catch (IOException iox) {
            throw new SaveFailureException(anArchive.getURI(), iox);
        }
        anArchive.save(strat);
    }

    public void save(File aFile, FileIterator iterator) throws SaveFailureException {
        if (aFile.isArchive() && this.shouldIterateOver((Archive)aFile)) {
            this.save((Archive)aFile);
        } else {
            InputStream in = null;
            if (!aFile.isDirectoryEntry()) {
                try {
                    in = iterator.getInputStream(aFile);
                }
                catch (IOException ex) {
                    throw new SaveFailureException(aFile.getURI(), ex);
                }
            }
            this.save(aFile, in);
        }
    }

    public abstract void save(File var1, InputStream var2) throws SaveFailureException;

    protected void saveFiles() throws SaveFailureException {
        try {
            FileIterator iterator = this.getArchive().getFilesForSave();
            while (iterator.hasNext()) {
                File aFile = iterator.next();
                if (!this.shouldSave(aFile)) continue;
                this.save(aFile, iterator);
            }
        }
        catch (IOException iox) {
            throw new SaveFailureException(CommonArchiveResourceHandler.getString("Error_occurred_iterating_f_EXC_"), iox);
        }
    }

    protected void saveManifest() throws SaveFailureException {
        if (!this.shouldSave("META-INF/MANIFEST.MF")) {
            return;
        }
        ArchiveManifest mf = this.getArchive().getManifest();
        if (mf.getManifestVersion() == null || mf.getManifestVersion().equals("")) {
            mf.setManifestVersion("1.0");
        }
        this.save(mf);
    }

    public void saveMofResource(Resource aResource) throws SaveFailureException {
        if (!this.shouldSave(aResource)) {
            return;
        }
        this.setEncoding(aResource);
        try {
            boolean wasModified = aResource.isModified();
            OutputStream os = this.getOutputStreamForResource(aResource);
            this.saveMofResource(aResource, os);
            aResource.setModified(wasModified);
        }
        catch (Exception e) {
            throw new SaveFailureException(aResource.getURI().toString(), e);
        }
    }

    protected void saveMofResource(Resource aResource, OutputStream os) throws IOException {
        aResource.save(os, Collections.EMPTY_MAP);
    }

    protected void saveMofResources() throws SaveFailureException {
        Iterator iterator = this.getArchive().getLoadedMofResources().iterator();
        ArrayList<Resource> xmiResources = new ArrayList<Resource>();
        ArrayList<Resource> xmlResources = new ArrayList<Resource>();
        Resource res = null;
        while (iterator.hasNext()) {
            res = (Resource)iterator.next();
            if (ArchiveUtil.isJavaResource(res) || ArchiveUtil.isRegisteredURIMapping(res) || ArchiveUtil.isPlatformMetaResource(res)) continue;
            Revisit.revisit();
            if (res instanceof CompatibilityXMIResource) {
                ((CompatibilityXMIResource)res).setFormat(1);
            }
            if (res instanceof TranslatorResource) {
                xmlResources.add(res);
                continue;
            }
            xmiResources.add(res);
        }
        this.basicSaveMofResources(xmiResources);
        this.basicSaveMofResources(xmlResources);
    }

    protected void basicSaveMofResources(List resources) throws SaveFailureException {
        Resource res = null;
        int i = 0;
        while (i < resources.size()) {
            res = (Resource)resources.get(i);
            this.saveMofResource(res);
            ++i;
        }
    }

    protected void setEncoding(Resource aResource) {
        if (aResource instanceof XMLResource) {
            ((XMLResource)aResource).setEncoding(this.archive.getXmlEncoding());
        }
    }

    public void setFilter(SaveFilter newFilter) {
        this.filter = newFilter;
    }

    protected boolean shouldIterateOver(Archive anArchive) {
        return anArchive.getLoadStrategy().requiresIterationOnSave();
    }

    protected boolean shouldSave(File aFile) {
        ModuleFile m;
        boolean loaded = this.isLoadedResourceOrManifest(aFile);
        if (loaded) {
            Resource res = this.archive.getLoadStrategy().getExistingMofResource(aFile.getURI());
            if (res == null) {
                return false;
            }
            return !this.shouldSave(res);
        }
        Archive archive = this.getArchive();
        if (archive.isModuleFile() && (m = (ModuleFile)archive).getExportStrategy() != null && m.getExportStrategy().hasSaved(aFile.getURI())) {
            return false;
        }
        return this.shouldSave(aFile.getURI());
    }

    protected boolean shouldSave(Resource res) {
        if (!res.isModified() && this.getArchive().getOptions().saveOnlyDirtyMofResources()) {
            return false;
        }
        return this.shouldSave(res.getURI().toString());
    }

    protected boolean shouldSave(String uri) {
        return this.getFilter().shouldSave(uri, this.getArchive());
    }
}

