/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commonarchivecore.impl;

import com.ibm.etools.application.Module;
import com.ibm.etools.j2ee.commonarchivecore.CommonarchiveFactory;
import com.ibm.etools.j2ee.commonarchivecore.CommonarchivePackage;
import com.ibm.etools.j2ee.commonarchivecore.EARFile;
import com.ibm.etools.j2ee.commonarchivecore.File;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.ModuleRef;
import com.ibm.etools.j2ee.commonarchivecore.exception.ArchiveRuntimeException;
import com.ibm.etools.j2ee.commonarchivecore.exception.ArchiveWrappedException;
import com.ibm.etools.j2ee.commonarchivecore.exception.DuplicateObjectException;
import com.ibm.etools.j2ee.commonarchivecore.exception.NoModuleFileException;
import com.ibm.etools.j2ee.commonarchivecore.exception.ResourceLoadException;
import com.ibm.etools.j2ee.commonarchivecore.internal.CommonArchiveFactoryRegistry;
import com.ibm.etools.j2ee.commonarchivecore.nls.CommonArchiveResourceHandler;
import com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ModuleRefImpl
extends EObjectImpl
implements ModuleRef,
EObject {
    protected ModuleFile moduleFile = null;
    protected Module module = null;
    static /* synthetic */ Class class$0;

    protected ModuleRefImpl() {
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.eINSTANCE.getModuleRef();
    }

    protected CommonarchiveFactory getCommonArchiveFactory() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory();
    }

    protected void buildComponentList(EList list) {
    }

    public ModuleFile getModuleFileGen() {
        if (this.moduleFile != null && this.moduleFile.eIsProxy()) {
            ModuleFile oldModuleFile = this.moduleFile;
            this.moduleFile = (ModuleFile)EcoreUtil.resolve((EObject)this.moduleFile, (EObject)this);
            if (this.moduleFile != oldModuleFile && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldModuleFile, (Object)this.moduleFile));
            }
        }
        return this.moduleFile;
    }

    public ModuleFile getModuleFile() {
        if (this.moduleFile == null) {
            this.initModuleFileFromEAR();
        }
        return this.moduleFile;
    }

    public ModuleFile basicGetModuleFile() {
        return this.moduleFile;
    }

    protected void initModuleFileFromEAR() {
        this.checkEARFile();
        ModuleFile aFile = null;
        try {
            aFile = (ModuleFile)this.getEarFile().getFile(this.module.getUri());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (ClassCastException classCastException) {}
        this.checkType(this.module, aFile);
        this.setModuleFile(aFile);
    }

    public void setModuleFile(ModuleFile newModuleFile) {
        ModuleFile oldModuleFile = this.moduleFile;
        this.moduleFile = newModuleFile;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldModuleFile, (Object)this.moduleFile));
        }
    }

    public boolean usesAltDD() {
        if (this.module == null) {
            return false;
        }
        return !ArchiveUtil.isNullOrEmpty(this.module.getAltDD());
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.moduleFile != null;
            }
            case 1: {
                return this.getEarFile() != null;
            }
            case 2: {
                return this.module != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setModuleFile((ModuleFile)newValue);
                return;
            }
            case 1: {
                this.setEarFile((EARFile)newValue);
                return;
            }
            case 2: {
                this.setModule((Module)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setModuleFile(null);
                return;
            }
            case 1: {
                this.setEarFile(null);
                return;
            }
            case 2: {
                this.setModule(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public EObject getAltDeploymentDescriptor() throws ArchiveWrappedException {
        if (this.getEarFile() == null) {
            return null;
        }
        try {
            return this.getEarFile().getAltDeploymentDescriptor(this.getModule());
        }
        catch (Exception ex) {
            throw new ArchiveWrappedException(ex);
        }
    }

    public EObject getDeploymentDescriptor() throws ArchiveWrappedException {
        if (this.getEarFile() == null) {
            return this.getStandardDeploymentDescriptor();
        }
        try {
            return this.getEarFile().getDeploymentDescriptor(this.getModule());
        }
        catch (Exception ex) {
            throw new ArchiveWrappedException(ex);
        }
    }

    public EObject getStandardDeploymentDescriptor() {
        if (this.getModuleFile() == null) {
            return null;
        }
        return this.getModuleFile().getStandardDeploymentDescriptor();
    }

    public void setURI(String uri) {
        if (this.getModuleFile() != null) {
            this.getModuleFile().setURI(uri);
        }
        if (this.getModule() != null) {
            this.getModule().setUri(uri);
        }
    }

    public boolean isClient() {
        return false;
    }

    public boolean isConnector() {
        return false;
    }

    public boolean isEJB() {
        return false;
    }

    public boolean isWeb() {
        return false;
    }

    public EARFile getEarFile() {
        if (this.eContainerFeatureID != 1) {
            return null;
        }
        return (EARFile)this.eContainer;
    }

    public void setEarFile(EARFile newEarFile) {
        if (newEarFile != this.eContainer || this.eContainerFeatureID != 1 && newEarFile != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newEarFile)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eContainer != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newEarFile != null) {
                InternalEObject internalEObject = (InternalEObject)newEarFile;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.ibm.etools.j2ee.commonarchivecore.EARFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseAdd((InternalEObject)this, 9, (Class)clazz, msgs);
            }
            if ((msgs = this.eBasicSetContainer((InternalEObject)newEarFile, 1, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newEarFile, (Object)newEarFile));
        }
    }

    public Module getModule() {
        if (this.module != null && this.module.eIsProxy()) {
            Module oldModule = this.module;
            this.module = (Module)EcoreUtil.resolve((EObject)this.module, (EObject)this);
            if (this.module != oldModule && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldModule, (Object)this.module));
            }
        }
        return this.module;
    }

    public Module basicGetModule() {
        return this.module;
    }

    public void setModule(Module newModule) {
        Module oldModule = this.module;
        this.module = newModule;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldModule, (Object)this.module));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 1: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 1, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 1: {
                    return this.eBasicSetContainer(null, 1, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block6: {
            if (this.eContainerFeatureID < 0) break block6;
            switch (this.eContainerFeatureID) {
                case 1: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.ibm.etools.j2ee.commonarchivecore.EARFile");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.eContainer.eInverseRemove((InternalEObject)this, 9, (Class)clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                if (resolve) {
                    return this.getModuleFile();
                }
                return this.basicGetModuleFile();
            }
            case 1: {
                return this.getEarFile();
            }
            case 2: {
                if (resolve) {
                    return this.getModule();
                }
                return this.basicGetModule();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public InputStream getResourceInputStream(String uri) throws IOException {
        if (this.usesAltDD()) {
            return this.getAltResourceInputStream(uri);
        }
        return this.getLocalResourceInputStream(uri);
    }

    public InputStream getLocalResourceInputStream(String uri) throws IOException {
        this.checkModuleFile();
        return this.moduleFile.getResourceInputStream(uri);
    }

    public InputStream getAltResourceInputStream(String uri) throws IOException {
        this.checkEARFile();
        return this.getEarFile().getResourceInputStream(uri);
    }

    public String getUri() {
        if (this.module != null) {
            return this.module.getUri();
        }
        if (this.moduleFile != null) {
            return this.moduleFile.getURI();
        }
        return null;
    }

    public Resource getAltMofResource(String uri) throws FileNotFoundException, ResourceLoadException {
        this.checkEARFile();
        return this.getEarFile().getMofResource(uri);
    }

    public Resource getLocalMofResource(String uri) throws FileNotFoundException, ResourceLoadException {
        this.checkModuleFile();
        return this.moduleFile.getMofResource(uri);
    }

    public Resource getMofResource(String uri) throws FileNotFoundException, ResourceLoadException {
        if (this.usesAltDD()) {
            return this.getAltMofResource(uri);
        }
        return this.getLocalMofResource(uri);
    }

    public Resource makeAltMofResource(String uri) throws DuplicateObjectException {
        this.checkEARFile();
        return this.getEarFile().makeMofResource(uri);
    }

    protected void checkEARFile() {
        if (this.getEarFile() == null) {
            throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString("Module_not_in_EAR", new Object[]{this.getUri()}));
        }
    }

    public Resource makeLocalMofResource(String uri) throws DuplicateObjectException {
        this.checkModuleFile();
        return this.moduleFile.makeMofResource(uri);
    }

    protected void checkModuleFile() {
        this.getModuleFile();
        if (this.moduleFile == null) {
            throw new NoModuleFileException(CommonArchiveResourceHandler.getString("Module_file_does_not_exist_2", new Object[]{this.getUri()}));
        }
    }

    protected void checkType(Module moduleDescriptor, File aFile) {
        if (aFile == null) {
            String message = CommonArchiveResourceHandler.getString("A_file_does_not_exist_for_module", new Object[]{moduleDescriptor.getUri()});
            throw new NoModuleFileException(message);
        }
        boolean isValid = true;
        String type = CommonArchiveResourceHandler.getString("Module_file");
        if (moduleDescriptor.isWebModule() && !aFile.isWARFile()) {
            isValid = false;
            type = CommonArchiveResourceHandler.getString("A_WAR_file");
        } else if (moduleDescriptor.isEjbModule() && !aFile.isEJBJarFile()) {
            isValid = false;
            type = CommonArchiveResourceHandler.getString("An_EJB_JAR_file");
        } else if (moduleDescriptor.isJavaModule() && !aFile.isApplicationClientFile()) {
            isValid = false;
            type = CommonArchiveResourceHandler.getString("An_Application_Client_JAR_file");
        } else if (moduleDescriptor.isConnectorModule() && !aFile.isRARFile()) {
            isValid = false;
            type = CommonArchiveResourceHandler.getString("A_RAR_file");
        } else if (!aFile.isModuleFile()) {
            isValid = false;
        }
        if (isValid) {
            return;
        }
        String earUri = "";
        if (this.getEarFile() != null) {
            earUri = this.getEarFile().getURI();
        }
        String message = CommonArchiveResourceHandler.getString("File_not_correct_type", new Object[]{aFile.getURI(), earUri, type});
        throw new ArchiveRuntimeException(message);
    }

    public Resource makeMofResource(String uri) throws DuplicateObjectException {
        if (this.usesAltDD()) {
            return this.makeAltMofResource(uri);
        }
        return this.makeLocalMofResource(uri);
    }
}

