/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commonarchivecore.impl;

import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.j2ee.commonarchivecore.CommonarchivePackage;
import com.ibm.etools.j2ee.commonarchivecore.Container;
import com.ibm.etools.j2ee.commonarchivecore.EARFile;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.exception.ArchiveRuntimeException;
import com.ibm.etools.j2ee.commonarchivecore.exception.DuplicateObjectException;
import com.ibm.etools.j2ee.commonarchivecore.exception.ResourceLoadException;
import com.ibm.etools.j2ee.commonarchivecore.exception.SaveFailureException;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ExportStrategy;
import com.ibm.etools.j2ee.commonarchivecore.impl.ArchiveImpl;
import com.ibm.etools.j2ee.commonarchivecore.impl.FileImpl;
import com.ibm.etools.j2ee.commonarchivecore.strategy.ImportStrategy;
import com.ibm.etools.j2ee.commonarchivecore.strategy.SaveStrategy;
import java.io.FileNotFoundException;
import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class ModuleFileImpl
extends ArchiveImpl
implements ModuleFile {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected ImportStrategy importStrategy;
    protected ExportStrategy exportStrategy;
    static /* synthetic */ Class class$0;

    protected EClass eStaticClass() {
        return CommonarchivePackage.eINSTANCE.getModuleFile();
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 6, msgs);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicAdd((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    return this.eBasicSetContainer(null, 6, msgs);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block6: {
            if (this.eContainerFeatureID < 0) break block6;
            switch (this.eContainerFeatureID) {
                case 6: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.ibm.etools.j2ee.commonarchivecore.Container");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.eContainer.eInverseRemove((InternalEObject)this, 7, (Class)clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getURI();
            }
            case 1: {
                return new Long(this.getLastModified());
            }
            case 2: {
                return new Long(this.getSize());
            }
            case 3: {
                return this.isDirectoryEntry() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.getOriginalURI();
            }
            case 5: {
                if (resolve) {
                    return this.getLoadingContainer();
                }
                return this.basicGetLoadingContainer();
            }
            case 6: {
                return this.getContainer();
            }
            case 7: {
                return this.getFiles();
            }
            case 8: {
                return this.getTypes();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setURI((String)newValue);
                return;
            }
            case 1: {
                this.setLastModified((Long)newValue);
                return;
            }
            case 2: {
                this.setSize((Long)newValue);
                return;
            }
            case 3: {
                this.setDirectoryEntry((Boolean)newValue);
                return;
            }
            case 4: {
                this.setOriginalURI((String)newValue);
                return;
            }
            case 5: {
                this.setLoadingContainer((Container)newValue);
                return;
            }
            case 6: {
                this.setContainer((Container)newValue);
                return;
            }
            case 7: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getTypes().clear();
                this.getTypes().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setURI(FileImpl.URI_EDEFAULT);
                return;
            }
            case 1: {
                this.unsetLastModified();
                return;
            }
            case 2: {
                this.unsetSize();
                return;
            }
            case 3: {
                this.unsetDirectoryEntry();
                return;
            }
            case 4: {
                this.setOriginalURI(FileImpl.ORIGINAL_URI_EDEFAULT);
                return;
            }
            case 5: {
                this.setLoadingContainer(null);
                return;
            }
            case 6: {
                this.setContainer(null);
                return;
            }
            case 7: {
                this.getFiles().clear();
                return;
            }
            case 8: {
                this.getTypes().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return FileImpl.URI_EDEFAULT == null ? this.uri != null : !FileImpl.URI_EDEFAULT.equals(this.uri);
            }
            case 1: {
                return this.isSetLastModified();
            }
            case 2: {
                return this.isSetSize();
            }
            case 3: {
                return this.isSetDirectoryEntry();
            }
            case 4: {
                return FileImpl.ORIGINAL_URI_EDEFAULT == null ? this.originalURI != null : !FileImpl.ORIGINAL_URI_EDEFAULT.equals(this.originalURI);
            }
            case 5: {
                return this.loadingContainer != null;
            }
            case 6: {
                return this.getContainer() != null;
            }
            case 7: {
                return this.files != null && !this.files.isEmpty();
            }
            case 8: {
                return this.types != null && !this.types.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    protected boolean canLazyInitialize() {
        return this.getImportStrategy() != null;
    }

    public Resource getDeploymentDescriptorResource() throws FileNotFoundException, ResourceLoadException {
        return this.getMofResource(this.getDeploymentDescriptorUri());
    }

    public abstract String getDeploymentDescriptorUri();

    public EARFile getEARFile() {
        Container aContainer = this.getContainer();
        if (aContainer == null || !aContainer.isEARFile()) {
            return null;
        }
        return (EARFile)aContainer;
    }

    public ExportStrategy getExportStrategy() {
        return this.exportStrategy;
    }

    public ImportStrategy getImportStrategy() {
        return this.importStrategy;
    }

    public String getSpecVersion() {
        float ver = this.getSpecVersionID();
        Float specVersion = new Float(ver / 10.0f);
        return specVersion.toString();
    }

    public int getSpecVersionID() {
        try {
            return ((XMLResource)this.getDeploymentDescriptorResource()).getModuleVersionID();
        }
        catch (Exception e) {
            throw new ArchiveRuntimeException(e);
        }
    }

    public abstract boolean isDeploymentDescriptorSet();

    public boolean isModuleFile() {
        return true;
    }

    public abstract EObject makeDeploymentDescriptor(XMLResource var1);

    public Resource makeDeploymentDescriptorResource() {
        XMLResource resource = null;
        try {
            resource = (XMLResource)this.makeMofResource(this.getDeploymentDescriptorUri());
        }
        catch (DuplicateObjectException duplicateObjectException) {
            try {
                return this.getDeploymentDescriptorResource();
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        this.makeDeploymentDescriptor(resource);
        return resource;
    }

    public void save(SaveStrategy aSaveStrategy) throws SaveFailureException {
        this.setSaveStrategy(aSaveStrategy);
        if (this.getExportStrategy() != null) {
            this.getExportStrategy().preSave(aSaveStrategy);
        }
        super.save(aSaveStrategy);
    }

    public void setExportStrategy(ExportStrategy newExportStrategy) {
        this.exportStrategy = newExportStrategy;
        if (newExportStrategy != null) {
            newExportStrategy.setArchive(this);
        }
    }

    public void setImportStrategy(ImportStrategy newImportStrategy) {
        this.importStrategy = newImportStrategy;
        if (newImportStrategy != null) {
            newImportStrategy.setArchive(this);
        }
    }

    public void setJ2EEVersion(int versionID) {
        try {
            ((XMLResource)this.getDeploymentDescriptorResource()).setVersionID(versionID);
        }
        catch (ResourceLoadException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw new ArchiveRuntimeException(e);
        }
    }
}

