/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commonarchivecore.impl;

import com.ibm.etools.j2ee.commonarchivecore.CommonarchivePackage;
import com.ibm.etools.j2ee.commonarchivecore.Container;
import com.ibm.etools.j2ee.commonarchivecore.File;
import com.ibm.etools.j2ee.commonarchivecore.impl.FileImpl;
import com.ibm.etools.j2ee.commonarchivecore.strategy.LoadStrategy;
import com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class ContainerImpl
extends FileImpl
implements Container {
    protected LoadStrategy loadStrategy;
    protected Map fileIndex;
    protected FileNotificationAdapter fileIndexAdapter;
    protected EList files = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected EClass eStaticClass() {
        return CommonarchivePackage.eINSTANCE.getContainer();
    }

    public boolean containsFile(String uri) {
        String key;
        String string = key = uri.startsWith("/") ? ArchiveUtil.truncateFromFrontIgnoreCase(uri, "/") : uri;
        if (this.isIndexed()) {
            return this.getFileIndex().containsKey(key);
        }
        return this.getLoadStrategy().contains(key);
    }

    public String getAbsolutePath() throws FileNotFoundException {
        return this.getLoadStrategy().getAbsolutePath();
    }

    public File getFile(String URI2) throws FileNotFoundException {
        File file;
        if (!this.isIndexed()) {
            this.getFiles();
        }
        if ((file = (File)this.getFileIndex().get(URI2)) == null) {
            throw new FileNotFoundException(URI2);
        }
        return file;
    }

    protected Map getFileIndex() {
        if (this.fileIndex == null) {
            this.getFileIndexAdapter().rebuildFileIndex();
        }
        return this.fileIndex;
    }

    protected FileNotificationAdapter getFileIndexAdapter() {
        if (this.fileIndexAdapter == null) {
            this.fileIndexAdapter = new FileNotificationAdapter();
            this.eAdapters().add((Object)this.fileIndexAdapter);
        }
        return this.fileIndexAdapter;
    }

    public EList getFiles() {
        EList files = this.getFilesGen();
        if (!this.isIndexed()) {
            if (files.isEmpty() && this.getLoadStrategy() != null) {
                files.addAll((Collection)this.getLoadStrategy().collectFiles());
            }
            this.getFileIndex();
        }
        return files;
    }

    public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
        if (this.isIndexed()) {
            return this.getFile(uri).getInputStream();
        }
        return this.primGetInputStream(uri);
    }

    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public boolean isContainer() {
        return true;
    }

    public boolean isIndexed() {
        return this.fileIndex != null;
    }

    public InputStream primGetInputStream(String uri) throws IOException, FileNotFoundException {
        return this.getLoadStrategy().getInputStream(uri);
    }

    public void rebuildFileIndex() {
        this.getFileIndexAdapter().rebuildFileIndex();
    }

    public void setLoadStrategy(LoadStrategy newLoadStrategy) {
        if (newLoadStrategy != null) {
            newLoadStrategy.setContainer(this);
            if (this.loadStrategy != null) {
                newLoadStrategy.setRendererType(this.loadStrategy.getRendererType());
                newLoadStrategy.setReadOnly(this.loadStrategy.isReadOnly());
                this.loadStrategy.setContainer(null);
                this.loadStrategy.close();
            }
        }
        this.loadStrategy = newLoadStrategy;
    }

    public EList getFilesGen() {
        if (this.files == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.etools.j2ee.commonarchivecore.File");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.files = new EObjectContainmentWithInverseEList((Class)clazz, (InternalEObject)this, 7, 6);
        }
        return this.files;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 6, msgs);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicAdd((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    return this.eBasicSetContainer(null, 6, msgs);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block6: {
            if (this.eContainerFeatureID < 0) break block6;
            switch (this.eContainerFeatureID) {
                case 6: {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("com.ibm.etools.j2ee.commonarchivecore.Container");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.eContainer.eInverseRemove((InternalEObject)this, 7, (Class)clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getURI();
            }
            case 1: {
                return new Long(this.getLastModified());
            }
            case 2: {
                return new Long(this.getSize());
            }
            case 3: {
                return this.isDirectoryEntry() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.getOriginalURI();
            }
            case 5: {
                if (resolve) {
                    return this.getLoadingContainer();
                }
                return this.basicGetLoadingContainer();
            }
            case 6: {
                return this.getContainer();
            }
            case 7: {
                return this.getFiles();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setURI((String)newValue);
                return;
            }
            case 1: {
                this.setLastModified((Long)newValue);
                return;
            }
            case 2: {
                this.setSize((Long)newValue);
                return;
            }
            case 3: {
                this.setDirectoryEntry((Boolean)newValue);
                return;
            }
            case 4: {
                this.setOriginalURI((String)newValue);
                return;
            }
            case 5: {
                this.setLoadingContainer((Container)newValue);
                return;
            }
            case 6: {
                this.setContainer((Container)newValue);
                return;
            }
            case 7: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setURI(FileImpl.URI_EDEFAULT);
                return;
            }
            case 1: {
                this.unsetLastModified();
                return;
            }
            case 2: {
                this.unsetSize();
                return;
            }
            case 3: {
                this.unsetDirectoryEntry();
                return;
            }
            case 4: {
                this.setOriginalURI(FileImpl.ORIGINAL_URI_EDEFAULT);
                return;
            }
            case 5: {
                this.setLoadingContainer(null);
                return;
            }
            case 6: {
                this.setContainer(null);
                return;
            }
            case 7: {
                this.getFiles().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return FileImpl.URI_EDEFAULT == null ? this.uri != null : !FileImpl.URI_EDEFAULT.equals(this.uri);
            }
            case 1: {
                return this.isSetLastModified();
            }
            case 2: {
                return this.isSetSize();
            }
            case 3: {
                return this.isSetDirectoryEntry();
            }
            case 4: {
                return FileImpl.ORIGINAL_URI_EDEFAULT == null ? this.originalURI != null : !FileImpl.ORIGINAL_URI_EDEFAULT.equals(this.originalURI);
            }
            case 5: {
                return this.loadingContainer != null;
            }
            case 6: {
                return this.getContainer() != null;
            }
            case 7: {
                return this.files != null && !this.files.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void clearFiles() {
        boolean oldDelivery = this.eDeliver();
        this.files.clear();
        this.eSetDeliver(oldDelivery);
        if (this.isIndexed()) {
            this.eAdapters().remove((Object)this.fileIndexAdapter);
            this.fileIndexAdapter = null;
            this.fileIndex = null;
        }
    }

    protected class FileNotificationAdapter
    extends AdapterImpl {
        protected FileNotificationAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == "FileNotificationAdapter";
        }

        public void addIndexedFile(String newValue, Notifier notifier) {
            ContainerImpl.this.fileIndex.put(newValue, notifier);
            if (notifier.eAdapters() == null || !notifier.eAdapters().contains((Object)this)) {
                notifier.eAdapters().add((Object)this);
            }
        }

        public void removeIndexedFile(String oldValue, Notifier notifier) {
            ContainerImpl.this.fileIndex.remove(oldValue);
            notifier.eAdapters().remove((Object)this);
        }

        public void notifyChanged(Notification notification) {
            if (ContainerImpl.this.fileIndex == null || notification.getFeature() == null) {
                return;
            }
            if (notification.getFeature().equals(CommonarchivePackage.eINSTANCE.getFile_URI()) && ((File)notification.getNotifier()).getContainer() == ContainerImpl.this) {
                ContainerImpl.this.fileIndex.remove(notification.getOldValue());
                ContainerImpl.this.fileIndex.put(notification.getNewValue(), notification.getNotifier());
            }
            if (notification.getFeature().equals(CommonarchivePackage.eINSTANCE.getContainer_Files()) && notification.getNotifier() == ContainerImpl.this) {
                switch (notification.getEventType()) {
                    case 3: {
                        File file = (File)notification.getNewValue();
                        this.addIndexedFile(file.getURI(), (Notifier)file);
                        break;
                    }
                    case 4: {
                        this.removeIndexedFile(((File)notification.getOldValue()).getURI(), (Notifier)((File)notification.getOldValue()));
                        break;
                    }
                    case 5: {
                        this.filesAdded((List)notification.getNewValue());
                        break;
                    }
                    case 6: {
                        this.filesRemoved((List)notification.getOldValue());
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 1: {
                        if (notification.getPosition() == -1) break;
                        File file = (File)notification.getNewValue();
                        this.removeIndexedFile(((File)notification.getOldValue()).getURI(), (Notifier)((File)notification.getOldValue()));
                        this.addIndexedFile(file.getURI(), (Notifier)file);
                    }
                }
            }
        }

        public void filesAdded(List newFiles) {
            int i = 0;
            while (i < newFiles.size()) {
                File file = (File)newFiles.get(i);
                this.addIndexedFile(file.getURI(), (Notifier)file);
                ++i;
            }
        }

        public void filesRemoved(List oldFiles) {
            int i = 0;
            while (i < oldFiles.size()) {
                File file = (File)oldFiles.get(i);
                this.removeIndexedFile(file.getURI(), (Notifier)file);
                ++i;
            }
        }

        public void rebuildFileIndex() {
            this.removeAdaptersIfNecessary();
            ContainerImpl.this.fileIndex = new HashMap();
            if (ContainerImpl.this.getFiles().size() > 0) {
                Iterator i = ContainerImpl.this.getFiles().iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    this.addIndexedFile(file.getURI(), (Notifier)file);
                }
            }
        }

        public void removeAdaptersIfNecessary() {
            if (ContainerImpl.this.fileIndex == null) {
                return;
            }
            Iterator iter = ContainerImpl.this.fileIndex.values().iterator();
            while (iter.hasNext()) {
                File aFile = (File)iter.next();
                aFile.eAdapters().remove((Object)this);
            }
        }
    }
}

