/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commonarchivecore.helpers;

import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.helpers.SaveFilter;
import com.ibm.etools.j2ee.commonarchivecore.helpers.SaveFilterImpl;
import com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FileExtensionsFilterImpl
extends SaveFilterImpl
implements SaveFilter {
    protected Set excludedExtensions;
    protected boolean isCaseSensitive = false;
    protected Set excludedExtensionsAsUppercase;

    public FileExtensionsFilterImpl(String[] extensionsToExclude, boolean caseSensitive) {
        HashSet<String> extensions = new HashSet<String>();
        int i = 0;
        while (i < extensionsToExclude.length) {
            extensions.add(extensionsToExclude[i]);
            ++i;
        }
        this.setExcludedExtensions(extensions);
        this.setIsCaseSensitive(caseSensitive);
        this.initialize();
    }

    public FileExtensionsFilterImpl(String extension, boolean caseSensitive) {
        HashSet<String> extensions = new HashSet<String>(1);
        extensions.add(extension);
        this.setExcludedExtensions(extensions);
        this.setIsCaseSensitive(caseSensitive);
        this.initialize();
    }

    public FileExtensionsFilterImpl(Set extensionsToExclude, boolean caseSensitive) {
        this.setExcludedExtensions(extensionsToExclude);
        this.setIsCaseSensitive(caseSensitive);
        this.initialize();
    }

    public Set getExcludedExtensions() {
        return this.excludedExtensions;
    }

    protected Set getExcludedExtensionsAsUppercase() {
        return this.excludedExtensionsAsUppercase;
    }

    protected void initialize() {
        if (this.isCaseSensitive()) {
            return;
        }
        HashSet<String> aSet = new HashSet<String>();
        Iterator it = this.getExcludedExtensions().iterator();
        while (it.hasNext()) {
            aSet.add(((String)it.next()).toUpperCase());
        }
        this.setExcludedExtensionsAsUppercase(aSet);
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    protected void setExcludedExtensions(Set newExcludedExtensions) {
        this.excludedExtensions = newExcludedExtensions;
    }

    protected void setExcludedExtensionsAsUppercase(Set newExcludedExtensionsAsUppercase) {
        this.excludedExtensionsAsUppercase = newExcludedExtensionsAsUppercase;
    }

    protected void setIsCaseSensitive(boolean value) {
        this.isCaseSensitive = value;
    }

    public boolean shouldSave(String uri, Archive anArchive) {
        Set excluded;
        String extension = ArchiveUtil.getFileNameExtension(uri);
        if (extension.equals("")) {
            return true;
        }
        if (this.isCaseSensitive()) {
            excluded = this.getExcludedExtensions();
        } else {
            excluded = this.getExcludedExtensionsAsUppercase();
            extension = extension.toUpperCase();
        }
        return !excluded.contains(extension);
    }
}

