/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.util;

import com.ibm.etools.ejb.ContainerManagedEntity;
import com.ibm.etools.ejb.util.CMPFieldDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.Method;

public class CMPHelper {
    public static final String GET = "get";
    public static final String SET = "set";
    protected static Comparator methodComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Method m1 = (Method)o1;
            Method m2 = (Method)o2;
            String s1 = m1.getName();
            String s2 = m2.getName();
            if (s1 == null) {
                return "".compareTo(s2);
            }
            return s1.compareTo(s2);
        }
    };

    protected CMPHelper() {
    }

    public static List getAvailableCMP20FieldDescriptors(JavaClass beanClass) {
        return CMPHelper.getAvailableCMP20FieldDescriptors(beanClass, null);
    }

    public static List getAvailableCMP20FieldDescriptors(JavaClass beanClass, CMPFieldExistTester fieldTester) {
        if (beanClass == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CMPFieldDescriptor> result = new ArrayList<CMPFieldDescriptor>();
        HashMap<String, Method> getters = new HashMap<String, Method>();
        List methods = beanClass.getPublicMethodsExtended();
        Collections.sort(methods, methodComparator);
        int i = 0;
        while (i < methods.size()) {
            String typeName;
            String fieldName;
            Method getter;
            Method aMethod = (Method)methods.get(i);
            if (CMPHelper.isGetter(aMethod) && aMethod.isAbstract() && !aMethod.isStatic() && (fieldTester == null || fieldTester.isExisting(aMethod))) {
                getters.put(CMPHelper.getFieldName(aMethod), aMethod);
            } else if (CMPHelper.isSetter(aMethod) && aMethod.isAbstract() && !aMethod.isStatic() && CMPHelper.typesAgree(getter = (Method)getters.get(fieldName = CMPHelper.getFieldName(aMethod)), aMethod) && (typeName = CMPHelper.getReturnTypeName(getter)) != null && (fieldTester == null || fieldTester.isExisting(getter))) {
                result.add(CMPHelper.createFieldDescriptor(fieldName, typeName));
            }
            ++i;
        }
        return result;
    }

    public static List getAvailableCMP11FieldDescriptors(JavaClass beanClass) {
        return CMPHelper.getAvailableCMP11FieldDescriptors(beanClass, null);
    }

    public static List getAvailableCMP11FieldDescriptors(JavaClass beanClass, CMPFieldExistTester fieldTester) {
        if (beanClass == null) {
            return Collections.EMPTY_LIST;
        }
        List fields = beanClass.getFieldsExtended();
        ArrayList<CMPFieldDescriptor> result = new ArrayList<CMPFieldDescriptor>();
        int i = 0;
        while (i < fields.size()) {
            Field aField = (Field)fields.get(i);
            if (CMPHelper.isPublic(aField) && !aField.isStatic() && !aField.isTransient() && (fieldTester == null || fieldTester.isExisting(aField))) {
                String name = aField.getName();
                String typeName = CMPHelper.getTypeName(aField);
                if (typeName != null && name != null) {
                    result.add(CMPHelper.createFieldDescriptor(name, typeName));
                }
            }
            ++i;
        }
        return result;
    }

    public static List getAvailableCMPFieldDescriptors(ContainerManagedEntity cmpBean) {
        return CMPHelper.getAvailableCMPFieldDescriptors(cmpBean, null);
    }

    public static List getAvailableCMPFieldDescriptors(ContainerManagedEntity cmpBean, CMPFieldExistTester fieldTester) {
        JavaClass beanClass = cmpBean.getEjbClass();
        if (beanClass == null) {
            return Collections.EMPTY_LIST;
        }
        switch (cmpBean.getVersionID()) {
            case 10: 
            case 11: {
                return CMPHelper.getAvailableCMP11FieldDescriptors(beanClass, fieldTester);
            }
        }
        return CMPHelper.getAvailableCMP20FieldDescriptors(beanClass, fieldTester);
    }

    protected static boolean isGetter(Method aMethod) {
        String name = aMethod.getName();
        return name != null && name.startsWith(GET) && name.length() > 3 && aMethod.listParametersWithoutReturn().length == 0 && !aMethod.isVoid();
    }

    protected static boolean isSetter(Method aMethod) {
        String name = aMethod.getName();
        return name != null && name.startsWith(SET) && name.length() > 3 && aMethod.listParametersWithoutReturn().length == 1 && aMethod.isVoid();
    }

    protected static String getFieldName(Method aMethod) {
        if (aMethod == null) {
            return null;
        }
        return CMPHelper.getFieldName(aMethod.getName());
    }

    public static String getFieldName(String methodName) {
        if (methodName == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(methodName);
        sb.delete(0, 3);
        char lower = Character.toLowerCase(sb.charAt(0));
        sb.setCharAt(0, lower);
        return sb.toString();
    }

    protected static String getReturnTypeName(Method getter) {
        if (getter == null) {
            return null;
        }
        JavaHelpers retType = getter.getReturnType();
        return CMPHelper.getTypeName(retType);
    }

    protected static String getTypeName(Field aField) {
        if (aField == null) {
            return null;
        }
        JavaHelpers type = (JavaHelpers)aField.getEType();
        return CMPHelper.getTypeName(type);
    }

    protected static String getTypeName(JavaHelpers helpers) {
        if (helpers == null) {
            return null;
        }
        return helpers.getQualifiedName();
    }

    protected static boolean typesAgree(Method getter, Method setter) {
        if (getter == null || getter.isVoid() || setter == null) {
            return false;
        }
        JavaParameter[] parameters = setter.listParametersWithoutReturn();
        if (parameters.length != 1) {
            return false;
        }
        JavaParameter param = parameters[0];
        return param.getEType() != null && param.getEType() == getter.getReturnType();
    }

    protected static CMPFieldDescriptor createFieldDescriptor(String name, String typeName) {
        CMPFieldDescriptor desc = new CMPFieldDescriptor();
        desc.setName(name);
        desc.setType(typeName);
        return desc;
    }

    protected static boolean isPublic(Field field) {
        if (field == null) {
            return false;
        }
        return JavaVisibilityKind.PUBLIC_LITERAL.getValue() == field.getJavaVisibility().getValue();
    }

    public interface CMPFieldExistTester {
        public boolean isExisting(Field var1);

        public boolean isExisting(Method var1);
    }
}

