/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.util;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.clientbnd.ApplicationClientBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.applicationclientext.ApplicationClientExtension;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.etools.application.Application;
import com.ibm.etools.client.ApplicationClient;
import com.ibm.etools.commonarchive.util.ArchiveConstants;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.webapplication.WebApp;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

class InternalModuleHelper
implements ArchiveConstants {
    InternalModuleHelper() {
    }

    public static void fixupBndOrExtRootsIfNecessary(Resource resource) {
        if (resource instanceof XMLResource || resource.getContents().isEmpty()) {
            return;
        }
        String lastSegment = resource.getURI().lastSegment();
        if ("ibm-application-bnd.xmi".equals(lastSegment)) {
            InternalModuleHelper.applicationBindingsLoaded(resource);
        } else if ("ibm-application-ext.xmi".equals(lastSegment)) {
            InternalModuleHelper.applicationExtensionsLoaded(resource);
        } else if ("ibm-application-client-bnd.xmi".equals(lastSegment)) {
            InternalModuleHelper.appClientBindingsLoaded(resource);
        } else if ("ibm-application-client-ext.xmi".equals(lastSegment)) {
            InternalModuleHelper.appClientExtensionsLoaded(resource);
        } else if ("ibm-ejb-jar-bnd.xmi".equals(lastSegment)) {
            InternalModuleHelper.ejbJarBindingsLoaded(resource);
        } else if ("ibm-ejb-jar-ext.xmi".equals(lastSegment)) {
            InternalModuleHelper.ejbJarExtensionsLoaded(resource);
        } else if ("ibm-web-bnd.xmi".equals(lastSegment)) {
            InternalModuleHelper.webAppBindingsLoaded(resource);
        } else if ("ibm-web-ext.xmi".equals(lastSegment)) {
            InternalModuleHelper.webAppExtensionsLoaded(resource);
        }
    }

    private static URI getDDResourceURIIfProxy(EObject extOrBnd) {
        if (extOrBnd.eIsProxy()) {
            return ((InternalEObject)extOrBnd).eProxyURI().trimFragment();
        }
        return null;
    }

    private static Resource getDDResourceIfProxy(Resource resource, EObject root) {
        if (root == null) {
            return null;
        }
        URI uri = InternalModuleHelper.getDDResourceURIIfProxy(root);
        if (uri == null) {
            return null;
        }
        ResourceSet set = resource.getResourceSet();
        if (set == null) {
            return null;
        }
        return set.getResource(uri, true);
    }

    private static void webAppExtensionsLoaded(Resource resource) {
        WebAppExtension ext = (WebAppExtension)resource.getContents().get(0);
        WebApp app = ext.getWebApp();
        Resource res = InternalModuleHelper.getDDResourceIfProxy(resource, app);
        if (res != null && !res.getContents().isEmpty()) {
            WebApp real = (WebApp)res.getContents().get(0);
            ext.setWebApp(real);
        }
    }

    private static void webAppBindingsLoaded(Resource resource) {
        WebAppBinding ext = (WebAppBinding)resource.getContents().get(0);
        WebApp root = ext.getWebapp();
        Resource res = InternalModuleHelper.getDDResourceIfProxy(resource, root);
        if (res != null && !res.getContents().isEmpty()) {
            WebApp real = (WebApp)res.getContents().get(0);
            ext.setWebapp(real);
        }
    }

    private static void ejbJarExtensionsLoaded(Resource resource) {
        EJBJarExtension ext = (EJBJarExtension)resource.getContents().get(0);
        EJBJar root = ext.getEjbJar();
        Resource res = InternalModuleHelper.getDDResourceIfProxy(resource, root);
        if (res != null && !res.getContents().isEmpty()) {
            EJBJar real = (EJBJar)res.getContents().get(0);
            ext.setEjbJar(real);
        }
    }

    private static void ejbJarBindingsLoaded(Resource resource) {
        EJBJarBinding ext = (EJBJarBinding)resource.getContents().get(0);
        EJBJar root = ext.getEjbJar();
        Resource res = InternalModuleHelper.getDDResourceIfProxy(resource, root);
        if (res != null && !res.getContents().isEmpty()) {
            EJBJar real = (EJBJar)res.getContents().get(0);
            ext.setEjbJar(real);
        }
    }

    private static void appClientExtensionsLoaded(Resource resource) {
        ApplicationClientExtension ext = (ApplicationClientExtension)resource.getContents().get(0);
        ApplicationClient root = ext.getExtendedApplicationClient();
        Resource res = InternalModuleHelper.getDDResourceIfProxy(resource, root);
        if (res != null && !res.getContents().isEmpty()) {
            ApplicationClient real = (ApplicationClient)res.getContents().get(0);
            ext.setExtendedApplicationClient(real);
        }
    }

    private static void appClientBindingsLoaded(Resource resource) {
        ApplicationClientBinding ext = (ApplicationClientBinding)resource.getContents().get(0);
        ApplicationClient root = ext.getApplicationClient();
        Resource res = InternalModuleHelper.getDDResourceIfProxy(resource, root);
        if (res != null && !res.getContents().isEmpty()) {
            ApplicationClient real = (ApplicationClient)res.getContents().get(0);
            ext.setApplicationClient(real);
        }
    }

    private static void applicationExtensionsLoaded(Resource resource) {
        ApplicationExtension ext = (ApplicationExtension)resource.getContents().get(0);
        Application root = ext.getApplication();
        Resource res = InternalModuleHelper.getDDResourceIfProxy(resource, root);
        if (res != null && !res.getContents().isEmpty()) {
            Application real = (Application)res.getContents().get(0);
            ext.setApplication(real);
        }
    }

    private static void applicationBindingsLoaded(Resource resource) {
        ApplicationBinding ext = (ApplicationBinding)resource.getContents().get(0);
        Application root = ext.getApplication();
        Resource res = InternalModuleHelper.getDDResourceIfProxy(resource, root);
        if (res != null && !res.getContents().isEmpty()) {
            Application real = (Application)res.getContents().get(0);
            ext.setApplication(real);
        }
    }
}

