/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.util;

import com.ibm.ejs.models.base.extensions.applicationext.ModuleExtension;
import com.ibm.etools.commonarchive.EARFile;

public class ArchiveUtil
extends com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil {
    public static String getDefaultAltBindingsUri(ModuleExtension ext, EARFile ear) {
        String root = ArchiveUtil.getOrCreateAltRoot(ext, ear);
        String shortName = ext.getDefaultBindingsShortName();
        if (shortName == null) {
            return null;
        }
        return com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil.concatUri(root, shortName, '/');
    }

    public static String getOrCreateAltRoot(ModuleExtension ext, EARFile ear) {
        if (!com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil.isNullOrEmpty(ext.getAltRoot())) {
            return ext.getAltRoot();
        }
        String root = null;
        int index = 0;
        do {
            root = com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil.concatUri("ALT-INF", ext.getModule().getUri(), '/');
            if (index > 0) {
                root = String.valueOf(root) + index;
            }
            ++index;
        } while (ArchiveUtil.altRootCollides(root, ext, ear));
        ext.setAltRoot(root);
        return root;
    }

    protected static boolean altRootCollides(String root, ModuleExtension ext, EARFile ear) {
        String altBindings = ext.getAltBindings();
        String altExtensions = ext.getAltExtensions();
        String altDD = ext.getModule().getAltDD();
        if (com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil.isNullOrEmpty(altBindings) && com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil.isNullOrEmpty(altExtensions) && com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil.isNullOrEmpty(altDD)) {
            altBindings = com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil.concatUri(root, ext.getDefaultBindingsShortName(), '/');
            altExtensions = com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil.concatUri(root, ext.getDefaultExtensionsShortName(), '/');
            altDD = com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil.concatUri(root, ext.getDeploymentDescriptorShortName(), '/');
            return ear.isDuplicate(altBindings) || ear.isDuplicate(altExtensions) || ear.isDuplicate(altDD);
        }
        return !com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil.isNullOrEmpty(altBindings) && altBindings.startsWith(root) || !com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil.isNullOrEmpty(altExtensions) && altExtensions.startsWith(root) || !com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil.isNullOrEmpty(altDD) && altDD.startsWith(root);
    }

    public static String getDefaultAltDDUri(ModuleExtension ext, EARFile ear) {
        String root = ArchiveUtil.getOrCreateAltRoot(ext, ear);
        return com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil.concatUri(root, ext.getDeploymentDescriptorShortName(), '/');
    }

    public static String getDefaultAltExtensionsUri(ModuleExtension ext, EARFile ear) {
        String root = ArchiveUtil.getOrCreateAltRoot(ext, ear);
        String shortName = ext.getDefaultExtensionsShortName();
        if (shortName == null) {
            return null;
        }
        return com.ibm.etools.j2ee.commonarchivecore.util.ArchiveUtil.concatUri(root, shortName, '/');
    }
}

