/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.archive.ejb10;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EjbbndFactory;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.impl.EjbbndFactoryImpl;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextFactory;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextPackage;
import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.ejbext.Identity;
import com.ibm.ejs.models.base.extensions.ejbext.IsolationLevelAttributes;
import com.ibm.ejs.models.base.extensions.ejbext.RunAsSpecifiedIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.SessionExtension;
import com.ibm.ejs.models.base.extensions.ejbext.TxIsolationLevel;
import com.ibm.ejs.models.base.extensions.ejbext.UseCallerIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.UseSystemIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.impl.EjbextFactoryImpl;
import com.ibm.etools.archive.ejb10.DDNames;
import com.ibm.etools.archive.ejb10.EJBJar10ImportStrategy;
import com.ibm.etools.archive.ejb10.Ejb10ManifestComparatorImpl;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.util.ArchiveUtil;
import com.ibm.etools.ejb.AssemblyDescriptor;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EjbFactory;
import com.ibm.etools.ejb.EjbPackage;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.ejb.MethodElement;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.j2ee.common.util.IDUtility;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.File;
import com.ibm.etools.j2ee.commonarchivecore.exception.DeploymentDescriptorLoadException;
import com.ibm.etools.j2ee.commonarchivecore.exception.NoEJB10DescriptorsException;
import com.ibm.etools.j2ee.commonarchivecore.exception.NotADeploymentDescriptorException;
import com.ibm.etools.j2ee.commonarchivecore.exception.OpenFailureException;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveManifest;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveTypeDiscriminator;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveTypeDiscriminatorImpl;
import com.ibm.etools.j2ee.commonarchivecore.nls.CommonArchiveResourceHandler;
import com.ibm.etools.j2ee.commonarchivecore.strategy.ImportStrategy;
import com.ibm.etools.j2ee.commonarchivecore.strategy.ImportStrategyImpl;
import com.ibm.etools.j2ee.commonarchivecore.util.ObjectInputStreamCustomResolver;
import com.ibm.etools.j2ee.ejb10.readers.AssemblyDescriptor10ReadAdaptor;
import com.ibm.etools.j2ee.ejb10.readers.ContainerManagedEntity10ReadAdapter;
import com.ibm.etools.j2ee.ejb10.readers.EnterpriseBean10ReadAdapter;
import com.ibm.etools.j2ee.ejb10.readers.Entity10ReadAdapter;
import com.ibm.etools.j2ee.ejb10.readers.Session10ReadAdapter;
import com.ibm.wtp.common.logger.proxy.Logger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import javax.ejb.deployment.ControlDescriptor;
import javax.ejb.deployment.DeploymentDescriptor;
import javax.ejb.deployment.EntityDescriptor;
import javax.ejb.deployment.SessionDescriptor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jem.internal.java.adapters.ReflectionAdaptor;

public class EJBJar10ImportStrategyImpl
extends ImportStrategyImpl
implements EJBJar10ImportStrategy {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Map deploymentDescriptors;
    protected DDNames ddNames;
    protected static Discriminator discriminator;

    public void addAssemblyDescriptor() {
        EJBJar ejbJar = this.getEjbJar();
        AssemblyDescriptor assemblyDescriptor = this.getEjbFactory().createAssemblyDescriptor();
        AssemblyDescriptor10ReadAdaptor adaptor = new AssemblyDescriptor10ReadAdaptor((Notifier)assemblyDescriptor, this.getDeploymentDescriptors());
        ejbJar.setAssemblyDescriptor(assemblyDescriptor);
        adaptor.reflectValuesIfNecessary();
    }

    public void addBindings() {
        EJBJarBinding bindings = this.getEJBJarFile().getBindings();
        Iterator descriptors = this.getDeploymentDescriptors().values().iterator();
        while (descriptors.hasNext()) {
            this.addEjbBinding((DeploymentDescriptor)descriptors.next(), bindings);
        }
    }

    protected EnterpriseBeanBinding addEjbBinding(DeploymentDescriptor desc, EJBJarBinding jarBindings) {
        EnterpriseBean ejb = this.getEnterpriseBeanFor(desc);
        EnterpriseBeanBinding beanBinding = jarBindings.getEJBBinding(ejb);
        beanBinding.setJndiName(desc.getBeanHomeName().toString());
        return beanBinding;
    }

    protected EnterpriseBeanExtension addEjbExtension(DeploymentDescriptor desc, EJBJarExtension ejbJarExt) {
        ControlDescriptor[] controlDescriptors;
        EnterpriseBean ejb = this.getEnterpriseBeanFor(desc);
        EnterpriseBeanExtension beanExt = ejbJarExt.getEJBExtension(ejb);
        if (beanExt.isSession()) {
            ((SessionExtension)beanExt).setTimeout(((SessionDescriptor)desc).getSessionTimeout());
        }
        if ((controlDescriptors = desc.getControlDescriptors()) != null) {
            int i = 0;
            while (i < controlDescriptors.length) {
                ControlDescriptor cd = controlDescriptors[i];
                beanExt.getRunAsSettings().add((Object)this.convertControlDescriptor(desc, cd));
                ++i;
            }
        }
        return beanExt;
    }

    public void addEnterpriseBeans() {
        EJBJar ejbJar = this.getEjbJar();
        if (this.getDeploymentDescriptors().isEmpty()) {
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("no_dds_10_EXC_", new Object[]{this.getArchive().getURI()}));
        }
        List names = this.getDeploymentDescriptorNames();
        int i = 0;
        while (i < names.size()) {
            String name = (String)names.get(i);
            DeploymentDescriptor dd = (DeploymentDescriptor)this.getDeploymentDescriptors().get(name);
            EnterpriseBean ejb = this.createEnterpriseBeanFor(dd);
            ejbJar.getEnterpriseBeans().add((Object)ejb);
            IDUtility.setDefaultID(ejb);
            ReflectionAdaptor adapter = ReflectionAdaptor.retrieveAdaptorFrom(ejb);
            adapter.reflectValuesIfNecessary();
            ++i;
        }
    }

    public void addExtensions() {
        EJBJarExtension ejbJarExt = this.getEJBJarFile().getExtensions();
        Iterator descriptors = this.getDeploymentDescriptors().values().iterator();
        while (descriptors.hasNext()) {
            this.addEjbExtension((DeploymentDescriptor)descriptors.next(), ejbJarExt);
        }
    }

    protected SecurityIdentity convertControlDescriptor(DeploymentDescriptor dd, ControlDescriptor cd) {
        SecurityIdentity runAs = this.getExtensionsFactory().createSecurityIdentity();
        int runAsMode = cd.getRunAsMode();
        if (runAsMode == 0) {
            UseCallerIdentity useCallerIdentity = ((EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi")).getEjbextFactory().createUseCallerIdentity();
            runAs.setRunAsMode(useCallerIdentity);
        } else if (runAsMode == 2) {
            UseSystemIdentity useSystemIdentity = ((EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi")).getEjbextFactory().createUseSystemIdentity();
            runAs.setRunAsMode(useSystemIdentity);
        } else if (runAsMode == 1) {
            RunAsSpecifiedIdentity asSpecifiedIdentity = ((EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi")).getEjbextFactory().createRunAsSpecifiedIdentity();
            runAs.setRunAsMode(asSpecifiedIdentity);
            java.security.Identity identity = cd.getRunAsIdentity();
            if (identity != null) {
                Identity extIdentity = this.getExtensionsFactory().createIdentity();
                extIdentity.setRoleName(cd.getRunAsIdentity().toString());
                extIdentity.setDescription(cd.getRunAsIdentity().getInfo());
                asSpecifiedIdentity.setRunAsSpecifiedIdentity(extIdentity);
            }
        }
        Method method = cd.getMethod();
        MethodElement element = this.getEjbFactory().createMethodElementFrom(method);
        MethodElement element2 = this.getEjbFactory().createMethodElementFrom(method);
        EnterpriseBean ejb = this.getEnterpriseBeanFor(dd);
        element.setEnterpriseBean(ejb);
        element2.setEnterpriseBean(ejb);
        runAs.getMethodElements().add((Object)element);
        this.copyIsolationLevel(element2, cd);
        return runAs;
    }

    public void copyIsolationLevel(MethodElement me, ControlDescriptor cd) {
        EnterpriseBean ejb = me.getEnterpriseBean();
        EnterpriseBeanExtension ext = EjbExtensionsHelper.getEjbExtension(ejb);
        IsolationLevelAttributes attr = this.getEjbextFactory().createIsolationLevelAttributes();
        ext.getIsolationLevelAttributes().add((Object)attr);
        attr.getMethodElements().add((Object)me);
        if (cd.getIsolationLevel() == 2) {
            attr.setIsolationLevel(TxIsolationLevel.READ_COMMITTED_LITERAL);
        } else if (cd.getIsolationLevel() == 1) {
            attr.setIsolationLevel(TxIsolationLevel.READ_UNCOMMITTED_LITERAL);
        } else if (cd.getIsolationLevel() == 4) {
            attr.setIsolationLevel(TxIsolationLevel.REPEATABLE_READ_LITERAL);
        } else if (cd.getIsolationLevel() == 8) {
            attr.setIsolationLevel(TxIsolationLevel.SERIALIZABLE_LITERAL);
        }
    }

    protected EnterpriseBean createEnterpriseBeanFor(DeploymentDescriptor dd) {
        if (dd == null) {
            return null;
        }
        EnterpriseBean result = null;
        EnterpriseBean10ReadAdapter readAdapter = null;
        if (dd instanceof SessionDescriptor) {
            result = this.getEjbFactory().createSession();
            readAdapter = new Session10ReadAdapter((Notifier)result, dd);
        } else if (dd instanceof EntityDescriptor) {
            EntityDescriptor entityDD = (EntityDescriptor)dd;
            Field[] cmpFields = entityDD.getContainerManagedFields();
            if (cmpFields != null && cmpFields.length != 0) {
                result = this.getEjbFactory().createContainerManagedEntity();
                readAdapter = new ContainerManagedEntity10ReadAdapter((Notifier)result, dd);
            } else {
                result = this.getEjbFactory().createEntity();
                readAdapter = new Entity10ReadAdapter((Notifier)result, dd);
            }
        }
        String name = EJBJar10ImportStrategyImpl.getDefaultBeanNameFor(dd);
        result.setName(name);
        result.eAdapters().add((Object)readAdapter);
        return result;
    }

    public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
        return EJBJar10ImportStrategyImpl.getDiscriminator().createImportStrategy(old, newArchive);
    }

    protected EjbbndFactory getBindingsFactory() {
        return (EjbbndFactory)EjbbndFactoryImpl.getPackage().getEFactoryInstance();
    }

    public DDNames getDDNames() {
        return this.ddNames;
    }

    public static String getDefaultBeanNameFor(DeploymentDescriptor dd) {
        if (dd.getBeanHomeName() != null) {
            return dd.getBeanHomeName().toString().replace('/', '_');
        }
        String remoteName = dd.getRemoteInterfaceClassName();
        int index = remoteName.lastIndexOf(46);
        index = index == -1 ? 0 : index + 1;
        String ejbName = remoteName.substring(index);
        return ejbName;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static DeploymentDescriptor getDeploymentDescriptorFor(String name, Archive anArchive) throws StreamCorruptedException, NotADeploymentDescriptorException {
        DeploymentDescriptor result = null;
        ObjectInputStreamCustomResolver deserializer = null;
        InputStream ddIn = null;
        try {
            ddIn = anArchive.getInputStream(name);
        }
        catch (FileNotFoundException ex) {
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("manifest_dd_find_EXC_", new Object[]{name}), ex);
        }
        catch (IOException ex) {
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("io_ex_reading_dd_EXC_", new Object[]{name}), ex);
        }
        try {
            try {
                deserializer = new ObjectInputStreamCustomResolver(ddIn, anArchive.getArchiveClassLoader());
                Object o = deserializer.readObject();
                if (!(o instanceof DeploymentDescriptor)) {
                    throw new NotADeploymentDescriptorException(CommonArchiveResourceHandler.getString("ser_not_dd_EXC_", new Object[]{name}));
                }
                result = (DeploymentDescriptor)o;
            }
            catch (StreamCorruptedException ex) {
                throw ex;
            }
            catch (ClassNotFoundException ex) {
                EJBJar10ImportStrategyImpl.handleMissingClass(ex, name);
            }
            catch (NoClassDefFoundError error) {
                EJBJar10ImportStrategyImpl.handleMissingClass(error, name);
            }
            catch (Exception ex) {
                throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("reading_dd_EXC_", new Object[]{name}), ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            try {
                if (deserializer == null) throw throwable;
                deserializer.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_14 = null;
        }
        try {}
        catch (IOException iOException) {
            return result;
        }
        if (deserializer == null) return result;
        deserializer.close();
        return result;
    }

    public List getDeploymentDescriptorNames() {
        return this.ddNames.getNames();
    }

    public static DDNames getDeploymentDescriptorNames(Archive anArchive) {
        return EJBJar10ImportStrategyImpl.getDeploymentDescriptorNames(anArchive, false);
    }

    public static DDNames getDeploymentDescriptorNames(Archive anArchive, boolean sort) {
        boolean inferred = false;
        List ejbEntries = EJBJar10ImportStrategyImpl.getEJBEntries(anArchive.getManifest());
        if (sort) {
            Collections.sort(ejbEntries, Ejb10ManifestComparatorImpl.getSingleton());
        }
        List names = new ArrayList();
        if (!ejbEntries.isEmpty()) {
            int i = 0;
            while (i < ejbEntries.size()) {
                Map.Entry manifestEntry = (Map.Entry)ejbEntries.get(i);
                names.add(manifestEntry.getKey());
                ++i;
            }
        }
        if (names.size() == 0 && !anArchive.getLoadStrategy().isDirectory()) {
            names = EJBJar10ImportStrategyImpl.getInferredDeploymentDescriptorNames(anArchive);
            inferred = true;
        }
        return new DDNames(names, inferred);
    }

    public static DDNames getDeploymentDescriptorNamesSorted(Archive anArchive) {
        return EJBJar10ImportStrategyImpl.getDeploymentDescriptorNames(anArchive, true);
    }

    public Map getDeploymentDescriptors() {
        if (this.deploymentDescriptors == null) {
            this.deploymentDescriptors = new HashMap();
        }
        return this.deploymentDescriptors;
    }

    public static Map getDeploymentDescriptors(Archive anArchive, DDNames ddNames) {
        ArrayList names = new ArrayList(ddNames.getNames());
        int count = names.size();
        if (count == 0) {
            return null;
        }
        HashMap<String, Exception> failed = new HashMap<String, Exception>((int)((float)count / 0.75f));
        HashMap<String, DeploymentDescriptor> dds = new HashMap<String, DeploymentDescriptor>((int)((float)count / 0.75f));
        int i = 0;
        while (i < count) {
            String name = (String)names.get(i);
            try {
                dds.put(name, EJBJar10ImportStrategyImpl.getDeploymentDescriptorFor(name, anArchive));
            }
            catch (StreamCorruptedException ex) {
                EJBJar10ImportStrategyImpl.not_A_DD(ddNames, name, ex);
                failed.put(name, ex);
            }
            catch (NotADeploymentDescriptorException ex) {
                EJBJar10ImportStrategyImpl.not_A_DD(ddNames, name, ex);
                failed.put(name, ex);
            }
            catch (DeploymentDescriptorLoadException ex) {
                EJBJar10ImportStrategyImpl.not_A_DD(ddNames, name, ex);
                failed.put(name, ex);
            }
            ++i;
        }
        if (dds.isEmpty()) {
            throw new NoEJB10DescriptorsException();
        }
        if (!failed.isEmpty() && ddNames.isInferred()) {
            StringBuffer buff = new StringBuffer();
            buff.append(CommonArchiveResourceHandler.getString("inferred_dds_EXC_", new Object[]{anArchive.getName()}));
            buff.append(CommonArchiveResourceHandler.getString("_The_following_files_could_EXC_"));
            buff.append('\n');
            Iterator it = failed.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                buff.append(CommonArchiveResourceHandler.getString("filename_exception_EXC_", new Object[]{entry.getKey(), ((Exception)entry.getValue()).getMessage()}));
                buff.append('\n');
            }
            Logger.getLogger().logTrace(buff.toString());
        }
        return dds;
    }

    public static ArchiveTypeDiscriminator getDiscriminator() {
        if (discriminator == null) {
            discriminator = new Discriminator();
        }
        return discriminator;
    }

    public static List getEJBEntries(ArchiveManifest mf) {
        if (mf == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList ejbAtts = new ArrayList();
        Iterator i = mf.getEntries().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry manifestEntry = i.next();
            Attributes attr = (Attributes)manifestEntry.getValue();
            String ejbTag = ArchiveUtil.getValueIgnoreKeyCase("Enterprise-bean", attr);
            if (!"true".equalsIgnoreCase(ejbTag)) continue;
            ejbAtts.add(manifestEntry);
        }
        return ejbAtts;
    }

    public EjbextFactory getEjbextFactory() {
        return ((EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi")).getEjbextFactory();
    }

    protected EjbFactory getEjbFactory() {
        return ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory();
    }

    public EJBJar getEjbJar() {
        return this.getEJBJarFile().getDeploymentDescriptor();
    }

    public EJBJarFile getEJBJarFile() {
        return (EJBJarFile)this.getArchive();
    }

    public EnterpriseBean getEnterpriseBeanFor(DeploymentDescriptor dd) {
        return this.getEjbJar().getEnterpriseBeanNamed(EJBJar10ImportStrategyImpl.getDefaultBeanNameFor(dd));
    }

    protected EjbextFactory getExtensionsFactory() {
        return (EjbextFactory)EjbextFactoryImpl.getPackage().getEFactoryInstance();
    }

    public static List getInferredDeploymentDescriptorNames(Archive anArchive) {
        ArrayList<String> names = new ArrayList<String>();
        EList files = anArchive.getFiles();
        int i = 0;
        while (i < files.size()) {
            File aFile = (File)files.get(i);
            if (aFile.getURI().toLowerCase().endsWith(".ser")) {
                names.add(aFile.getURI());
            }
            ++i;
        }
        return names;
    }

    public static DDNames getLoadedDDNamesFrom(EJBJarFile anEJB10Jar) {
        EJBJar10ImportStrategy strat = (EJBJar10ImportStrategy)anEJB10Jar.getImportStrategy();
        return strat.getDDNames();
    }

    public static Map getLoadedDeploymentDescriptorsFrom(EJBJarFile anEJB10Jar) {
        EJBJar10ImportStrategy strat = (EJBJar10ImportStrategy)anEJB10Jar.getImportStrategy();
        return strat.getDeploymentDescriptors();
    }

    protected static void handleMissingClass(Throwable t, String ddName) throws DeploymentDescriptorLoadException {
        throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("missing_class_EXC_", new Object[]{ddName, t.getMessage()}));
    }

    public void importMetaData() throws Exception {
        EJBJarFile jarFile = (EJBJarFile)this.getArchive();
        XMLResource res = (XMLResource)jarFile.makeDeploymentDescriptorResource();
        res.setVersionID(12);
        ((XMIResource)jarFile.getDeploymentDescriptor().eResource()).setID((EObject)jarFile.getDeploymentDescriptor(), "ejb-jar_ID");
        jarFile.getDeploymentDescriptor().setDisplayName(ArchiveUtil.truncateIgnoreCase(jarFile.getName(), ".jar"));
        this.addEnterpriseBeans();
        this.addAssemblyDescriptor();
        this.addBindings();
        this.addExtensions();
        jarFile.reflectFinderDescriptorsIfNecessary();
    }

    public boolean isEJB10() {
        return true;
    }

    protected static void not_A_DD(DDNames ddNames, String name, DeploymentDescriptorLoadException nested) {
        if (!ddNames.isInferred()) {
            throw nested;
        }
        ddNames.getNames().remove(name);
    }

    protected static void not_A_DD(DDNames ddNames, String name, Exception nested) {
        if (!ddNames.isInferred()) {
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("manifest_dd_load_EXC_", new Object[]{name}), nested);
        }
        ddNames.getNames().remove(name);
    }

    public void setDDNames(DDNames newDdNames) {
        this.ddNames = newDdNames;
    }

    public void setDeploymentDescriptors(Map newDeploymentDescriptors) {
        this.deploymentDescriptors = newDeploymentDescriptors;
    }

    public static class Discriminator
    extends ArchiveTypeDiscriminatorImpl {
        public Archive convert(Archive anArchive) throws OpenFailureException {
            try {
                return super.convert(anArchive);
            }
            catch (NoEJB10DescriptorsException noEJB10DescriptorsException) {
                return null;
            }
        }

        public boolean canImport(Archive anArchive) {
            return !EJBJar10ImportStrategyImpl.getDeploymentDescriptorNames(anArchive).getNames().isEmpty();
        }

        public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
            EJBJar10ImportStrategyImpl strat = new EJBJar10ImportStrategyImpl();
            DDNames ddNames = EJBJar10ImportStrategyImpl.getDeploymentDescriptorNamesSorted(newArchive);
            strat.setDDNames(ddNames);
            strat.setDeploymentDescriptors(EJBJar10ImportStrategyImpl.getDeploymentDescriptors(newArchive, ddNames));
            return strat;
        }

        public String getUnableToOpenMessage() {
            return CommonArchiveResourceHandler.getString("Archive_is_not_a_valid_EJB_EXC_");
        }

        public Archive createConvertedArchive() {
            return ImportStrategyImpl.getArchiveFactory().createEJBJarFile();
        }

        public Archive openArchive(Archive anArchive) throws OpenFailureException {
            Archive result = super.openArchive(anArchive);
            if (result == anArchive) {
                return null;
            }
            return result;
        }
    }
}

