/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.jms.JMSResourceRefBuilder;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.jms.JMSProvider;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASTopic;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.JMSBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import java.io.Serializable;
import java.util.Properties;
import javax.naming.Referenceable;

public class WASTopicBinder
extends JMSBinder {
    private static TraceComponent tc = Tr.register((Class)WASTopicBinder.class, (String)"ResourceBinders", (String)"com.ibm.ejs.jms.messaging");

    public boolean isUsedFor(J2EEResourceFactory j2EEResourceFactory) {
        boolean bl = false;
        if (j2EEResourceFactory instanceof WASTopic) {
            WASTopicBinder.testForMqInstallation();
            if (mqDisabled) {
                if (!this.wasUsed) {
                    Tr.error((TraceComponent)tc, (String)"WASBindersDisabled");
                    this.wasUsed = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public Object getBindingObject(J2EEResourceFactory j2EEResourceFactory) throws ResourceBindingException {
        Number number;
        Serializable serializable;
        if (!mqTraceInitialised) {
            serializable = ConfigEnvironment.class;
            mqTraceInitialised = true;
        }
        serializable = new Properties();
        WASTopic wASTopic = (WASTopic)j2EEResourceFactory;
        JMSProvider jMSProvider = (JMSProvider)wASTopic.getProvider();
        this.addPropertySet((Properties)serializable, j2EEResourceFactory.getPropertySet(), true);
        this.addPropertySet((Properties)serializable, jMSProvider.getPropertySet(), true);
        String string = wASTopic.getName();
        if (string == null || string.length() <= 0) {
            throw new ResourceBindingException("WASTopic can not be bound as no name has been specified.");
        }
        this.setProperty((Properties)serializable, "NAME", string, true);
        this.setProperty((Properties)serializable, "DESC", wASTopic.getDescription(), true);
        String string2 = wASTopic.getTopic();
        this.checkRequiredProperty(string2, "WASTopic " + string + " can not be bound as no topic property has been specified.");
        this.setProperty((Properties)serializable, "TOP", string2, true);
        Object object = string2 = wASTopic.isSetPersistence() ? wASTopic.getPersistence() : null;
        if (string2 != null) {
            this.setProperty((Properties)serializable, "PER", new Integer(wASTopic.getPersistence().getValue()), true);
        } else {
            this.setProperty((Properties)serializable, "PER", new Integer(-2), true);
        }
        Object object2 = string2 = wASTopic.isSetPriority() ? wASTopic.getPriority() : null;
        if (string2 != null) {
            if (wASTopic.getPriority().getValue() == -2) {
                this.setProperty((Properties)serializable, "PRI", new Integer(wASTopic.getPriority().getValue()), true);
            } else {
                number = wASTopic.isSetSpecifiedPriority() ? new Integer(wASTopic.getSpecifiedPriority()) : null;
                this.checkRequiredProperty(number, "WASTopic " + string + " can not be bound as specifiedPriority is required if priority=SPECIFIED.");
                this.setProperty((Properties)serializable, "PRI", number, true);
            }
        } else {
            this.setProperty((Properties)serializable, "PRI", new Integer(-2), true);
        }
        Object object3 = string2 = wASTopic.isSetExpiry() ? wASTopic.getExpiry() : null;
        if (string2 != null) {
            int n = wASTopic.getExpiry().getValue();
            if (n == -2 || n == 0) {
                this.setProperty((Properties)serializable, "EXP", new Long(n), true);
            } else {
                number = wASTopic.isSetSpecifiedExpiry() ? new Long(wASTopic.getSpecifiedExpiry()) : null;
                this.checkRequiredProperty(number, "WASTopic " + string + " can not be bound as specifiedExpiry is required if expiry=SPECIFIED.");
                this.setProperty((Properties)serializable, "EXP", number, true);
            }
        } else {
            this.setProperty((Properties)serializable, "EXP", new Integer(-2), true);
        }
        JMSResourceRefBuilder jMSResourceRefBuilder = JMSResourceRefBuilderFactory.createJMSResourceRefBuilder();
        Referenceable referenceable = null;
        try {
            referenceable = jMSResourceRefBuilder.createEmbeddedTopicReferenceable((Properties)serializable);
        }
        catch (ResourceBindingException resourceBindingException) {
            FFDCFilter.processException((Throwable)resourceBindingException, (String)"com.ibm.ws.runtime.component.binder.WASTopicBinder.getBindingObject", (String)"114", (Object)((Object)this));
            throw resourceBindingException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.runtime.component.binder.WASTopicBinder.getBindingObject", (String)"119", (Object)((Object)this));
            throw new ResourceBindingException(throwable.toString());
        }
        return referenceable;
    }
}

