/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.command.CommandException;
import com.ibm.websphere.command.CommandTarget;
import com.ibm.websphere.command.TargetPolicy;
import com.ibm.websphere.command.TargetPolicyDefault;
import com.ibm.websphere.command.TargetableCommand;
import com.ibm.websphere.command.UnsetInputPropertiesException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public abstract class TargetableCommandImpl
implements TargetableCommand {
    private static final TraceComponent _tc = Tr.register((Class)TargetableCommandImpl.class);
    public static String LOCAL = "com.ibm.websphere.command.LocalTarget";
    protected static TargetPolicy targetPolicy = new TargetPolicyDefault();
    protected transient CommandTarget commandTarget = null;
    protected String commandTargetName = null;
    protected boolean hasOutputProperties = true;

    public void execute() throws CommandException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"execute");
        }
        if (!this.isReadyToCallExecute()) {
            UnsetInputPropertiesException unsetInputPropertiesException = new UnsetInputPropertiesException();
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"execute", (Object)((Object)unsetInputPropertiesException));
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"execute", (Object)"The command is not ready to execute");
            }
            throw unsetInputPropertiesException;
        }
        try {
            if (targetPolicy == null) {
                IllegalStateException illegalStateException = new IllegalStateException("TargetPolicy is not set");
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)"execute", (Object)illegalStateException);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"execute", (Object)"Target policy is null");
                }
                throw illegalStateException;
            }
            CommandTarget commandTarget = targetPolicy.getCommandTarget(this);
            TargetableCommand targetableCommand = commandTarget.executeCommand(this);
            if (this.hasOutputProperties() && this != targetableCommand) {
                if (targetableCommand == null) {
                    CommandException commandException = new CommandException("Command returned from CommandTarget was null and this command has output properties.");
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"execute", (Object)((Object)commandException));
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"execute", (Object)"returned command is null");
                    }
                    throw commandException;
                }
                this.setOutputProperties(targetableCommand);
            }
        }
        catch (CommandException commandException) {
            FFDCFilter.processException((Throwable)((Object)commandException), (String)"com.ibm.websphere.command.TargetableCommandImpl.execute", (String)"133", (Object)this);
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"execute", (Object)((Object)commandException));
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"execute", (Object)((Object)commandException));
            }
            throw commandException;
        }
        catch (Exception exception) {
            Object object;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.command.TargetableCommandImpl.execute", (String)"137", (Object)this);
            if (exception instanceof RemoteException) {
                object = (RemoteException)exception;
                if (object.detail != null) {
                    CommandException commandException = new CommandException(object.detail);
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"execute", (Object)((Object)commandException));
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"execute", (Object)((Object)commandException));
                    }
                    throw commandException;
                }
            }
            object = new CommandException(exception);
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"execute", (Object)object);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"execute", (Object)object);
            }
            throw object;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"execute");
        }
    }

    public CommandTarget getCommandTarget() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getCommandTarget");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getCommandTarget", (Object)this.commandTarget);
        }
        return this.commandTarget;
    }

    public String getCommandTargetName() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getCommandTargetName");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getCommandTargetName", (Object)this.commandTargetName);
        }
        return this.commandTargetName;
    }

    public static TargetPolicy getTargetPolicy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getTargetPolicy");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getTargetPolicy", (Object)targetPolicy);
        }
        return targetPolicy;
    }

    public final boolean hasOutputProperties() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"hasOutputProperties");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"hasOutputProperties", (Object)new Boolean(this.hasOutputProperties));
        }
        return this.hasOutputProperties;
    }

    public abstract boolean isReadyToCallExecute();

    public abstract void performExecute() throws Exception;

    public abstract void reset();

    public void setCommandTarget(CommandTarget commandTarget) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"setCommandTarget", (Object)commandTarget);
        }
        this.commandTarget = commandTarget;
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"setCommandTarget");
        }
    }

    public void setCommandTargetName(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"setCommandTargetName", (Object)string);
        }
        this.commandTargetName = string;
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"setCommandTargetName");
        }
    }

    public final void setHasOutputProperties(boolean bl) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"setHasOutputProperties", (Object)new Boolean(bl));
        }
        this.hasOutputProperties = bl;
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"setHasOutputProperties");
        }
    }

    public void setOutputProperties(final TargetableCommand targetableCommand) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"setOutputProperties", (Object)targetableCommand);
        }
        try {
            final Class<?> clazz = this.getClass();
            final TargetableCommandImpl targetableCommandImpl = this;
            if (!targetableCommand.getClass().equals(clazz)) {
                IllegalStateException illegalStateException = new IllegalStateException("fromCommand is not of the same class");
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)"setOutputProperties", (Object)illegalStateException);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"setOutputProperties", (Object)"fromCommand is not of the same class");
                }
                throw illegalStateException;
            }
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
                    Field.setAccessible(accessibleObjectArray, true);
                    for (int i = 0; i < accessibleObjectArray.length; ++i) {
                        int n = ((Field)accessibleObjectArray[i]).getModifiers();
                        if (Modifier.isFinal(n) || Modifier.isTransient(n) || Modifier.isStatic(n)) continue;
                        ((Field)accessibleObjectArray[i]).set(targetableCommandImpl, ((Field)accessibleObjectArray[i]).get(targetableCommand));
                    }
                    Field.setAccessible(accessibleObjectArray, false);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.websphere.command.TargetableCommandImpl.setOutputProperties", (String)"371", (Object)this);
            IllegalStateException illegalStateException = new IllegalStateException("Since not all your variables are public in your command, you need to override the default implementation of TargetableCommand.setOutputProperties().");
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"setOutputProperties", (Object)illegalStateException);
            }
            throw illegalStateException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"setOutputProperties");
        }
    }

    public static void setTargetPolicy(TargetPolicy targetPolicy) {
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"setTargetPolicy", (Object)targetPolicy);
        }
        TargetableCommandImpl.targetPolicy = targetPolicy;
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"setTargetPolicy");
        }
    }
}

