/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.csi.PoolImplBase;
import com.ibm.ejs.csi.PoolImplThreadSafe;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.csi.Pool;
import com.ibm.websphere.csi.PoolDiscardStrategy;
import com.ibm.websphere.csi.PoolManager;
import com.ibm.websphere.pmi.PmiBean;
import java.util.Vector;

public class PoolManagerImpl
extends PoolManager
implements AlarmListener {
    private Vector pools;
    private int previousNumPools = 10;
    private PoolImplBase[] poolArray = new PoolImplBase[10];
    private long drainInterval = 30000L;

    public void setDrainInterval(long l) {
        this.drainInterval = l;
    }

    public void alarm(Object object) {
        int n;
        int n2 = this.pools.size();
        if (n2 > 0) {
            if (n2 > this.previousNumPools) {
                this.poolArray = new PoolImplBase[n2];
                this.previousNumPools = n2;
            }
            this.poolArray = this.pools.toArray(this.poolArray);
            for (n = 0; n < this.poolArray.length && this.poolArray[n] != null; ++n) {
                if (this.poolArray[n].inactive) {
                    this.poolArray[n].periodicDrain();
                    continue;
                }
                this.poolArray[n].inactive = true;
            }
        }
        for (n = n2; n < this.poolArray.length; ++n) {
            this.poolArray[n] = null;
        }
        AlarmManager.create((long)this.drainInterval, (AlarmListener)this, null);
    }

    public PoolManagerImpl() {
        this.pools = new Vector();
        AlarmManager.create((long)this.drainInterval, (AlarmListener)this, null);
    }

    void remove(Pool pool) {
        this.pools.removeElement(pool);
    }

    public Pool createThreadSafePool(int n, int n2) {
        PoolImplThreadSafe poolImplThreadSafe = new PoolImplThreadSafe(n, n2, 20, null, null, this);
        this.pools.addElement(poolImplThreadSafe);
        return poolImplThreadSafe;
    }

    public Pool createThreadSafePool(int n, int n2, PmiBean pmiBean) {
        PoolImplThreadSafe poolImplThreadSafe = new PoolImplThreadSafe(n, n2, 20, pmiBean, null, this);
        this.pools.addElement(poolImplThreadSafe);
        return poolImplThreadSafe;
    }

    public Pool create(int n, int n2, PmiBean pmiBean, PoolDiscardStrategy poolDiscardStrategy) {
        PoolImplThreadSafe poolImplThreadSafe = new PoolImplThreadSafe(n, n2, 20, pmiBean, poolDiscardStrategy, this);
        this.pools.addElement(poolImplThreadSafe);
        return poolImplThreadSafe;
    }
}

